/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.helper;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.ReaderResource;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.svl.VarResolverSession;

public class ResolvingReaderResource
extends ReaderResource {
    private final VarResolverSession varSession;

    protected ResolvingReaderResource(Builder b) throws IOException {
        this(b.mediaType, b.headers, b.cached, b.varResolver, b.contents.toArray());
    }

    public ResolvingReaderResource(MediaType mediaType, Map<String, Object> headers, boolean cached, VarResolverSession varSession, Object ... contents) throws IOException {
        super(mediaType, headers, cached, contents);
        this.varSession = varSession;
    }

    public static Builder create() {
        return new Builder();
    }

    @ResponseBody
    public Writer writeTo(Writer w) throws IOException {
        for (Object o : this.contents) {
            if (o == null) continue;
            if (this.varSession == null) {
                IOUtils.pipe((Object)o, (Writer)w);
                continue;
            }
            this.varSession.resolveTo(IOUtils.read((Object)o), w);
        }
        return w;
    }

    public static class Builder
    extends ReaderResource.Builder {
        VarResolverSession varResolver;

        public Builder varResolver(VarResolverSession varResolver) {
            this.varResolver = varResolver;
            return this;
        }

        public Builder mediaType(String mediaType) {
            super.mediaType(mediaType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            super.mediaType(mediaType);
            return this;
        }

        public Builder contents(Object ... contents) {
            super.contents(contents);
            return this;
        }

        public Builder header(String name, Object value) {
            super.header(name, value);
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            super.headers(headers);
            return this;
        }

        public Builder cached() {
            super.cached();
            return this;
        }

        public ResolvingReaderResource build() throws IOException {
            return new ResolvingReaderResource(this);
        }
    }
}

