/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlCommon;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlParserBuilder;
import org.apache.juneau.html.HtmlParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.xml.XmlParser;

@ConfigurableContext
public class HtmlParser
extends XmlParser
implements HtmlMetaProvider,
HtmlCommon {
    static final String PREFIX = "HtmlParser";
    public static final HtmlParser DEFAULT = new HtmlParser(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, HtmlClassMeta> htmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, HtmlBeanPropertyMeta> htmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, HtmlBeanPropertyMeta>();

    public HtmlParser(PropertyStore ps) {
        super(ps, "text/html", "text/html+stripped");
    }

    @Override
    public HtmlParserBuilder builder() {
        return new HtmlParserBuilder(this.getPropertyStore());
    }

    public static HtmlParserBuilder create() {
        return new HtmlParserBuilder();
    }

    @Override
    public HtmlParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public HtmlParserSession createSession(ParserSessionArgs args) {
        return new HtmlParserSession(this, args);
    }

    @Override
    public HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        HtmlClassMeta m = this.htmlClassMetas.get(cm);
        if (m == null) {
            m = new HtmlClassMeta(cm, this);
            this.htmlClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return HtmlBeanPropertyMeta.DEFAULT;
        }
        HtmlBeanPropertyMeta m = this.htmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new HtmlBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.htmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

