/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.util.Map;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.juneau.marshall.Html;
import org.apache.juneau.marshall.Json;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.marshall.MsgPack;
import org.apache.juneau.marshall.OpenApi;
import org.apache.juneau.marshall.PlainText;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.marshall.Uon;
import org.apache.juneau.marshall.UrlEncoding;
import org.apache.juneau.marshall.Xml;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestClientBuilder;
import org.apache.juneau.rest.mock2.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock2.MockRest;
import org.apache.juneau.serializer.Serializer;

public class MockRemote<T> {
    private MockRest.Builder mrb;
    private RestClientBuilder rcb = RestClient.create().json();
    private final Class<T> intf;

    protected MockRemote(Class<T> intf, Object impl) {
        this.intf = intf;
        this.mrb = MockRest.create(impl);
    }

    public static <T> MockRemote<T> create(Class<T> intf, Object impl) {
        return new MockRemote<T>(intf, impl);
    }

    public static <T> MockRemote<T> create(Class<T> intf, Object impl, Marshall m) {
        return new MockRemote<T>(intf, impl).marshall(m);
    }

    public static <T> MockRemote<T> create(Class<T> intf, Object impl, Serializer s, Parser p) {
        return new MockRemote<T>(intf, impl).serializer(s).parser(p);
    }

    public T build() {
        MockRest mr = this.mrb.build();
        return (T)this.rcb.httpClientConnectionManager((HttpClientConnectionManager)new MockHttpClientConnectionManager(mr)).rootUrl((Object)"http://localhost").headers(mr.getHeaders()).build().getRemote(this.intf);
    }

    public static <T> T build(Class<T> intf, Object impl) {
        return MockRemote.create(intf, impl).build();
    }

    public static <T> T build(Class<T> intf, Object impl, Marshall m) {
        return MockRemote.create(intf, impl).marshall(m).build();
    }

    public static <T> T build(Class<T> intf, Object impl, Serializer s, Parser p) {
        return MockRemote.create(intf, impl).serializer(s).parser(p).build();
    }

    public MockRemote<T> debug() {
        this.mrb.debug();
        this.rcb.debug();
        return this;
    }

    public MockRemote<T> header(String name, Object value) {
        this.mrb.header(name, value);
        this.rcb.header(name, value);
        return this;
    }

    public MockRemote<T> headers(Map<String, Object> value) {
        this.mrb.headers(value);
        this.rcb.headers(value);
        return this;
    }

    public MockRemote<T> accept(String value) {
        this.mrb.accept(value);
        this.rcb.accept((Object)value);
        return this;
    }

    public MockRemote<T> contentType(String value) {
        this.mrb.contentType(value);
        this.rcb.contentType((Object)value);
        return this;
    }

    public MockRemote<T> json() {
        this.marshall((Marshall)Json.DEFAULT);
        return this;
    }

    public MockRemote<T> simpleJson() {
        this.marshall((Marshall)SimpleJson.DEFAULT);
        return this;
    }

    public MockRemote<T> xml() {
        this.marshall((Marshall)Xml.DEFAULT);
        return this;
    }

    public MockRemote<T> html() {
        this.marshall((Marshall)Html.DEFAULT);
        return this;
    }

    public MockRemote<T> plainText() {
        this.marshall((Marshall)PlainText.DEFAULT);
        return this;
    }

    public MockRemote<T> msgpack() {
        this.marshall((Marshall)MsgPack.DEFAULT);
        return this;
    }

    public MockRemote<T> uon() {
        this.marshall((Marshall)Uon.DEFAULT);
        return this;
    }

    public MockRemote<T> urlEnc() {
        this.marshall((Marshall)UrlEncoding.DEFAULT);
        return this;
    }

    public MockRemote<T> openapi() {
        this.marshall((Marshall)OpenApi.DEFAULT);
        return this;
    }

    public MockRemote<T> marshall(Marshall value) {
        if (value != null) {
            this.serializer(value.getSerializer()).parser(value.getParser());
        } else {
            this.serializer(null).parser(null);
        }
        return this;
    }

    public MockRemote<T> serializer(Serializer value) {
        this.rcb.serializer(value);
        this.contentType(value == null ? null : value.getPrimaryMediaType().toString());
        return this;
    }

    public MockRemote<T> parser(Parser value) {
        this.rcb.parser(value);
        this.accept(value == null ? null : value.getPrimaryMediaType().toString());
        return this;
    }
}

