/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Contact;

public class ContactAnnotation {
    public static final Contact DEFAULT = ContactAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(Contact a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private String email = "";
        private String name = "";
        private String url = "";

        protected Builder() {
            super(Contact.class);
        }

        public Contact build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder email(String value) {
            this.email = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements Contact {
        private final String[] description;
        private final String email;
        private final String name;
        private final String url;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.email = b.email;
            this.name = b.name;
            this.url = b.url;
        }

        @Override
        public String email() {
            return this.email;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

