/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.commons.io.StringBuilderWriter;
import org.apache.juneau.commons.lang.AsciiMap;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlNs;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlUtils {
    private static AsciiMap REPLACE_TEXT = new AsciiMap().append('&', "&amp;").append('<', "&lt;").append('>', "&gt;").append('\t', "&#x0009;").append('\n', "&#x000a;").append('\r', "&#x000d;");
    private static AsciiMap REPLACE_ATTR_VAL = new AsciiMap().append('&', "&amp;").append('<', "&lt;").append('>', "&gt;").append('\"', "&quot;").append('\'', "&apos;").append('\t', "&#x0009;").append('\n', "&#x000a;").append('\r', "&#x000d;");

    public static LinkedList<Object> collapseTextNodes(LinkedList<Object> value) {
        Object prev = null;
        ListIterator<Object> i = value.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof String) {
                String o2 = (String)o;
                if (prev == null) {
                    prev = o2.toString();
                    continue;
                }
                prev = (String)prev + o2;
                i.remove();
                i.previous();
                i.remove();
                i.add(prev);
                continue;
            }
            prev = null;
        }
        return value;
    }

    public static String decode(String value, StringBuilder sb) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || value.indexOf(95) == -1) {
            return value;
        }
        if (sb == null) {
            sb = new StringBuilder(value.length());
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '_' && XmlUtils.isEscapeSequence(value, i)) {
                int x = Integer.parseInt(value.substring(i + 2, i + 6), 16);
                if (x == 0) {
                    return null;
                }
                if (x != 57344) {
                    sb.append((char)x);
                }
                i += 6;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Writer encodeAttrName(Writer w, Object value) throws IOException {
        if (value == null) {
            return w.append("_x0000_");
        }
        String s = value.toString();
        if (XmlUtils.needsAttrNameEncoding(s)) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (i == 0) {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':') {
                        w.append(c);
                        continue;
                    }
                    if (c == '_' && !XmlUtils.isEscapeSequence(s, i)) {
                        w.append(c);
                        continue;
                    }
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':') {
                    w.append(c);
                    continue;
                }
                if (c == '_' && !XmlUtils.isEscapeSequence(s, i)) {
                    w.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(w, c);
            }
        } else {
            w.append(s);
        }
        return w;
    }

    public static Writer encodeAttrValue(Writer w, Object value, boolean trim) {
        try {
            if (value == null) {
                return w.append("_x0000_");
            }
            String s = value.toString();
            if (s.isEmpty()) {
                return w;
            }
            if (trim) {
                s = s.trim();
            }
            if (XmlUtils.needsAttrValueEncoding(s)) {
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char c = s.charAt(i);
                    if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                        XmlUtils.appendPaddedHexChar(w, c);
                        continue;
                    }
                    if (REPLACE_ATTR_VAL.contains(c)) {
                        w.append(REPLACE_ATTR_VAL.get(c));
                        continue;
                    }
                    if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                        XmlUtils.appendPaddedHexChar(w, c);
                        continue;
                    }
                    if (XmlUtils.isValidXmlCharacter(c)) {
                        w.append(c);
                        continue;
                    }
                    XmlUtils.appendPaddedHexChar(w, c);
                }
            } else {
                w.append(s);
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
        return w;
    }

    public static String encodeElementName(Object value) {
        String s;
        block9: {
            String string;
            if (value == null) {
                return "_x0000_";
            }
            s = value.toString();
            if (s.isEmpty()) {
                return "_xE000_";
            }
            if (!XmlUtils.needsElementNameEncoding(s)) break block9;
            StringBuilderWriter w = new StringBuilderWriter(s.length() * 2);
            try {
                string = XmlUtils.encodeElementNameInner((Writer)w, s).toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ThrowableUtils.toRex((Throwable)e);
                }
            }
            w.close();
            return string;
        }
        return s;
    }

    public static Writer encodeElementName(Writer w, Object value) {
        try {
            if (value == null) {
                return w.append("_x0000_");
            }
            String s = value.toString();
            if (XmlUtils.needsElementNameEncoding(s)) {
                return XmlUtils.encodeElementNameInner(w, s);
            }
            w.append(s);
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
        return w;
    }

    public static Writer encodeText(Writer w, Object value, boolean trim, boolean preserveWhitespace) {
        try {
            if (value == null) {
                return w.append("_x0000_");
            }
            String s = value.toString();
            if (s.isEmpty()) {
                return w.append("_xE000_");
            }
            if (trim) {
                s = s.trim();
            }
            if (XmlUtils.needsTextEncoding(s)) {
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char c = s.charAt(i);
                    if ((i == 0 || i == len - 1) && Character.isWhitespace(c) && !preserveWhitespace) {
                        XmlUtils.appendPaddedHexChar(w, c);
                        continue;
                    }
                    if (REPLACE_TEXT.contains(c)) {
                        w.append(REPLACE_TEXT.get(c));
                        continue;
                    }
                    if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                        XmlUtils.appendPaddedHexChar(w, c);
                        continue;
                    }
                    if (XmlUtils.isValidXmlCharacter(c)) {
                        w.append(c);
                        continue;
                    }
                    XmlUtils.appendPaddedHexChar(w, c);
                }
            } else {
                w.append(s);
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
        return w;
    }

    public static String escapeText(Object value) {
        if (value == null) {
            return "_x0000_";
        }
        String s = value.toString();
        try {
            if (!XmlUtils.needsTextEncoding(s)) {
                return s;
            }
            int len = s.length();
            StringWriter sw = new StringWriter(s.length() * 2);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                    XmlUtils.appendPaddedHexChar(sw, c);
                    continue;
                }
                if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                    XmlUtils.appendPaddedHexChar(sw, c);
                    continue;
                }
                if (XmlUtils.isValidXmlCharacter(c)) {
                    sw.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(sw, c);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    public static Namespace findNamespace(List<Xml> xmls, List<XmlSchema> schemas) {
        Namespace ns;
        int i;
        for (i = xmls.size() - 1; i >= 0; --i) {
            Xml xml = xmls.get(i);
            ns = XmlUtils.findNamespace(xml.prefix(), xml.namespace(), xmls, schemas);
            if (!Utils.nn((Object)ns)) continue;
            return ns;
        }
        for (i = schemas.size() - 1; i >= 0; --i) {
            XmlSchema schema = schemas.get(i);
            ns = XmlUtils.findNamespace(schema.prefix(), schema.namespace(), null, schemas);
            if (!Utils.nn((Object)ns)) continue;
            return ns;
        }
        return null;
    }

    public static String toReadableEvent(XMLStreamReader r) {
        int t = r.getEventType();
        if (t == 1) {
            return "<" + r.getLocalName() + ">";
        }
        if (t == 2) {
            return "</" + r.getLocalName() + ">";
        }
        if (t == 3) {
            return "PROCESSING_INSTRUCTION";
        }
        if (t == 4) {
            return "CHARACTERS=[" + r.getText() + "]";
        }
        if (t == 5) {
            return "COMMENTS=[" + r.getText() + "]";
        }
        if (t == 6) {
            return "SPACE=[" + r.getText() + "]";
        }
        if (t == 7) {
            return "START_DOCUMENT";
        }
        if (t == 8) {
            return "END_DOCUMENT";
        }
        if (t == 9) {
            return "ENTITY_REFERENCE";
        }
        if (t == 10) {
            return "ATTRIBUTE";
        }
        if (t == 11) {
            return "DTD";
        }
        if (t == 12) {
            return "CDATA=[" + r.getText() + "]";
        }
        if (t == 13) {
            return "NAMESPACE";
        }
        if (t == 14) {
            return "NOTATION_DECLARATION";
        }
        if (t == 15) {
            return "ENTITY_DECLARATION";
        }
        return "UNKNOWN";
    }

    private static Writer appendPaddedHexChar(Writer out, int num) throws IOException {
        out.append("_x");
        for (char c : StringUtils.toHex4((int)num)) {
            out.append(c);
        }
        return out.append('_');
    }

    private static Writer encodeElementNameInner(Writer w, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' && !XmlUtils.isEscapeSequence(s, i) || c >= 'a' && c <= 'z' || i != 0 && (c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040') || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd') {
                w.append(c);
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static Namespace findNamespace(String prefix, String ns, List<Xml> xmls, List<XmlSchema> schemas) {
        if (!prefix.isEmpty() && !ns.isEmpty()) {
            return Namespace.of(prefix, ns);
        }
        if (!prefix.isEmpty()) {
            if (Utils.nn(xmls)) {
                for (Xml xml2 : xmls) {
                    if (!xml2.prefix().equals(prefix) || xml2.namespace().isEmpty()) continue;
                    return Namespace.of(prefix, xml2.namespace());
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.prefix().equals(prefix) && !schema.namespace().isEmpty()) {
                    return Namespace.of(prefix, schema.namespace());
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.prefix().equals(prefix)) continue;
                    return Namespace.of(prefix, xmlNs.namespaceURI());
                }
            }
            throw ThrowableUtils.bex((String)"Found @Xml.prefix annotation with no matching URI.  prefix=''{0}''", (Object[])new Object[]{prefix});
        }
        if (!ns.isEmpty()) {
            if (Utils.nn(xmls)) {
                for (Xml xml2 : xmls) {
                    if (!xml2.namespace().equals(ns) || xml2.prefix().isEmpty()) continue;
                    return Namespace.of(xml2.prefix(), ns);
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.namespace().equals(ns) && !schema.prefix().isEmpty()) {
                    return Namespace.of(schema.prefix(), ns);
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.namespaceURI().equals(ns)) continue;
                    return Namespace.of(xmlNs.prefix(), ns);
                }
            }
        }
        return null;
    }

    private static boolean isEscapeSequence(String s, int i) {
        return s.length() > i + 6 && s.charAt(i) == '_' && s.charAt(i + 1) == 'x' && XmlUtils.isHexCharacter(s.charAt(i + 2)) && XmlUtils.isHexCharacter(s.charAt(i + 3)) && XmlUtils.isHexCharacter(s.charAt(i + 4)) && XmlUtils.isHexCharacter(s.charAt(i + 5)) && s.charAt(i + 6) == '_';
    }

    private static boolean isHexCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }

    private static boolean isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    private static boolean needsAttrNameEncoding(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (i != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) continue;
            return true;
        }
        return false;
    }

    private static boolean needsAttrValueEncoding(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                return true;
            }
            if (!REPLACE_ATTR_VAL.contains(c) && XmlUtils.isValidXmlCharacter(c) && (c != '_' || !XmlUtils.isEscapeSequence(value, i))) continue;
            return true;
        }
        return false;
    }

    private static boolean needsElementNameEncoding(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (i != 0 || c < '0' || c > '9')) continue;
            return true;
        }
        return false;
    }

    private static boolean needsTextEncoding(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                return true;
            }
            if (!REPLACE_TEXT.contains(c) && XmlUtils.isValidXmlCharacter(c) && (c != '_' || !XmlUtils.isEscapeSequence(value, i))) continue;
            return true;
        }
        return false;
    }
}

