/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.http.header.EntityTag;

@Header(value="If-Range")
public class IfRange
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "If-Range";
    private final EntityTag value;
    private final Supplier<?> supplier;

    public static IfRange of(EntityTag value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(String value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(Supplier<?> value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(ZonedDateTime value) {
        return value == null ? null : new IfRange(value);
    }

    private static boolean isEtag(String s) {
        return s.startsWith("\"") || s.startsWith("W/");
    }

    public IfRange(EntityTag value) {
        super(NAME, (String)null);
        this.value = value;
        this.supplier = null;
    }

    public IfRange(String value) {
        super(NAME, IfRange.isEtag(value) ? null : value);
        this.value = IfRange.isEtag(value) ? EntityTag.of(value) : null;
        this.supplier = null;
    }

    public IfRange(Supplier<?> value) {
        super(NAME, (String)null);
        this.value = null;
        this.supplier = value;
    }

    public IfRange(ZonedDateTime value) {
        super(NAME, value);
        this.value = null;
        this.supplier = null;
    }

    public Optional<EntityTag> asEntityTag() {
        if (Utils.nn(this.supplier)) {
            EntityTag o2;
            Object o = this.supplier.get();
            return Utils.opt(o instanceof EntityTag ? (o2 = (EntityTag)o) : null);
        }
        return Utils.opt(this.value);
    }

    @Override
    public String getValue() {
        if (Utils.nn(this.supplier)) {
            Object o = this.supplier.get();
            if (o == null) {
                return null;
            }
            if (o instanceof EntityTag) {
                EntityTag o2 = (EntityTag)o;
                return o2.toString();
            }
            if (o instanceof ZonedDateTime) {
                ZonedDateTime o2 = (ZonedDateTime)o;
                return DateTimeFormatter.RFC_1123_DATE_TIME.format(o2);
            }
            throw ThrowableUtils.rex("Invalid object type returned by supplier: {0}", Utils.cn(o));
        }
        if (Utils.nn(this.value)) {
            return Utils.s(this.value);
        }
        return super.getValue();
    }
}

