/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class PartitionRecordJsonConverter {
    public static PartitionRecord read(JsonNode _node, short _version) {
        PartitionRecord _object = new PartitionRecord();
        JsonNode _partitionIdNode = _node.get("partitionId");
        if (_partitionIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionId', which is mandatory in version " + _version);
        }
        _object.partitionId = MessageUtil.jsonNodeToInt((JsonNode)_partitionIdNode, (String)"PartitionRecord");
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("PartitionRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _replicasNode = _node.get("replicas");
        if (_replicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'replicas', which is mandatory in version " + _version);
        }
        if (!_replicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<Integer> _collection = new ArrayList<Integer>(_replicasNode.size());
        _object.replicas = _collection;
        for (Object _element : _replicasNode) {
            _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _isrNode = _node.get("isr");
        if (_isrNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'isr', which is mandatory in version " + _version);
        }
        if (!_isrNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<Integer> _collection2 = new ArrayList<Integer>(_isrNode.size());
        _object.isr = _collection2;
        for (Object _element : _isrNode) {
            _collection2.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _removingReplicasNode = _node.get("removingReplicas");
        if (_removingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'removingReplicas', which is mandatory in version " + _version);
        }
        if (!_removingReplicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<Integer> _collection3 = new ArrayList<Integer>(_removingReplicasNode.size());
        _object.removingReplicas = _collection3;
        for (Object _element : _removingReplicasNode) {
            _collection3.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _addingReplicasNode = _node.get("addingReplicas");
        if (_addingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'addingReplicas', which is mandatory in version " + _version);
        }
        if (!_addingReplicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<Integer> _collection4 = new ArrayList<Integer>(_addingReplicasNode.size());
        _object.addingReplicas = _collection4;
        for (JsonNode _element : _addingReplicasNode) {
            _collection4.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
        }
        JsonNode _leaderNode = _node.get("leader");
        if (_leaderNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leader', which is mandatory in version " + _version);
        }
        _object.leader = MessageUtil.jsonNodeToInt((JsonNode)_leaderNode, (String)"PartitionRecord");
        JsonNode _leaderRecoveryStateNode = _node.get("leaderRecoveryState");
        _object.leaderRecoveryState = _leaderRecoveryStateNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_leaderRecoveryStateNode, (String)"PartitionRecord");
        JsonNode _leaderEpochNode = _node.get("leaderEpoch");
        if (_leaderEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
        }
        _object.leaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_leaderEpochNode, (String)"PartitionRecord");
        JsonNode _partitionEpochNode = _node.get("partitionEpoch");
        if (_partitionEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionEpoch', which is mandatory in version " + _version);
        }
        _object.partitionEpoch = MessageUtil.jsonNodeToInt((JsonNode)_partitionEpochNode, (String)"PartitionRecord");
        JsonNode _directoriesNode = _node.get("directories");
        if (_directoriesNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("PartitionRecord: unable to locate field 'directories', which is mandatory in version " + _version);
            }
            _object.directories = new ArrayList<Uuid>(0);
        } else {
            if (!_directoriesNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Uuid> _collection5 = new ArrayList<Uuid>(_directoriesNode.size());
            _object.directories = _collection5;
            for (Object _element : _directoriesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("PartitionRecord element expected a JSON string type, but got " + _node.getNodeType());
                }
                _collection5.add(Uuid.fromString((String)_element.asText()));
            }
        }
        JsonNode _eligibleLeaderReplicasNode = _node.get("eligibleLeaderReplicas");
        if (_eligibleLeaderReplicasNode == null) {
            _object.eligibleLeaderReplicas = null;
        } else if (_eligibleLeaderReplicasNode.isNull()) {
            _object.eligibleLeaderReplicas = null;
        } else {
            if (!_eligibleLeaderReplicasNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection6 = new ArrayList<Integer>(_eligibleLeaderReplicasNode.size());
            _object.eligibleLeaderReplicas = _collection6;
            for (JsonNode _element : _eligibleLeaderReplicasNode) {
                _collection6.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        JsonNode _lastKnownELRNode = _node.get("lastKnownELR");
        if (_lastKnownELRNode == null) {
            _object.lastKnownELR = null;
        } else if (_lastKnownELRNode.isNull()) {
            _object.lastKnownELR = null;
        } else {
            if (!_lastKnownELRNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection7 = new ArrayList<Integer>(_lastKnownELRNode.size());
            _object.lastKnownELR = _collection7;
            for (JsonNode _element : _lastKnownELRNode) {
                _collection7.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(PartitionRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("partitionId", (JsonNode)new IntNode(_object.partitionId));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.replicas) {
            _replicasArray.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("replicas", (JsonNode)_replicasArray);
        ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.isr) {
            _isrArray.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("isr", (JsonNode)_isrArray);
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.removingReplicas) {
            arrayNode.add((JsonNode)new IntNode(n.intValue()));
        }
        _node.set("removingReplicas", (JsonNode)arrayNode);
        ArrayNode arrayNode2 = new ArrayNode(JsonNodeFactory.instance);
        for (Integer _element : _object.addingReplicas) {
            arrayNode2.add((JsonNode)new IntNode(_element.intValue()));
        }
        _node.set("addingReplicas", (JsonNode)arrayNode2);
        _node.set("leader", (JsonNode)new IntNode(_object.leader));
        if (_object.leaderRecoveryState != 0) {
            _node.set("leaderRecoveryState", (JsonNode)new ShortNode((short)_object.leaderRecoveryState));
        }
        _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
        _node.set("partitionEpoch", (JsonNode)new IntNode(_object.partitionEpoch));
        if (_version >= 1) {
            ArrayNode arrayNode3 = new ArrayNode(JsonNodeFactory.instance);
            for (Uuid uuid : _object.directories) {
                arrayNode3.add((JsonNode)new TextNode(uuid.toString()));
            }
            _node.set("directories", (JsonNode)arrayNode3);
        } else if (!_object.directories.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (_object.eligibleLeaderReplicas != null) {
                ArrayNode arrayNode4 = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.eligibleLeaderReplicas) {
                    arrayNode4.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("eligibleLeaderReplicas", (JsonNode)arrayNode4);
            }
        } else if (_object.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (_object.lastKnownELR != null) {
                ArrayNode arrayNode5 = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.lastKnownELR) {
                    arrayNode5.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("lastKnownELR", (JsonNode)arrayNode5);
            }
        } else if (_object.lastKnownELR != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownELR at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(PartitionRecord _object, short _version) {
        return PartitionRecordJsonConverter.write(_object, _version, true);
    }
}

