/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class DeleteShareGroupOffsetsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<String, ApiException>> {
    private final CoordinatorKey groupId;
    private final Logger log;
    private final Set<String> topics;
    private final CoordinatorStrategy lookupStrategy;

    public DeleteShareGroupOffsetsHandler(String groupId, Set<String> topics, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.topics = topics;
        this.log = logContext.logger(DeleteShareGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    @Override
    public String apiName() {
        return "deleteShareGroupOffsets";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<String, ApiException>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Collections.singleton(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + String.valueOf(groupIds) + " (expected only " + String.valueOf(Collections.singleton(this.groupId)) + ")");
        }
    }

    DeleteShareGroupOffsetsRequest.Builder buildBatchedRequest(int brokerId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        ArrayList<DeleteShareGroupOffsetsRequestData.DeleteShareGroupOffsetsRequestTopic> requestTopics = new ArrayList<DeleteShareGroupOffsetsRequestData.DeleteShareGroupOffsetsRequestTopic>();
        this.topics.forEach(topic -> requestTopics.add(new DeleteShareGroupOffsetsRequestData.DeleteShareGroupOffsetsRequestTopic().setTopicName((String)topic)));
        return new DeleteShareGroupOffsetsRequest.Builder(new DeleteShareGroupOffsetsRequestData().setGroupId(this.groupId.idValue).setTopics(requestTopics));
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<String, ApiException>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        DeleteShareGroupOffsetsResponse response = (DeleteShareGroupOffsetsResponse)abstractResponse;
        Errors groupError = Errors.forCode(response.data().errorCode());
        String groupErrorMessage = response.data().errorMessage();
        if (groupError != Errors.NONE) {
            HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
            HashMap<CoordinatorKey, Throwable> groupsFailed = new HashMap<CoordinatorKey, Throwable>();
            this.handleGroupError(this.groupId, groupError, groupErrorMessage, groupsFailed, groupsToUnmap);
            return new AdminApiHandler.ApiResult<CoordinatorKey, Map<String, ApiException>>(Collections.emptyMap(), groupsFailed, new ArrayList<CoordinatorKey>(groupsToUnmap));
        }
        HashMap topicResults = new HashMap();
        response.data().responses().forEach(topic -> {
            if (topic.errorCode() != Errors.NONE.code()) {
                Errors topicError = Errors.forCode(topic.errorCode());
                String topicErrorMessage = topic.errorMessage();
                this.log.debug("DeleteShareGroupOffsets request for group id {} and topic {} failed and returned error {}. {}", new Object[]{this.groupId.idValue, topic.topicName(), topicError, topicErrorMessage});
            }
            topicResults.put(topic.topicName(), Errors.forCode(topic.errorCode()).exception(topic.errorMessage()));
        });
        return AdminApiHandler.ApiResult.completed(this.groupId, topicResults);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, String errorMessage, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case COORDINATOR_LOAD_IN_PROGRESS: 
            case REBALANCE_IN_PROGRESS: {
                this.log.debug("DeleteShareGroupOffsets request for group id {} failed because the coordinator is still in the process of loading state. Will retry. {}", (Object)groupId.idValue, (Object)errorMessage);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("DeleteShareGroupOffsets request for group id {} returned error {}. Will rediscover the coordinator and retry. {}", new Object[]{groupId.idValue, error, errorMessage});
                groupsToUnmap.add(groupId);
                break;
            }
            case INVALID_GROUP_ID: 
            case GROUP_ID_NOT_FOUND: 
            case NON_EMPTY_GROUP: 
            case INVALID_REQUEST: 
            case UNKNOWN_SERVER_ERROR: 
            case KAFKA_STORAGE_ERROR: 
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("DeleteShareGroupOffsets request for group id {} failed due to error {}. {}", new Object[]{groupId.idValue, error, errorMessage});
                failed.put(groupId, error.exception(errorMessage));
                break;
            }
            default: {
                this.log.error("DeleteShareGroupOffsets request for group id {} failed due to unexpected error {}. {}", new Object[]{groupId.idValue, error, errorMessage});
                failed.put(groupId, error.exception(errorMessage));
            }
        }
    }
}

