/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.internals.CompletedFetch;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsAggregator;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchUtils;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractFetch
implements Closeable {
    private final Logger log;
    private final Logger completedFetchLog;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    protected final LogContext logContext;
    protected final ConsumerMetadata metadata;
    protected final SubscriptionState subscriptions;
    protected final FetchConfig fetchConfig;
    protected final Time time;
    protected final FetchMetricsManager metricsManager;
    protected final FetchBuffer fetchBuffer;
    protected final BufferSupplier decompressionBufferSupplier;
    protected final Set<Integer> nodesWithPendingFetchRequests;
    private final Map<Integer, FetchSessionHandler> sessionHandlers;
    private final ApiVersions apiVersions;

    public AbstractFetch(LogContext logContext, ConsumerMetadata metadata, SubscriptionState subscriptions, FetchConfig fetchConfig, FetchBuffer fetchBuffer, FetchMetricsManager metricsManager, Time time, ApiVersions apiVersions) {
        this.log = logContext.logger(AbstractFetch.class);
        this.completedFetchLog = logContext.logger(CompletedFetch.class);
        this.logContext = logContext;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.fetchConfig = fetchConfig;
        this.fetchBuffer = fetchBuffer;
        this.decompressionBufferSupplier = BufferSupplier.create();
        this.sessionHandlers = new HashMap<Integer, FetchSessionHandler>();
        this.nodesWithPendingFetchRequests = new HashSet<Integer>();
        this.metricsManager = metricsManager;
        this.time = time;
        this.apiVersions = apiVersions;
    }

    protected abstract boolean isUnavailable(Node var1);

    protected abstract void maybeThrowAuthFailure(Node var1);

    boolean hasCompletedFetches() {
        return !this.fetchBuffer.isEmpty();
    }

    public boolean hasAvailableFetches() {
        return this.fetchBuffer.hasCompletedFetches(fetch -> this.subscriptions.isFetchable(fetch.partition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFetchSuccess(Node fetchTarget, FetchSessionHandler.FetchRequestData data, ClientResponse resp) {
        try {
            FetchResponse response = (FetchResponse)resp.responseBody();
            FetchSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler == null) {
                this.log.error("Unable to find FetchSessionHandler for node {}. Ignoring fetch response.", (Object)fetchTarget.id());
                return;
            }
            short requestVersion = resp.requestHeader().apiVersion();
            if (!handler.handleResponse(response, requestVersion)) {
                if (response.error() == Errors.FETCH_SESSION_TOPIC_ID_ERROR) {
                    this.metadata.requestUpdate(false);
                }
                return;
            }
            LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> responseData = response.responseData(handler.sessionTopicNames(), requestVersion);
            HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(responseData.keySet());
            FetchMetricsAggregator metricAggregator = new FetchMetricsAggregator(this.metricsManager, partitions);
            boolean needsWakeup = true;
            HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> partitionsWithUpdatedLeaderInfo = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
            for (Map.Entry entry : responseData.entrySet()) {
                TopicPartition partition = (TopicPartition)entry.getKey();
                FetchRequest.PartitionData requestData = data.sessionPartitions().get(partition);
                if (requestData == null) {
                    String message = data.metadata().isFull() ? MessageFormatter.arrayFormat((String)"Response for missing full request partition: partition={}; metadata={}", (Object[])new Object[]{partition, data.metadata()}).getMessage() : MessageFormatter.arrayFormat((String)"Response for missing session request partition: partition={}; metadata={}; toSend={}; toForget={}; toReplace={}", (Object[])new Object[]{partition, data.metadata(), data.toSend(), data.toForget(), data.toReplace()}).getMessage();
                    throw new IllegalStateException(message);
                }
                long fetchOffset = requestData.fetchOffset;
                FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)entry.getValue();
                this.log.debug("Fetch {} at offset {} for partition {} returned fetch data {}", new Object[]{this.fetchConfig.isolationLevel, fetchOffset, partition, partitionData});
                Errors partitionError = Errors.forCode(partitionData.errorCode());
                if (partitionError == Errors.NOT_LEADER_OR_FOLLOWER || partitionError == Errors.FENCED_LEADER_EPOCH) {
                    this.log.debug("For {}, received error {}, with leaderIdAndEpoch {}", new Object[]{partition, partitionError, partitionData.currentLeader()});
                    if (partitionData.currentLeader().leaderId() != -1 && partitionData.currentLeader().leaderEpoch() != -1) {
                        partitionsWithUpdatedLeaderInfo.put(partition, new Metadata.LeaderIdAndEpoch(Optional.of(partitionData.currentLeader().leaderId()), Optional.of(partitionData.currentLeader().leaderEpoch())));
                    }
                }
                CompletedFetch completedFetch = new CompletedFetch(this.completedFetchLog, this.subscriptions, this.decompressionBufferSupplier, partition, partitionData, metricAggregator, fetchOffset);
                this.fetchBuffer.add(completedFetch);
                needsWakeup = false;
            }
            if (needsWakeup) {
                this.fetchBuffer.wakeup();
            }
            if (!partitionsWithUpdatedLeaderInfo.isEmpty()) {
                ArrayList<Node> leaderNodes = new ArrayList<Node>();
                for (FetchResponseData.NodeEndpoint e : response.data().nodeEndpoints()) {
                    Node node = new Node(e.nodeId(), e.host(), e.port(), e.rack());
                    if (node.equals(Node.noNode())) continue;
                    leaderNodes.add(node);
                }
                Set<TopicPartition> set = this.metadata.updatePartitionLeadership(partitionsWithUpdatedLeaderInfo, leaderNodes);
                set.forEach(tp -> {
                    this.log.debug("For {}, as the leader was updated, position will be validated.", tp);
                    this.subscriptions.maybeValidatePositionForCurrentLeader(this.apiVersions, (TopicPartition)tp, this.metadata.currentLeader((TopicPartition)tp));
                });
            }
            this.metricsManager.recordLatency(resp.destination(), resp.requestLatencyMs());
        }
        finally {
            this.removePendingFetchRequest(fetchTarget, data.metadata().sessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFetchFailure(Node fetchTarget, FetchSessionHandler.FetchRequestData data, Throwable t) {
        try {
            FetchSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler != null) {
                handler.handleError(t);
                handler.sessionTopicPartitions().forEach(this.subscriptions::clearPreferredReadReplica);
            }
        }
        finally {
            this.removePendingFetchRequest(fetchTarget, data.metadata().sessionId());
        }
    }

    protected void handleCloseFetchSessionSuccess(Node fetchTarget, FetchSessionHandler.FetchRequestData data, ClientResponse ignored) {
        int sessionId = data.metadata().sessionId();
        this.removePendingFetchRequest(fetchTarget, sessionId);
        this.log.debug("Successfully sent a close message for fetch session: {} to node: {}", (Object)sessionId, (Object)fetchTarget);
    }

    public void handleCloseFetchSessionFailure(Node fetchTarget, FetchSessionHandler.FetchRequestData data, Throwable t) {
        int sessionId = data.metadata().sessionId();
        this.removePendingFetchRequest(fetchTarget, sessionId);
        this.log.debug("Unable to send a close message for fetch session: {} to node: {}. This may result in unnecessary fetch sessions at the broker.", new Object[]{sessionId, fetchTarget, t});
    }

    private void removePendingFetchRequest(Node fetchTarget, int sessionId) {
        this.log.debug("Removing pending request for fetch session: {} for node: {}", (Object)sessionId, (Object)fetchTarget);
        this.nodesWithPendingFetchRequests.remove(fetchTarget.id());
    }

    protected FetchRequest.Builder createFetchRequest(Node fetchTarget, FetchSessionHandler.FetchRequestData requestData) {
        short maxVersion = requestData.canUseTopicIds() ? (short)ApiKeys.FETCH.latestVersion() : (short)12;
        FetchRequest.Builder request = FetchRequest.Builder.forConsumer(maxVersion, this.fetchConfig.maxWaitMs, this.fetchConfig.minBytes, requestData.toSend()).isolationLevel(this.fetchConfig.isolationLevel).setMaxBytes(this.fetchConfig.maxBytes).metadata(requestData.metadata()).removed(requestData.toForget()).replaced(requestData.toReplace()).rackId(this.fetchConfig.clientRackId);
        this.log.debug("Sending {} {} to broker {}", new Object[]{this.fetchConfig.isolationLevel, requestData, fetchTarget});
        this.log.debug("Adding pending request for node {}", (Object)fetchTarget);
        this.nodesWithPendingFetchRequests.add(fetchTarget.id());
        return request;
    }

    private List<TopicPartition> fetchablePartitions(Set<TopicPartition> buffered) {
        Predicate<TopicPartition> isNotBuffered = tp -> !buffered.contains(tp);
        return this.subscriptions.fetchablePartitions(isNotBuffered);
    }

    Node selectReadReplica(TopicPartition partition, Node leaderReplica, long currentTimeMs) {
        Optional<Integer> nodeId = this.subscriptions.preferredReadReplica(partition, currentTimeMs);
        if (nodeId.isPresent()) {
            Optional node = nodeId.flatMap(id -> this.metadata.fetch().nodeIfOnline(partition, (int)id));
            if (node.isPresent()) {
                return (Node)node.get();
            }
            this.log.trace("Not fetching from {} for partition {} since it is marked offline or is missing from our metadata, using the leader instead.", nodeId, (Object)partition);
            FetchUtils.requestMetadataUpdate(this.metadata, this.subscriptions, partition);
            return leaderReplica;
        }
        return leaderReplica;
    }

    protected Map<Node, FetchSessionHandler.FetchRequestData> prepareCloseFetchSessionRequests() {
        Cluster cluster = this.metadata.fetch();
        HashMap<Node, FetchSessionHandler.Builder> fetchable = new HashMap<Node, FetchSessionHandler.Builder>();
        this.sessionHandlers.forEach((fetchTargetNodeId, sessionHandler) -> {
            sessionHandler.notifyClose();
            Node fetchTarget = cluster.nodeById((int)fetchTargetNodeId);
            if (fetchTarget == null || this.isUnavailable(fetchTarget)) {
                this.log.debug("Skip sending close session request to broker {} since it is not reachable", (Object)fetchTarget);
                return;
            }
            fetchable.put(fetchTarget, sessionHandler.newBuilder());
        });
        return this.convert(fetchable);
    }

    protected Map<Node, FetchSessionHandler.FetchRequestData> prepareFetchRequests() {
        this.metricsManager.maybeUpdateAssignment(this.subscriptions);
        HashMap<Node, FetchSessionHandler.Builder> fetchable = new HashMap<Node, FetchSessionHandler.Builder>();
        long currentTimeMs = this.time.milliseconds();
        Map<String, Uuid> topicIds = this.metadata.topicIds();
        Set<TopicPartition> buffered = Collections.unmodifiableSet(this.fetchBuffer.bufferedPartitions());
        List<TopicPartition> unbuffered = this.fetchablePartitions(buffered);
        if (unbuffered.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Integer> bufferedNodes = this.bufferedNodes(buffered, currentTimeMs);
        for (TopicPartition partition : unbuffered) {
            SubscriptionState.FetchPosition position;
            Optional<Node> nodeOpt = this.maybeNodeForPosition(partition, position = this.positionForPartition(partition), currentTimeMs);
            if (nodeOpt.isEmpty()) continue;
            Node node = nodeOpt.get();
            if (this.isUnavailable(node)) {
                this.maybeThrowAuthFailure(node);
                this.log.trace("Skipping fetch for partition {} because node {} is awaiting reconnect backoff", (Object)partition, (Object)node);
                continue;
            }
            if (this.nodesWithPendingFetchRequests.contains(node.id())) {
                this.log.trace("Skipping fetch for partition {} because previous request to {} has not been processed", (Object)partition, (Object)node);
                continue;
            }
            if (bufferedNodes.contains(node.id())) {
                this.log.trace("Skipping fetch for partition {} because its leader node {} hosts buffered partitions", (Object)partition, (Object)node);
                continue;
            }
            FetchSessionHandler.Builder builder = fetchable.computeIfAbsent(node, k -> {
                FetchSessionHandler fetchSessionHandler = this.sessionHandlers.computeIfAbsent(node.id(), n -> new FetchSessionHandler(this.logContext, (int)n));
                return fetchSessionHandler.newBuilder();
            });
            Uuid topicId = topicIds.getOrDefault(partition.topic(), Uuid.ZERO_UUID);
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(topicId, position.offset, -1L, this.fetchConfig.fetchSize, position.currentLeader.epoch, Optional.empty());
            builder.add(partition, partitionData);
            this.log.debug("Added {} fetch request for partition {} at position {} to node {}", new Object[]{this.fetchConfig.isolationLevel, partition, position, node});
        }
        return this.convert(fetchable);
    }

    private Map<Node, FetchSessionHandler.FetchRequestData> convert(Map<Node, FetchSessionHandler.Builder> fetchable) {
        HashMap<Node, FetchSessionHandler.FetchRequestData> map = new HashMap<Node, FetchSessionHandler.FetchRequestData>(fetchable.size());
        for (Map.Entry<Node, FetchSessionHandler.Builder> entry : fetchable.entrySet()) {
            map.put(entry.getKey(), entry.getValue().build());
        }
        return map;
    }

    private SubscriptionState.FetchPosition positionForPartition(TopicPartition partition) {
        SubscriptionState.FetchPosition position = this.subscriptions.position(partition);
        if (position == null) {
            throw new IllegalStateException("Missing position for fetchable partition " + String.valueOf(partition));
        }
        return position;
    }

    private Optional<Node> maybeNodeForPosition(TopicPartition partition, SubscriptionState.FetchPosition position, long currentTimeMs) {
        Optional<Node> leaderOpt = position.currentLeader.leader;
        if (leaderOpt.isEmpty()) {
            this.log.debug("Requesting metadata update for partition {} since the position {} is missing the current leader node", (Object)partition, (Object)position);
            this.metadata.requestUpdate(false);
            return Optional.empty();
        }
        Node node = this.selectReadReplica(partition, leaderOpt.get(), currentTimeMs);
        return Optional.of(node);
    }

    private Set<Integer> bufferedNodes(Set<TopicPartition> partitions, long currentTimeMs) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (TopicPartition partition : partitions) {
            if (!this.subscriptions.isFetchable(partition)) continue;
            SubscriptionState.FetchPosition position = this.positionForPartition(partition);
            Optional<Node> nodeOpt = this.maybeNodeForPosition(partition, position, currentTimeMs);
            nodeOpt.ifPresent(node -> ids.add(node.id()));
        }
        return ids;
    }

    protected FetchSessionHandler sessionHandler(int node) {
        return this.sessionHandlers.get(node);
    }

    protected void closeInternal(Timer timer) {
        Utils.closeQuietly(this.fetchBuffer, "fetchBuffer");
        Utils.closeQuietly(this.decompressionBufferSupplier, "decompressionBufferSupplier");
    }

    public void close(Timer timer) {
        this.idempotentCloser.close(() -> this.closeInternal(timer));
    }

    @Override
    public void close() {
        this.close(this.time.timer(Duration.ZERO));
    }

    @FunctionalInterface
    protected static interface ResponseHandler<T> {
        public void handle(Node var1, FetchSessionHandler.FetchRequestData var2, T var3);
    }
}

