/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.slf4j.Logger;

public class FollowerState
implements EpochState {
    private final Logger log;
    private final int fetchTimeoutMs;
    private final int epoch;
    private final int leaderId;
    private final Endpoints leaderEndpoints;
    private final Optional<ReplicaKey> votedKey;
    private final Set<Integer> voters;
    private final Timer fetchTimer;
    private final Timer updateVoterSetPeriodTimer;
    private boolean hasFetchedFromLeader = false;
    private Optional<LogOffsetMetadata> highWatermark;
    private boolean hasUpdatedLeader = false;
    private Optional<RawSnapshotWriter> fetchingSnapshot = Optional.empty();

    public FollowerState(Time time, int epoch, int leaderId, Endpoints leaderEndpoints, Optional<ReplicaKey> votedKey, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int fetchTimeoutMs, LogContext logContext) {
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.leaderEndpoints = leaderEndpoints;
        this.votedKey = votedKey;
        this.voters = voters;
        this.fetchTimer = time.timer((long)fetchTimeoutMs);
        this.updateVoterSetPeriodTimer = time.timer(this.updateVoterPeriodMs());
        this.highWatermark = highWatermark;
        this.log = logContext.logger(FollowerState.class);
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.leaderId, this.votedKey, this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return this.leaderEndpoints;
    }

    @Override
    public String name() {
        return "Follower";
    }

    public long remainingFetchTimeMs(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.remainingMs();
    }

    public int leaderId() {
        return this.leaderId;
    }

    public Node leaderNode(ListenerName listener) {
        return this.leaderEndpoints.address(listener).map(address -> new Node(this.leaderId, address.getHostString(), address.getPort())).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown endpoint for leader %d and listener %s, known endpoints are %s", this.leaderId, listener, this.leaderEndpoints)));
    }

    public boolean hasFetchTimeoutExpired(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.isExpired();
    }

    public void resetFetchTimeoutForSuccessfulFetch(long currentTimeMs) {
        this.overrideFetchTimeout(currentTimeMs, this.fetchTimeoutMs);
        this.hasFetchedFromLeader = true;
    }

    public void overrideFetchTimeout(long currentTimeMs, long timeoutMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset(timeoutMs);
    }

    private long updateVoterPeriodMs() {
        return this.fetchTimeoutMs;
    }

    public boolean hasUpdateVoterSetPeriodExpired(long currentTimeMs) {
        this.updateVoterSetPeriodTimer.update(currentTimeMs);
        return this.updateVoterSetPeriodTimer.isExpired();
    }

    public void resetUpdateVoterSetPeriod(long currentTimeMs) {
        this.updateVoterSetPeriodTimer.update(currentTimeMs);
        this.updateVoterSetPeriodTimer.reset(this.updateVoterPeriodMs());
    }

    public boolean hasUpdatedLeader() {
        return this.hasUpdatedLeader;
    }

    public void setHasUpdatedLeader() {
        this.hasUpdatedLeader = true;
    }

    public boolean updateHighWatermark(OptionalLong newHighWatermark) {
        if (newHighWatermark.isEmpty() && this.highWatermark.isPresent()) {
            throw new IllegalArgumentException(String.format("Attempt to overwrite current high watermark %s with unknown value", this.highWatermark));
        }
        if (this.highWatermark.isPresent()) {
            long previousHighWatermark = this.highWatermark.get().offset();
            long updatedHighWatermark = newHighWatermark.getAsLong();
            if (updatedHighWatermark < 0L) {
                throw new IllegalArgumentException(String.format("Illegal negative (%d) high watermark update", updatedHighWatermark));
            }
            if (previousHighWatermark > updatedHighWatermark) {
                throw new IllegalArgumentException(String.format("Non-monotonic update of high watermark from %d to %d", previousHighWatermark, updatedHighWatermark));
            }
            if (previousHighWatermark == updatedHighWatermark) {
                return false;
            }
        }
        Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
        this.highWatermark = newHighWatermark.isPresent() ? Optional.of(new LogOffsetMetadata(newHighWatermark.getAsLong())) : Optional.empty();
        this.logHighWatermarkUpdate(oldHighWatermark, this.highWatermark);
        return true;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public Optional<RawSnapshotWriter> fetchingSnapshot() {
        return this.fetchingSnapshot;
    }

    public void setFetchingSnapshot(Optional<RawSnapshotWriter> newSnapshot) {
        this.fetchingSnapshot.ifPresent(RawSnapshotWriter::close);
        this.fetchingSnapshot = newSnapshot;
    }

    @Override
    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        if (isPreVote && !this.hasFetchedFromLeader && isLogUpToDate) {
            return true;
        }
        this.log.debug("Rejecting Vote request (preVote={}) from replica ({}) since we are in FollowerState with leader {} in epoch {}, hasFetchedFromLeader={}, replica's log is up-to-date={}", new Object[]{isPreVote, replicaKey, this.leaderId, this.epoch, this.hasFetchedFromLeader, isLogUpToDate});
        return false;
    }

    public String toString() {
        return String.format("FollowerState(fetchTimeoutMs=%d, epoch=%d, leader=%d, leaderEndpoints=%s, votedKey=%s, voters=%s, highWatermark=%s, fetchingSnapshot=%s)", this.fetchTimeoutMs, this.epoch, this.leaderId, this.leaderEndpoints, this.votedKey, this.voters, this.highWatermark, this.fetchingSnapshot);
    }

    @Override
    public void close() {
        this.fetchingSnapshot.ifPresent(RawSnapshotWriter::close);
    }

    private void logHighWatermarkUpdate(Optional<LogOffsetMetadata> oldHighWatermark, Optional<LogOffsetMetadata> newHighWatermark) {
        if (!oldHighWatermark.equals(newHighWatermark)) {
            if (oldHighWatermark.isPresent()) {
                this.log.trace("High watermark set to {} from {} for epoch {}", new Object[]{newHighWatermark, oldHighWatermark.get(), this.epoch});
            } else {
                this.log.info("High watermark set to {} for the first time for epoch {}", newHighWatermark, (Object)this.epoch);
            }
        }
    }
}

