/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;

public class ClientMetricsConfigs
extends AbstractConfig {
    public static final String METRICS_CONFIG = "metrics";
    public static final String INTERVAL_MS_CONFIG = "interval.ms";
    public static final String MATCH_CONFIG = "match";
    public static final String CLIENT_INSTANCE_ID = "client_instance_id";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SOFTWARE_NAME = "client_software_name";
    public static final String CLIENT_SOFTWARE_VERSION = "client_software_version";
    public static final String CLIENT_SOURCE_ADDRESS = "client_source_address";
    public static final String CLIENT_SOURCE_PORT = "client_source_port";
    public static final String ALL_SUBSCRIBED_METRICS = "*";
    public static final List<String> METRICS_DEFAULT = List.of();
    public static final int INTERVAL_MS_DEFAULT = 300000;
    private static final int MIN_INTERVAL_MS = 100;
    private static final int MAX_INTERVAL_MS = 3600000;
    public static final List<String> MATCH_DEFAULT = List.of();
    private static final Set<String> ALLOWED_MATCH_PARAMS = Set.of("client_instance_id", "client_id", "client_software_name", "client_software_version", "client_source_address", "client_source_port");
    private static final ConfigDef CONFIG = new ConfigDef().define("metrics", ConfigDef.Type.LIST, METRICS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.MEDIUM, "Telemetry metric name prefix list").define("interval.ms", ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.MEDIUM, "Metrics push interval in milliseconds").define("match", ConfigDef.Type.LIST, MATCH_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.MEDIUM, "Client match criteria");

    public ClientMetricsConfigs(Properties props) {
        super(CONFIG, (Map)props, false);
    }

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public static Optional<ConfigDef.Type> configType(String configName) {
        return Optional.ofNullable((ConfigDef.ConfigKey)CONFIG.configKeys().get(configName)).map(c -> c.type);
    }

    public static Map<String, Object> defaultConfigsMap() {
        HashMap<String, Object> clientMetricsProps = new HashMap<String, Object>();
        clientMetricsProps.put(METRICS_CONFIG, METRICS_DEFAULT);
        clientMetricsProps.put(INTERVAL_MS_CONFIG, 300000);
        clientMetricsProps.put(MATCH_CONFIG, MATCH_DEFAULT);
        return clientMetricsProps;
    }

    public static Set<String> names() {
        return CONFIG.names();
    }

    public static void validate(String subscriptionName, Properties properties) {
        if (subscriptionName == null || subscriptionName.isEmpty()) {
            throw new InvalidRequestException("Subscription name can't be empty");
        }
        ClientMetricsConfigs.validateProperties(properties);
    }

    private static void validateProperties(Properties properties) {
        int pushIntervalMs;
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!ClientMetricsConfigs.names().contains(key)) {
                throw new InvalidRequestException("Unknown client metrics configuration: " + String.valueOf(key));
            }
        }));
        Map parsed = CONFIG.parse((Map)properties);
        if (properties.containsKey(INTERVAL_MS_CONFIG) && ((pushIntervalMs = ((Integer)parsed.get(INTERVAL_MS_CONFIG)).intValue()) < 100 || pushIntervalMs > 3600000)) {
            String msg = String.format("Invalid value %s for %s, interval must be between 100 and 3600000 (1 hour)", pushIntervalMs, INTERVAL_MS_CONFIG);
            throw new InvalidRequestException(msg);
        }
        if (properties.containsKey(MATCH_CONFIG)) {
            List patterns = (List)parsed.get(MATCH_CONFIG);
            ClientMetricsConfigs.parseMatchingPatterns(patterns);
        }
    }

    public static Map<String, Pattern> parseMatchingPatterns(List<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return Map.of();
        }
        HashMap<String, Pattern> patternsMap = new HashMap<String, Pattern>();
        patterns.forEach(pattern -> {
            String[] nameValuePair = pattern.split("=");
            if (nameValuePair.length != 2) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
            String param = nameValuePair[0].trim();
            if (!ClientMetricsConfigs.isValidParam(param)) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
            try {
                Pattern patternValue = Pattern.compile(nameValuePair[1].trim());
                patternsMap.put(param, patternValue);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidConfigurationException("Illegal client matching pattern: " + pattern);
            }
        });
        return patternsMap;
    }

    private static boolean isValidParam(String paramName) {
        return ALLOWED_MATCH_PARAMS.contains(paramName);
    }

    public static ClientMetricsConfigs fromProps(Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        props.putAll(defaults);
        props.putAll((Map<?, ?>)overrides);
        return new ClientMetricsConfigs(props);
    }
}

