/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum ConverterType {
    KEY,
    VALUE,
    HEADER;

    private static final Map<String, ConverterType> NAME_TO_TYPE;
    private final String name = this.name().toLowerCase(Locale.ROOT);

    public static ConverterType withName(String name) {
        if (name == null) {
            return null;
        }
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.getDefault()));
    }

    public String getName() {
        return this.name;
    }

    static {
        NAME_TO_TYPE = Arrays.stream(ConverterType.values()).collect(Collectors.toUnmodifiableMap(ConverterType::getName, t -> t));
    }
}

