/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;

public abstract class SendDynamicAwareSupport
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private Set<String> knownProperties;
    private RuntimeCamelCatalog catalog;
    private String scheme;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    protected void doInit() throws Exception {
        if (this.isOnlyDynamicQueryParameters()) {
            EndpointUriFactory factory = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getEndpointUriFactory(this.getScheme());
            if (factory == null) {
                throw new IllegalStateException("Cannot find EndpointUriFactory for component: " + this.getScheme());
            }
            this.knownProperties = factory.propertyNames();
        } else {
            this.catalog = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog();
        }
    }

    public Map<String, Object> endpointProperties(Exchange exchange, String uri) throws Exception {
        LinkedHashMap<String, Object> properties;
        if (this.isOnlyDynamicQueryParameters()) {
            LinkedHashMap<String, Object> map = URISupport.parseQuery((String)URISupport.extractQuery((String)uri));
            if (map != null && !map.isEmpty() && this.isLenientProperties()) {
                properties = new LinkedHashMap();
                map.forEach((k, v) -> {
                    if (this.knownProperties.contains(k)) {
                        properties.put((String)k, v);
                    }
                });
            } else {
                properties = map;
            }
        } else {
            properties = new LinkedHashMap<String, Object>(this.catalog.endpointProperties(uri));
        }
        return properties;
    }

    public Map<String, Object> endpointLenientProperties(Exchange exchange, String uri) throws Exception {
        LinkedHashMap<String, Object> properties;
        if (this.isOnlyDynamicQueryParameters()) {
            LinkedHashMap<String, Object> map = URISupport.parseQuery((String)URISupport.extractQuery((String)uri));
            if (map != null && !map.isEmpty()) {
                properties = new LinkedHashMap();
                map.forEach((k, v) -> {
                    if (!this.knownProperties.contains(k)) {
                        properties.put((String)k, v.toString());
                    }
                });
            } else {
                properties = map;
            }
        } else {
            properties = new LinkedHashMap<String, Object>(this.catalog.endpointLenientProperties(uri));
        }
        return properties;
    }

    public String asEndpointUri(Exchange exchange, String uri, Map<String, Object> properties) throws Exception {
        if (this.isOnlyDynamicQueryParameters()) {
            String query = URISupport.createQueryString(properties, (boolean)false);
            int pos = uri.indexOf(63);
            String answer = pos != -1 ? uri.substring(0, pos) + "?" + query : uri + "?" + query;
            return answer;
        }
        return this.catalog.asEndpointUri(this.getScheme(), new LinkedHashMap<String, Object>(properties), false);
    }
}

