/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledBatchPollingConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledBatchPollingConsumer.class);
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;
    protected int maxMessagesPerPoll;

    public ScheduledBatchPollingConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public ScheduledBatchPollingConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            LOG.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        this.shutdownRunningTask = null;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    @Override
    protected void processEmptyMessage() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setProperty("CamelBatchIndex", (Object)0);
        exchange.setProperty("CamelBatchSize", (Object)1);
        exchange.setProperty("CamelBatchComplete", (Object)true);
        LOG.debug("Sending empty message as there were no messages from polling: {}", (Object)this.getEndpoint());
        this.getProcessor().process(exchange);
    }
}

