/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.entries.PercentExpression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MagicFormatter {
    private final String prefix;
    private final PercentExpression percentExpression;
    private final String suffix;
    public static final String FINAL_PATTERN_CHARS = "%bcdeEfFgGiosuxX";
    public static final String PATTERN_MODIFIERS = "lqh";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("([^%]*)(%[-+0-9# .lqh]*[%bcdeEfFgGiosuxX])?(.*)");

    public MagicFormatter(String formatString) {
        Matcher matcher = FORMAT_PATTERN.matcher(formatString);
        if (!matcher.matches()) {
            this.prefix = formatString;
            this.percentExpression = null;
            this.suffix = null;
            return;
        }
        String prefixMatch = matcher.group(1);
        String percentMatch = matcher.group(2);
        String suffixMatch = matcher.group(3);
        if (percentMatch != null && percentMatch.equals("%%")) {
            MagicFormatter formatter = new MagicFormatter(suffixMatch);
            StringBuilder sb = new StringBuilder();
            if (prefixMatch != null) {
                sb.append(prefixMatch);
            }
            sb.append('%');
            if (formatter.prefix != null) {
                sb.append(formatter.prefix);
            }
            this.prefix = sb.toString();
            this.percentExpression = formatter.percentExpression;
            this.suffix = formatter.suffix;
            return;
        }
        this.prefix = prefixMatch == null || prefixMatch.length() == 0 ? null : prefixMatch;
        this.percentExpression = percentMatch == null || percentMatch.length() == 0 ? null : new PercentExpression(percentMatch);
        this.suffix = suffixMatch == null || suffixMatch.length() == 0 ? null : suffixMatch.replace("%%", "%");
    }

    public void format(StringBuilder sb, Object value) {
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        if (this.percentExpression != null && value != null) {
            this.percentExpression.append(value, sb);
        }
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        if (this.percentExpression != null) {
            sb.append(this.percentExpression);
        }
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }
}

