/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.aggregated;

import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.WriterOutputStream;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.FailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.IDescribable;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import com.carrotsearch.ant.tasks.junit4.events.JsonHelpers;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.TestStatus;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.junit.runner.Description;

public class AggregatedSuiteResultEvent
implements AggregatedResultEvent {
    private final transient ForkedJvmInfo forkedJvm;
    private final long executionTime;
    private final long startTimestamp;
    private final Description description;
    private final List tests;
    private final List suiteFailures;
    private final List eventStream;
    private final AggregatedSuiteStartedEvent startEvent;

    public AggregatedSuiteResultEvent(AggregatedSuiteStartedEvent aggregatedSuiteStartedEvent, ForkedJvmInfo forkedJvmInfo, Description description, List list, List list2, List list3, long l, long l2) {
        this.startEvent = aggregatedSuiteStartedEvent;
        this.forkedJvm = forkedJvmInfo;
        this.tests = list2;
        this.suiteFailures = list;
        this.description = description;
        this.eventStream = list3;
        this.executionTime = l2;
        this.startTimestamp = l;
    }

    public AggregatedSuiteStartedEvent getStartEvent() {
        return this.startEvent;
    }

    public List getTests() {
        return this.tests;
    }

    @Override
    public List getFailures() {
        return Collections.unmodifiableList(this.suiteFailures);
    }

    @Override
    public boolean isSuccessful() {
        if (!this.suiteFailures.isEmpty()) {
            return false;
        }
        for (AggregatedTestResultEvent aggregatedTestResultEvent : this.tests) {
            if (aggregatedTestResultEvent.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getEventStream() {
        return this.eventStream;
    }

    @Override
    public ForkedJvmInfo getForkedJvmInfo() {
        return this.forkedJvm;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public int getFailureCount() {
        int n = 0;
        for (Object object : this.getTests()) {
            if (((AggregatedTestResultEvent)object).getStatus() != TestStatus.FAILURE) continue;
            ++n;
        }
        for (Object object : this.getFailures()) {
            if (!((FailureMirror)object).isAssertionViolation()) continue;
            ++n;
        }
        return n;
    }

    public int getErrorCount() {
        int n = 0;
        for (Object object : this.getTests()) {
            if (((AggregatedTestResultEvent)object).getStatus() != TestStatus.ERROR) continue;
            ++n;
        }
        for (Object object : this.getFailures()) {
            if (!((FailureMirror)object).isErrorViolation()) continue;
            ++n;
        }
        return n;
    }

    public int getIgnoredCount() {
        int n = 0;
        for (AggregatedTestResultEvent aggregatedTestResultEvent : this.getTests()) {
            if (aggregatedTestResultEvent.getStatus() != TestStatus.IGNORED && aggregatedTestResultEvent.getStatus() != TestStatus.IGNORED_ASSUMPTION) continue;
            ++n;
        }
        return n;
    }

    public void serialize(JsonWriter jsonWriter, boolean bl) {
        jsonWriter.beginObject();
        jsonWriter.name("forkedJvm").value(this.getForkedJvmInfo().id);
        jsonWriter.name("startTimestamp").value(this.getStartTimestamp());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.ROOT);
        jsonWriter.name("startTimestampDate").value(simpleDateFormat.format(new Date(this.getStartTimestamp())));
        jsonWriter.name("executionTime").value(this.getExecutionTime());
        jsonWriter.name("description");
        JsonHelpers.writeDescription(jsonWriter, this.getDescription());
        jsonWriter.name("tests");
        jsonWriter.beginArray();
        for (Object object : this.getTests()) {
            this.serialize(jsonWriter, simpleDateFormat, (AggregatedTestResultEvent)object);
        }
        jsonWriter.endArray();
        jsonWriter.name("suiteFailures");
        jsonWriter.beginArray();
        for (Object object : this.getFailures()) {
            this.serialize(jsonWriter, (FailureMirror)object);
        }
        jsonWriter.endArray();
        jsonWriter.name("executionEvents");
        jsonWriter.beginArray();
        this.serializeEvents(jsonWriter, bl);
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private void serialize(JsonWriter jsonWriter, SimpleDateFormat simpleDateFormat, AggregatedTestResultEvent aggregatedTestResultEvent) {
        jsonWriter.beginObject();
        jsonWriter.name("forkedJvm").value(aggregatedTestResultEvent.getForkedJvmInfo().id);
        jsonWriter.name("startTimestamp").value(aggregatedTestResultEvent.getStartTimestamp());
        jsonWriter.name("startTimestampDate").value(simpleDateFormat.format(new Date(aggregatedTestResultEvent.getStartTimestamp())));
        jsonWriter.name("executionTime").value(aggregatedTestResultEvent.getExecutionTime());
        jsonWriter.name("description");
        JsonHelpers.writeDescription(jsonWriter, aggregatedTestResultEvent.getDescription());
        jsonWriter.name("status").value(aggregatedTestResultEvent.getStatus().name());
        jsonWriter.name("testFailures");
        jsonWriter.beginArray();
        for (FailureMirror failureMirror : aggregatedTestResultEvent.getFailures()) {
            this.serialize(jsonWriter, failureMirror);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private void serialize(JsonWriter jsonWriter, FailureMirror failureMirror) {
        jsonWriter.beginObject();
        jsonWriter.name("throwableClass").value(failureMirror.getThrowableClass());
        jsonWriter.name("throwableString").value(failureMirror.getThrowableString());
        jsonWriter.name("stackTrace").value(failureMirror.getTrace());
        String string = failureMirror.isAssertionViolation() ? "assertion" : (failureMirror.isErrorViolation() ? "error" : (failureMirror.isAssumptionViolation() ? "assumption" : "unknown"));
        jsonWriter.name("kind").value(string);
        jsonWriter.endObject();
    }

    private void serializeEvents(JsonWriter jsonWriter, boolean bl) {
        Charset charset = this.getForkedJvmInfo().getCharset();
        int n = 160;
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        WriterOutputStream writerOutputStream = new WriterOutputStream((Writer)stringWriter, charset, n, false);
        WriterOutputStream writerOutputStream2 = new WriterOutputStream((Writer)stringWriter2, charset, n, false);
        for (IEvent iEvent : this.getEventStream()) {
            try {
                switch (iEvent.getType()) {
                    case SUITE_FAILURE: 
                    case TEST_IGNORED_ASSUMPTION: 
                    case TEST_IGNORED: 
                    case TEST_STARTED: 
                    case TEST_FINISHED: 
                    case TEST_FAILURE: {
                        this.flushBoth(jsonWriter, stringWriter, stringWriter2, writerOutputStream, writerOutputStream2);
                        jsonWriter.beginObject();
                        jsonWriter.name("event").value(iEvent.getType().toString());
                        jsonWriter.name("description");
                        JsonHelpers.writeDescription(jsonWriter, ((IDescribable)((Object)iEvent)).getDescription());
                        if (iEvent instanceof FailureEvent) {
                            jsonWriter.name("failure");
                            ((FailureEvent)iEvent).serialize(jsonWriter);
                        }
                        jsonWriter.endObject();
                        break;
                    }
                    case APPEND_STDOUT: {
                        if (!bl) break;
                        this.flush(EventType.APPEND_STDERR, jsonWriter, writerOutputStream2, stringWriter2);
                        ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream);
                        break;
                    }
                    case APPEND_STDERR: {
                        if (!bl) break;
                        this.flush(EventType.APPEND_STDOUT, jsonWriter, writerOutputStream, stringWriter);
                        ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream2);
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
        }
        this.flushBoth(jsonWriter, stringWriter, stringWriter2, writerOutputStream, writerOutputStream2);
    }

    public void flushBoth(JsonWriter jsonWriter, StringWriter stringWriter, StringWriter stringWriter2, WriterOutputStream writerOutputStream, WriterOutputStream writerOutputStream2) {
        this.flush(EventType.APPEND_STDOUT, jsonWriter, writerOutputStream, stringWriter);
        this.flush(EventType.APPEND_STDERR, jsonWriter, writerOutputStream2, stringWriter2);
    }

    private void flush(EventType eventType, JsonWriter jsonWriter, WriterOutputStream writerOutputStream, StringWriter stringWriter) {
        writerOutputStream.flush();
        if (stringWriter.getBuffer().length() > 0) {
            jsonWriter.beginObject();
            jsonWriter.name("event").value(eventType.toString());
            jsonWriter.name("content").value(stringWriter.getBuffer().toString());
            stringWriter.getBuffer().setLength(0);
            jsonWriter.endObject();
        }
    }
}

