/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.DFISimilarity;
import org.apache.lucene.search.similarities.Independence;
import org.apache.lucene.search.similarities.IndependenceChiSquared;
import org.apache.lucene.search.similarities.IndependenceSaturated;
import org.apache.lucene.search.similarities.IndependenceStandardized;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.SimilarityFactory;

public class DFISimilarityFactory
extends SimilarityFactory {
    private boolean discountOverlaps;
    private Independence independenceMeasure;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        this.discountOverlaps = params.getBool("discountOverlaps", true);
        this.independenceMeasure = this.parseIndependenceMeasure(params.get("independenceMeasure"));
    }

    @Override
    public Similarity getSimilarity() {
        DFISimilarity sim = new DFISimilarity(this.independenceMeasure);
        sim.setDiscountOverlaps(this.discountOverlaps);
        return sim;
    }

    private Independence parseIndependenceMeasure(String expr) {
        if ("ChiSquared".equals(expr)) {
            return new IndependenceChiSquared();
        }
        if ("Standardized".equals(expr)) {
            return new IndependenceStandardized();
        }
        if ("Saturated".equals(expr)) {
            return new IndependenceSaturated();
        }
        throw new RuntimeException("Invalid independence measure: " + expr);
    }
}

