/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.maven.wagon.shared.http.ConfigurationUtils;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;

public class HttpConfiguration {
    private HttpMethodConfiguration all;
    private HttpMethodConfiguration get;
    private HttpMethodConfiguration put;
    private HttpMethodConfiguration head;
    private HttpMethodConfiguration mkcol;

    public HttpMethodConfiguration getAll() {
        return this.all;
    }

    public HttpConfiguration setAll(HttpMethodConfiguration all) {
        this.all = all;
        return this;
    }

    public HttpMethodConfiguration getGet() {
        return this.get;
    }

    public HttpConfiguration setGet(HttpMethodConfiguration get) {
        this.get = get;
        return this;
    }

    public HttpMethodConfiguration getPut() {
        return this.put;
    }

    public HttpConfiguration setPut(HttpMethodConfiguration put) {
        this.put = put;
        return this;
    }

    public HttpMethodConfiguration getHead() {
        return this.head;
    }

    public HttpConfiguration setHead(HttpMethodConfiguration head) {
        this.head = head;
        return this;
    }

    public HttpMethodConfiguration getMkcol() {
        return this.mkcol;
    }

    public HttpConfiguration setMkcol(HttpMethodConfiguration mkcol) {
        this.mkcol = mkcol;
        return this;
    }

    public HttpMethodConfiguration getMethodConfiguration(HttpUriRequest method) {
        switch (method.getMethod()) {
            case "GET": {
                return ConfigurationUtils.merge(this.all, this.get);
            }
            case "PUT": {
                return ConfigurationUtils.merge(this.all, this.put);
            }
            case "HEAD": {
                return ConfigurationUtils.merge(this.all, this.head);
            }
            case "MKCOL": {
                return ConfigurationUtils.merge(this.all, this.mkcol);
            }
        }
        return this.all;
    }
}

