/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor.io;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.plugin.descriptor.Dependency;
import org.apache.maven.api.plugin.descriptor.MojoDescriptor;
import org.apache.maven.api.plugin.descriptor.Parameter;
import org.apache.maven.api.plugin.descriptor.PluginDescriptor;
import org.apache.maven.api.plugin.descriptor.Requirement;
import org.apache.maven.api.plugin.descriptor.Resolution;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;

@Generated
public class PluginDescriptorStaxReader {
    private boolean addDefaultEntities = true;
    private final ContentTransformer contentTransformer;

    public PluginDescriptorStaxReader() {
        this((s, f) -> s);
    }

    public PluginDescriptorStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public XMLInputFactory getXMLInputFactory() {
        return InputFactoryHolder.XML_INPUT_FACTORY;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public PluginDescriptor read(Reader reader) throws XMLStreamException {
        return this.read(reader, true);
    }

    public PluginDescriptor read(Reader reader, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(reader);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict);
    }

    public PluginDescriptor read(InputStream in) throws XMLStreamException {
        return this.read(in, true);
    }

    public PluginDescriptor read(InputStream in, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(in);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict);
    }

    public PluginDescriptor read(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        ArrayDeque<Object> context = new ArrayDeque<Object>();
        PluginDescriptor pluginDescriptor = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 8) {
            if (eventType == 1) {
                if (strict && !"plugin".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'plugin' but found '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
                }
                if (parsed) {
                    throw new XMLStreamException("Duplicated tag: 'plugin'", parser.getLocation(), null);
                }
                pluginDescriptor = this.parsePluginDescriptor(parser, strict, parser.getNamespaceURI(), context);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return pluginDescriptor;
        }
        throw new XMLStreamException("Expected root element 'plugin' but found no element at all: invalid XML document", parser.getLocation(), null);
    }

    private PluginDescriptor parsePluginDescriptor(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginDescriptor.Builder pluginDescriptor = PluginDescriptor.newBuilder((boolean)true);
        pluginDescriptor.namespaceUri(namespace);
        pluginDescriptor.modelEncoding(parser.getEncoding());
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(pluginDescriptor);
        block27: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "name": {
                    pluginDescriptor.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    continue block27;
                }
                case "description": {
                    pluginDescriptor.description(this.interpolatedTrimmed(this.nextText(parser, strict), "description"));
                    continue block27;
                }
                case "groupId": {
                    pluginDescriptor.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    continue block27;
                }
                case "artifactId": {
                    pluginDescriptor.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    continue block27;
                }
                case "version": {
                    pluginDescriptor.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    continue block27;
                }
                case "goalPrefix": {
                    pluginDescriptor.goalPrefix(this.interpolatedTrimmed(this.nextText(parser, strict), "goalPrefix"));
                    continue block27;
                }
                case "isolatedRealm": {
                    pluginDescriptor.isolatedRealm(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "isolatedRealm"), "isolatedRealm", parser, false));
                    continue block27;
                }
                case "inheritedByDefault": {
                    pluginDescriptor.inheritedByDefault(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "inheritedByDefault"), "inheritedByDefault", parser, true));
                    continue block27;
                }
                case "requiredJavaVersion": {
                    pluginDescriptor.requiredJavaVersion(this.interpolatedTrimmed(this.nextText(parser, strict), "requiredJavaVersion"));
                    continue block27;
                }
                case "requiredMavenVersion": {
                    pluginDescriptor.requiredMavenVersion(this.interpolatedTrimmed(this.nextText(parser, strict), "requiredMavenVersion"));
                    continue block27;
                }
                case "mojos": {
                    ArrayList<MojoDescriptor> mojos = new ArrayList<MojoDescriptor>();
                    while (parser.nextTag() == 1) {
                        if ("mojo".equals(parser.getLocalName())) {
                            mojos.add(this.parseMojoDescriptor(parser, strict, namespace, context));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginDescriptor.mojos(mojos);
                    continue block27;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        return pluginDescriptor.build();
    }

    private MojoDescriptor parseMojoDescriptor(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        MojoDescriptor.Builder mojoDescriptor = MojoDescriptor.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(mojoDescriptor);
        block45: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "goal": {
                    mojoDescriptor.goal(this.interpolatedTrimmed(this.nextText(parser, strict), "goal"));
                    continue block45;
                }
                case "description": {
                    mojoDescriptor.description(this.interpolatedTrimmed(this.nextText(parser, strict), "description"));
                    continue block45;
                }
                case "implementation": {
                    mojoDescriptor.implementation(this.interpolatedTrimmed(this.nextText(parser, strict), "implementation"));
                    continue block45;
                }
                case "language": {
                    mojoDescriptor.language(this.interpolatedTrimmed(this.nextText(parser, strict), "language"));
                    continue block45;
                }
                case "phase": {
                    mojoDescriptor.phase(this.interpolatedTrimmed(this.nextText(parser, strict), "phase"));
                    continue block45;
                }
                case "executePhase": {
                    mojoDescriptor.executePhase(this.interpolatedTrimmed(this.nextText(parser, strict), "executePhase"));
                    continue block45;
                }
                case "executeGoal": {
                    mojoDescriptor.executeGoal(this.interpolatedTrimmed(this.nextText(parser, strict), "executeGoal"));
                    continue block45;
                }
                case "executeLifecycle": {
                    mojoDescriptor.executeLifecycle(this.interpolatedTrimmed(this.nextText(parser, strict), "executeLifecycle"));
                    continue block45;
                }
                case "dependencyResolution": {
                    mojoDescriptor.dependencyResolution(this.interpolatedTrimmed(this.nextText(parser, strict), "dependencyResolution"));
                    continue block45;
                }
                case "dependencyCollection": {
                    mojoDescriptor.dependencyCollection(this.interpolatedTrimmed(this.nextText(parser, strict), "dependencyCollection"));
                    continue block45;
                }
                case "directInvocationOnly": {
                    mojoDescriptor.directInvocationOnly(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "directInvocationOnly"), "directInvocationOnly", parser, false));
                    continue block45;
                }
                case "projectRequired": {
                    mojoDescriptor.projectRequired(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "projectRequired"), "projectRequired", parser, true));
                    continue block45;
                }
                case "onlineRequired": {
                    mojoDescriptor.onlineRequired(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "onlineRequired"), "onlineRequired", parser, false));
                    continue block45;
                }
                case "aggregator": {
                    mojoDescriptor.aggregator(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "aggregator"), "aggregator", parser, false));
                    continue block45;
                }
                case "inheritedByDefault": {
                    mojoDescriptor.inheritedByDefault(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "inheritedByDefault"), "inheritedByDefault", parser, true));
                    continue block45;
                }
                case "since": {
                    mojoDescriptor.since(this.interpolatedTrimmed(this.nextText(parser, strict), "since"));
                    continue block45;
                }
                case "deprecated": {
                    mojoDescriptor.deprecated(this.interpolatedTrimmed(this.nextText(parser, strict), "deprecated"));
                    continue block45;
                }
                case "configurator": {
                    mojoDescriptor.configurator(this.interpolatedTrimmed(this.nextText(parser, strict), "configurator"));
                    continue block45;
                }
                case "parameters": {
                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                    while (parser.nextTag() == 1) {
                        if ("parameter".equals(parser.getLocalName())) {
                            parameters.add(this.parseParameter(parser, strict, namespace, context));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    mojoDescriptor.parameters(parameters);
                    continue block45;
                }
                case "resolutions": {
                    ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
                    while (parser.nextTag() == 1) {
                        if ("resolution".equals(parser.getLocalName())) {
                            resolutions.add(this.parseResolution(parser, strict, namespace, context));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    mojoDescriptor.resolutions(resolutions);
                    continue block45;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        mojoDescriptor.id(((PluginDescriptor.Builder)context.peekLast()).build().getId() + ":" + mojoDescriptor.build().getGoal());
        mojoDescriptor.fullGoalName(((PluginDescriptor.Builder)context.peekLast()).build().getGoalPrefix() + ":" + mojoDescriptor.build().getGoal());
        return mojoDescriptor.build();
    }

    private Parameter parseParameter(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Parameter.Builder parameter = Parameter.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(parameter);
        block25: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "name": {
                    parameter.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    continue block25;
                }
                case "alias": {
                    parameter.alias(this.interpolatedTrimmed(this.nextText(parser, strict), "alias"));
                    continue block25;
                }
                case "type": {
                    parameter.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    continue block25;
                }
                case "required": {
                    parameter.required(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "required"), "required", parser, false));
                    continue block25;
                }
                case "editable": {
                    parameter.editable(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "editable"), "editable", parser, true));
                    continue block25;
                }
                case "description": {
                    parameter.description(this.interpolatedTrimmed(this.nextText(parser, strict), "description"));
                    continue block25;
                }
                case "since": {
                    parameter.since(this.interpolatedTrimmed(this.nextText(parser, strict), "since"));
                    continue block25;
                }
                case "deprecated": {
                    parameter.deprecated(this.interpolatedTrimmed(this.nextText(parser, strict), "deprecated"));
                    continue block25;
                }
                case "expression": {
                    parameter.expression(this.interpolatedTrimmed(this.nextText(parser, strict), "expression"));
                    continue block25;
                }
                case "defaultValue": {
                    parameter.defaultValue(this.interpolatedTrimmed(this.nextText(parser, strict), "defaultValue"));
                    continue block25;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        return parameter.build();
    }

    private Requirement parseRequirement(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Requirement.Builder requirement = Requirement.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(requirement);
        block11: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "role": {
                    requirement.role(this.interpolatedTrimmed(this.nextText(parser, strict), "role"));
                    continue block11;
                }
                case "role-hint": {
                    requirement.roleHint(this.interpolatedTrimmed(this.nextText(parser, strict), "role-hint"));
                    continue block11;
                }
                case "field-name": {
                    requirement.fieldName(this.interpolatedTrimmed(this.nextText(parser, strict), "field-name"));
                    continue block11;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        return requirement.build();
    }

    private Dependency parseDependency(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Dependency.Builder dependency = Dependency.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(dependency);
        block13: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "groupId": {
                    dependency.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    continue block13;
                }
                case "artifactId": {
                    dependency.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    continue block13;
                }
                case "version": {
                    dependency.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    continue block13;
                }
                case "type": {
                    dependency.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    continue block13;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        return dependency.build();
    }

    private Resolution parseResolution(XMLStreamReader parser, boolean strict, String namespace, Deque<Object> context) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Resolution.Builder resolution = Resolution.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        context.addLast(resolution);
        block11: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName;
            this.checkNamespace(parser, strict, namespace);
            switch (childName = this.checkDuplicate(parser.getLocalName(), parser, parsed)) {
                case "field": {
                    resolution.field(this.interpolatedTrimmed(this.nextText(parser, strict), "field"));
                    continue block11;
                }
                case "pathScope": {
                    resolution.pathScope(this.interpolatedTrimmed(this.nextText(parser, strict), "pathScope"));
                    continue block11;
                }
                case "requestType": {
                    resolution.requestType(this.interpolatedTrimmed(this.nextText(parser, strict), "requestType"));
                    continue block11;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        context.removeLast();
        return resolution.build();
    }

    private void checkNamespace(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String ns;
        if (strict && !Objects.equals(namespace, ns = parser.getNamespaceURI())) {
            throw new XMLStreamException(String.format("Unexpected namespace for element '%s': found '%s' but expected '%s'", parser.getLocalName(), ns != null ? ns : "no namespace", namespace), parser.getLocation(), null);
        }
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
        }
        return tagName;
    }

    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    }

    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = this.nextTag(parser);
            if (eventType == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        block4: while (true) {
            int next = parser.next();
            switch (next) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
        }
    }

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == 4 || eventType == 12) {
                result.append(parser.getText());
            } else if (eventType == 9) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                }
                if (this.addDefaultEntities) {
                    val = DefaultEntitiesHolder.DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != 5) break;
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + eventType, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser) throws XMLStreamException {
        return XmlService.read((XMLStreamReader)parser);
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader parser, boolean defaultValue) throws XMLStreamException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private static Map<String, String> doGetDefaultEntities() {
        return Map.ofEntries(Map.entry("nbsp", "\u00a0"), Map.entry("iexcl", "\u00a1"), Map.entry("cent", "\u00a2"), Map.entry("pound", "\u00a3"), Map.entry("curren", "\u00a4"), Map.entry("yen", "\u00a5"), Map.entry("brvbar", "\u00a6"), Map.entry("sect", "\u00a7"), Map.entry("uml", "\u00a8"), Map.entry("copy", "\u00a9"), Map.entry("ordf", "\u00aa"), Map.entry("laquo", "\u00ab"), Map.entry("not", "\u00ac"), Map.entry("shy", "\u00ad"), Map.entry("reg", "\u00ae"), Map.entry("macr", "\u00af"), Map.entry("deg", "\u00b0"), Map.entry("plusmn", "\u00b1"), Map.entry("sup2", "\u00b2"), Map.entry("sup3", "\u00b3"), Map.entry("acute", "\u00b4"), Map.entry("micro", "\u00b5"), Map.entry("para", "\u00b6"), Map.entry("middot", "\u00b7"), Map.entry("cedil", "\u00b8"), Map.entry("sup1", "\u00b9"), Map.entry("ordm", "\u00ba"), Map.entry("raquo", "\u00bb"), Map.entry("frac14", "\u00bc"), Map.entry("frac12", "\u00bd"), Map.entry("frac34", "\u00be"), Map.entry("iquest", "\u00bf"), Map.entry("Agrave", "\u00c0"), Map.entry("Aacute", "\u00c1"), Map.entry("Acirc", "\u00c2"), Map.entry("Atilde", "\u00c3"), Map.entry("Auml", "\u00c4"), Map.entry("Aring", "\u00c5"), Map.entry("AElig", "\u00c6"), Map.entry("Ccedil", "\u00c7"), Map.entry("Egrave", "\u00c8"), Map.entry("Eacute", "\u00c9"), Map.entry("Ecirc", "\u00ca"), Map.entry("Euml", "\u00cb"), Map.entry("Igrave", "\u00cc"), Map.entry("Iacute", "\u00cd"), Map.entry("Icirc", "\u00ce"), Map.entry("Iuml", "\u00cf"), Map.entry("ETH", "\u00d0"), Map.entry("Ntilde", "\u00d1"), Map.entry("Ograve", "\u00d2"), Map.entry("Oacute", "\u00d3"), Map.entry("Ocirc", "\u00d4"), Map.entry("Otilde", "\u00d5"), Map.entry("Ouml", "\u00d6"), Map.entry("times", "\u00d7"), Map.entry("Oslash", "\u00d8"), Map.entry("Ugrave", "\u00d9"), Map.entry("Uacute", "\u00da"), Map.entry("Ucirc", "\u00db"), Map.entry("Uuml", "\u00dc"), Map.entry("Yacute", "\u00dd"), Map.entry("THORN", "\u00de"), Map.entry("szlig", "\u00df"), Map.entry("agrave", "\u00e0"), Map.entry("aacute", "\u00e1"), Map.entry("acirc", "\u00e2"), Map.entry("atilde", "\u00e3"), Map.entry("auml", "\u00e4"), Map.entry("aring", "\u00e5"), Map.entry("aelig", "\u00e6"), Map.entry("ccedil", "\u00e7"), Map.entry("egrave", "\u00e8"), Map.entry("eacute", "\u00e9"), Map.entry("ecirc", "\u00ea"), Map.entry("euml", "\u00eb"), Map.entry("igrave", "\u00ec"), Map.entry("iacute", "\u00ed"), Map.entry("icirc", "\u00ee"), Map.entry("iuml", "\u00ef"), Map.entry("eth", "\u00f0"), Map.entry("ntilde", "\u00f1"), Map.entry("ograve", "\u00f2"), Map.entry("oacute", "\u00f3"), Map.entry("ocirc", "\u00f4"), Map.entry("otilde", "\u00f5"), Map.entry("ouml", "\u00f6"), Map.entry("divide", "\u00f7"), Map.entry("oslash", "\u00f8"), Map.entry("ugrave", "\u00f9"), Map.entry("uacute", "\u00fa"), Map.entry("ucirc", "\u00fb"), Map.entry("uuml", "\u00fc"), Map.entry("yacute", "\u00fd"), Map.entry("thorn", "\u00fe"), Map.entry("yuml", "\u00ff"), Map.entry("OElig", "\u0152"), Map.entry("oelig", "\u0153"), Map.entry("Scaron", "\u0160"), Map.entry("scaron", "\u0161"), Map.entry("Yuml", "\u0178"), Map.entry("circ", "\u02c6"), Map.entry("tilde", "\u02dc"), Map.entry("ensp", "\u2002"), Map.entry("emsp", "\u2003"), Map.entry("thinsp", "\u2009"), Map.entry("zwnj", "\u200c"), Map.entry("zwj", "\u200d"), Map.entry("lrm", "\u200e"), Map.entry("rlm", "\u200f"), Map.entry("ndash", "\u2013"), Map.entry("mdash", "\u2014"), Map.entry("lsquo", "\u2018"), Map.entry("rsquo", "\u2019"), Map.entry("sbquo", "\u201a"), Map.entry("ldquo", "\u201c"), Map.entry("rdquo", "\u201d"), Map.entry("bdquo", "\u201e"), Map.entry("dagger", "\u2020"), Map.entry("Dagger", "\u2021"), Map.entry("permil", "\u2030"), Map.entry("lsaquo", "\u2039"), Map.entry("rsaquo", "\u203a"), Map.entry("euro", "\u20ac"), Map.entry("fnof", "\u0192"), Map.entry("Alpha", "\u0391"), Map.entry("Beta", "\u0392"), Map.entry("Gamma", "\u0393"), Map.entry("Delta", "\u0394"), Map.entry("Epsilon", "\u0395"), Map.entry("Zeta", "\u0396"), Map.entry("Eta", "\u0397"), Map.entry("Theta", "\u0398"), Map.entry("Iota", "\u0399"), Map.entry("Kappa", "\u039a"), Map.entry("Lambda", "\u039b"), Map.entry("Mu", "\u039c"), Map.entry("Nu", "\u039d"), Map.entry("Xi", "\u039e"), Map.entry("Omicron", "\u039f"), Map.entry("Pi", "\u03a0"), Map.entry("Rho", "\u03a1"), Map.entry("Sigma", "\u03a3"), Map.entry("Tau", "\u03a4"), Map.entry("Upsilon", "\u03a5"), Map.entry("Phi", "\u03a6"), Map.entry("Chi", "\u03a7"), Map.entry("Psi", "\u03a8"), Map.entry("Omega", "\u03a9"), Map.entry("alpha", "\u03b1"), Map.entry("beta", "\u03b2"), Map.entry("gamma", "\u03b3"), Map.entry("delta", "\u03b4"), Map.entry("epsilon", "\u03b5"), Map.entry("zeta", "\u03b6"), Map.entry("eta", "\u03b7"), Map.entry("theta", "\u03b8"), Map.entry("iota", "\u03b9"), Map.entry("kappa", "\u03ba"), Map.entry("lambda", "\u03bb"), Map.entry("mu", "\u03bc"), Map.entry("nu", "\u03bd"), Map.entry("xi", "\u03be"), Map.entry("omicron", "\u03bf"), Map.entry("pi", "\u03c0"), Map.entry("rho", "\u03c1"), Map.entry("sigmaf", "\u03c2"), Map.entry("sigma", "\u03c3"), Map.entry("tau", "\u03c4"), Map.entry("upsilon", "\u03c5"), Map.entry("phi", "\u03c6"), Map.entry("chi", "\u03c7"), Map.entry("psi", "\u03c8"), Map.entry("omega", "\u03c9"), Map.entry("thetasym", "\u03d1"), Map.entry("upsih", "\u03d2"), Map.entry("piv", "\u03d6"), Map.entry("bull", "\u2022"), Map.entry("hellip", "\u2026"), Map.entry("prime", "\u2032"), Map.entry("Prime", "\u2033"), Map.entry("oline", "\u203e"), Map.entry("frasl", "\u2044"), Map.entry("weierp", "\u2118"), Map.entry("image", "\u2111"), Map.entry("real", "\u211c"), Map.entry("trade", "\u2122"), Map.entry("alefsym", "\u2135"), Map.entry("larr", "\u2190"), Map.entry("uarr", "\u2191"), Map.entry("rarr", "\u2192"), Map.entry("darr", "\u2193"), Map.entry("harr", "\u2194"), Map.entry("crarr", "\u21b5"), Map.entry("lArr", "\u21d0"), Map.entry("uArr", "\u21d1"), Map.entry("rArr", "\u21d2"), Map.entry("dArr", "\u21d3"), Map.entry("hArr", "\u21d4"), Map.entry("forall", "\u2200"), Map.entry("part", "\u2202"), Map.entry("exist", "\u2203"), Map.entry("empty", "\u2205"), Map.entry("nabla", "\u2207"), Map.entry("isin", "\u2208"), Map.entry("notin", "\u2209"), Map.entry("ni", "\u220b"), Map.entry("prod", "\u220f"), Map.entry("sum", "\u2211"), Map.entry("minus", "\u2212"), Map.entry("lowast", "\u2217"), Map.entry("radic", "\u221a"), Map.entry("prop", "\u221d"), Map.entry("infin", "\u221e"), Map.entry("ang", "\u2220"), Map.entry("and", "\u2227"), Map.entry("or", "\u2228"), Map.entry("cap", "\u2229"), Map.entry("cup", "\u222a"), Map.entry("int", "\u222b"), Map.entry("there4", "\u2234"), Map.entry("sim", "\u223c"), Map.entry("cong", "\u2245"), Map.entry("asymp", "\u2248"), Map.entry("ne", "\u2260"), Map.entry("equiv", "\u2261"), Map.entry("le", "\u2264"), Map.entry("ge", "\u2265"), Map.entry("sub", "\u2282"), Map.entry("sup", "\u2283"), Map.entry("nsub", "\u2284"), Map.entry("sube", "\u2286"), Map.entry("supe", "\u2287"), Map.entry("oplus", "\u2295"), Map.entry("otimes", "\u2297"), Map.entry("perp", "\u22a5"), Map.entry("sdot", "\u22c5"), Map.entry("lceil", "\u2308"), Map.entry("rceil", "\u2309"), Map.entry("lfloor", "\u230a"), Map.entry("rfloor", "\u230b"), Map.entry("lang", "\u2329"), Map.entry("rang", "\u232a"), Map.entry("loz", "\u25ca"), Map.entry("spades", "\u2660"), Map.entry("clubs", "\u2663"), Map.entry("hearts", "\u2665"), Map.entry("diams", "\u2666"));
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    static class InputFactoryHolder {
        static final XMLInputFactory XML_INPUT_FACTORY;

        InputFactoryHolder() {
        }

        static {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XML_INPUT_FACTORY = factory;
        }
    }

    static class DefaultEntitiesHolder {
        static final Map<String, String> DEFAULT_ENTITIES = PluginDescriptorStaxReader.doGetDefaultEntities();

        DefaultEntitiesHolder() {
        }
    }
}

