/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTrackingFileManager.class);

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties read(File file) {
        if (Files.isReadable(file.toPath())) {
            Object object = this.getMutex(file);
            synchronized (object) {
                try (FileInputStream stream = new FileInputStream(file);){
                    Properties properties;
                    block17: {
                        FileLock unused = this.fileLock(stream.getChannel(), Math.max(1L, file.length()), true);
                        try {
                            Properties props = new Properties();
                            props.load(stream);
                            properties = props;
                            if (unused == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (unused != null) {
                                try {
                                    unused.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        unused.close();
                    }
                    return properties;
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read tracking file '{}'", (Object)file, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create tracking file parent '{}'", (Object)file, (Object)e);
            throw new UncheckedIOException(e);
        }
        Object object = this.getMutex(file);
        synchronized (object) {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");
                 FileLock unused = this.fileLock(raf.getChannel(), Math.max(1L, raf.length()), false);){
                if (raf.length() > 0L) {
                    Object buffer = new byte[(int)raf.length()];
                    raf.readFully((byte[])buffer);
                    props.load(new ByteArrayInputStream((byte[])buffer));
                }
                for (Map.Entry entry : updates.entrySet()) {
                    if (entry.getValue() == null) {
                        props.remove(entry.getKey());
                        continue;
                    }
                    props.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                LOGGER.debug("Writing tracking file '{}'", (Object)file);
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to write tracking file '{}'", (Object)file, (Object)e);
                throw new UncheckedIOException(e);
            }
        }
        return props;
    }

    private Object getMutex(File file) {
        try {
            return file.getCanonicalPath().intern();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to canonicalize path {}", (Object)file, (Object)e);
            return file.getAbsolutePath().intern();
        }
    }

    private FileLock fileLock(FileChannel channel, long size, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size, shared);
                break;
            }
            catch (OverlappingFileLockException e) {
                if (attempts <= 0) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

