/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedTextParser {
    private HashMap<String, ElementInfo> _elements = new HashMap(23);
    private static final int _OUT_OF_ELEMENT = 0;
    private static final int _IN_ELEMENT = 1;
    private static final int _IN_EMPTY_ELEMENT = 2;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FormattedTextParser.class);

    public void addElement(ElementInfo element) {
        String name = element.getName();
        this._elements.put(name, element);
        this._elements.put(name.toUpperCase(), element);
    }

    public void writeFormattedText(FacesContext context, String text) throws IOException {
        int length = text.length();
        ArrayList<ElementInfo> elementStack = new ArrayList<ElementInfo>(10);
        int state = 0;
        ResponseWriter writer = context.getResponseWriter();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '<') {
                        int endOfElementName;
                        boolean close = false;
                        if (i + 1 < length && text.charAt(i + 1) == '/') {
                            close = true;
                            ++i;
                        }
                        if ((endOfElementName = FormattedTextParser._getEndOfElementName(text, i + 1, length)) < 0) {
                            i = length;
                            break;
                        }
                        String elementName = text.substring(i + 1, endOfElementName);
                        ElementInfo info = this._elements.get(elementName);
                        if (info != null) {
                            if (close) {
                                int endOfElement;
                                if (FormattedTextParser._popElement(context, elementStack, info)) {
                                    info.endElement(context);
                                }
                                if ((endOfElement = text.indexOf(62, i)) < 0) {
                                    FormattedTextParser._parseError("Unterminated element", i);
                                    i = length;
                                    break;
                                }
                                i = endOfElement + 1;
                                break;
                            }
                            FormattedTextParser._pushElement(context, elementStack, info);
                            info.startElement(context);
                            state = info.isEmptyElement() ? 2 : 1;
                            i = endOfElementName;
                            break;
                        }
                        int endOfElement = text.indexOf(62, i);
                        if (endOfElement < 0) {
                            FormattedTextParser._parseError("Unterminated element", i);
                            i = length;
                            break;
                        }
                        i = endOfElement + 1;
                        break;
                    }
                    if (c == '&') {
                        int endOfEntity = FormattedTextParser._getEndOfEntity(text, i, length);
                        if (endOfEntity < 0) {
                            char[] chars = new char[]{c};
                            writer.writeText(chars, 0, 1);
                            ++i;
                            break;
                        }
                        c = FormattedTextParser._getEntity(text, i, endOfEntity);
                        if (c != '\u0000') {
                            char[] chars = new char[]{c};
                            writer.writeText(chars, 0, 1);
                        }
                        i = endOfEntity + 1;
                        break;
                    }
                    char[] chars = new char[]{c};
                    writer.writeText(chars, 0, 1);
                    ++i;
                    break;
                }
                case 1: 
                case 2: {
                    if (c == '>') {
                        if (state == 2) {
                            ElementInfo info = FormattedTextParser._peekElement(elementStack);
                            info.endElement(context);
                            FormattedTextParser._popElement(context, elementStack, info);
                        }
                        state = 0;
                        ++i;
                        break;
                    }
                    if (!Character.isWhitespace(c)) {
                        int endOfAttributeName = FormattedTextParser._getEndOfAttributeName(text, i, length);
                        if (endOfAttributeName < 0) {
                            FormattedTextParser._parseError("Unterminated attribute name", i);
                            i = length;
                            break;
                        }
                        String attributeName = text.substring(i, endOfAttributeName);
                        if ('=' == text.charAt(endOfAttributeName)) {
                            if (endOfAttributeName + 1 >= length) {
                                FormattedTextParser._parseError("Unterminated attribute value", endOfAttributeName);
                                i = length;
                                break;
                            }
                            StringBuffer buffer = new StringBuffer();
                            int endOfAttributeValue = FormattedTextParser._getAttributeValue(text, endOfAttributeName + 1, length, buffer);
                            if (endOfAttributeValue < 0) {
                                FormattedTextParser._parseError("Unterminated attribute value", endOfAttributeName + 1);
                                i = length;
                                break;
                            }
                            ElementInfo info = FormattedTextParser._peekElement(elementStack);
                            if ("class".equalsIgnoreCase(attributeName)) {
                                info.writeStyleClass(context, buffer.toString());
                            } else if ("style".equalsIgnoreCase(attributeName)) {
                                info.writeInlineStyle(context, buffer.toString());
                            } else if ("href".equalsIgnoreCase(attributeName)) {
                                info.writeHRef(context, buffer.toString());
                            } else if ("size".equalsIgnoreCase(attributeName)) {
                                info.writeSize(context, buffer.toString());
                            }
                            i = endOfAttributeValue + 1;
                            break;
                        }
                        if ('>' == text.charAt(endOfAttributeName)) {
                            i = endOfAttributeName;
                            break;
                        }
                        i = endOfAttributeName + 1;
                        break;
                    }
                    ++i;
                }
            }
        }
        for (int size = elementStack.size() - 1; size >= 0; --size) {
            ElementInfo info = (ElementInfo)elementStack.get(size);
            info.endElement(context);
            if (!info.isCloseRequired()) continue;
            FormattedTextParser._parseError("Unterminated element " + info.getName(), i);
        }
    }

    private static void _pushElement(FacesContext context, ArrayList<ElementInfo> elementStack, ElementInfo element) throws IOException {
        ElementInfo top;
        int size = elementStack.size();
        if (size != 0 && !(top = elementStack.get(size - 1)).isCloseRequired() && element == top) {
            top.endElement(context);
            elementStack.remove(size - 1);
        }
        elementStack.add(element);
    }

    private static ElementInfo _peekElement(ArrayList<ElementInfo> elementStack) {
        int size = elementStack.size();
        if (size == 0) {
            return null;
        }
        return elementStack.get(size - 1);
    }

    private static boolean _popElement(FacesContext context, ArrayList<ElementInfo> elementStack, ElementInfo element) throws IOException {
        int size;
        while ((size = elementStack.size()) > 0) {
            ElementInfo top = elementStack.remove(size - 1);
            if (element == top) {
                return true;
            }
            if (!top.isCloseRequired()) {
                top.endElement(context);
                continue;
            }
            FormattedTextParser._parseError("Unclosed element", -1);
            break;
        }
        return false;
    }

    private static int _getAttributeValue(String text, int start, int end, StringBuffer buffer) {
        char endChar = text.charAt(start);
        if (endChar == '\'' || endChar == '\"') {
            ++start;
        } else {
            endChar = '\u0000';
        }
        int i = start;
        while (i < end) {
            char c = text.charAt(i);
            if (endChar == '\u0000') {
                if (Character.isWhitespace(c) || c == '>') {
                    return i - 1;
                }
            } else if (c == endChar) {
                return i;
            }
            if (c == '&') {
                int endOfEntity = FormattedTextParser._getEndOfEntity(text, i, end);
                if (endOfEntity < 0) {
                    buffer.append(c);
                    ++i;
                    continue;
                }
                c = FormattedTextParser._getEntity(text, i, endOfEntity);
                if (c != '\u0000') {
                    buffer.append(c);
                }
                i = endOfEntity + 1;
                continue;
            }
            buffer.append(c);
            ++i;
        }
        return -1;
    }

    private static int _getEndOfAttributeName(String text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '=' && !Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    private static int _getEndOfElementName(String text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '>' && !Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    private static int _getEndOfEntity(String text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ';') {
                return i;
            }
            if (c != '&' && !Character.isLetterOrDigit(c)) break;
        }
        return -1;
    }

    private static char _getEntity(String text, int start, int end) {
        int length;
        if ((length = end - ++start) == 2) {
            if (text.startsWith("lt", start)) {
                return '<';
            }
            if (text.startsWith("gt", start)) {
                return '>';
            }
        } else if (length == 3) {
            if (text.startsWith("amp", start)) {
                return '&';
            }
            if (text.startsWith("reg", start)) {
                return '\u00ae';
            }
        } else if (length == 4) {
            if (text.startsWith("copy", start)) {
                return '\u00a9';
            }
            if (text.startsWith("nbsp", start)) {
                return '\u00a0';
            }
            if (text.startsWith("quot", start)) {
                return '\"';
            }
        }
        return '\u0000';
    }

    private static void _parseError(String message, int position) {
        if (_LOG.isInfo()) {
            message = position < 0 ? "Formatted text parse error:\n" + message : "Formatted text parse error at position " + position + ":\n" + message;
            _LOG.info(message);
        }
    }

    public static class DefaultElementInfo
    extends ElementInfo {
        private boolean _empty;
        private boolean _closeRequired;

        public DefaultElementInfo(String name) {
            this(name, false, true);
        }

        public DefaultElementInfo(String name, boolean empty, boolean closeRequired) {
            super(name);
            this._empty = empty;
            this._closeRequired = closeRequired;
        }

        public void startElement(FacesContext context) throws IOException {
            context.getResponseWriter().startElement(this.getName(), null);
        }

        public void endElement(FacesContext context) throws IOException {
            context.getResponseWriter().endElement(this.getName());
        }

        public void writeInlineStyle(FacesContext context, String style) throws IOException {
            context.getResponseWriter().writeAttribute("style", (Object)style, null);
        }

        public void writeStyleClass(FacesContext context, String styleClass) throws IOException {
            context.getResponseWriter().writeAttribute("class", (Object)styleClass, null);
        }

        public void writeSize(FacesContext context, String fontSize) throws IOException {
        }

        public void writeHRef(FacesContext context, String href) throws IOException {
            if (href.regionMatches(true, 0, "javascript:", 0, 11)) {
                return;
            }
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (!Boolean.FALSE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_NAVIGATION))) {
                href = context.getExternalContext().encodeActionURL(href);
                context.getResponseWriter().writeURIAttribute("href", (Object)href, null);
            }
        }

        public boolean isEmptyElement() {
            return this._empty;
        }

        public boolean isCloseRequired() {
            return this._closeRequired;
        }
    }

    public static abstract class ElementInfo {
        private String _name;

        public ElementInfo(String name) {
            this._name = name.toLowerCase();
        }

        public String getName() {
            return this._name;
        }

        public abstract void startElement(FacesContext var1) throws IOException;

        public abstract void endElement(FacesContext var1) throws IOException;

        public abstract void writeInlineStyle(FacesContext var1, String var2) throws IOException;

        public abstract void writeHRef(FacesContext var1, String var2) throws IOException;

        public abstract void writeStyleClass(FacesContext var1, String var2) throws IOException;

        public abstract void writeSize(FacesContext var1, String var2) throws IOException;

        public boolean isEmptyElement() {
            return false;
        }

        public boolean isCloseRequired() {
            return !this.isEmptyElement();
        }
    }
}

