/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Map;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.IncompatibleMask;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class PointlessBitwiseExpression {
    public static ErrorDescription checkPointlessShiftExpression(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        Map<String, TreePath> variables = ctx.getVariables();
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath tree = variables.get("$c");
        Long value = IncompatibleMask.getConstant(tree, ctx);
        if (value == null) {
            return null;
        }
        if (value == 0L) {
            return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(PointlessBitwiseExpression.class, "MSG_PointlessBitwiseExpression"), new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, "MSG_PointlessBitwiseExpression_fix"), true).toEditorFix());
        }
        return null;
    }

    public static ErrorDescription checkPointlessBitwiseExpression(HintContext ctx) {
        boolean left;
        TreePath treePath = ctx.getPath();
        CompilationInfo compilationInfo = ctx.getInfo();
        Map<String, TreePath> variables = ctx.getVariables();
        TreePath tree = variables.get("$c");
        Long value = IncompatibleMask.getConstant(tree, ctx);
        boolean bl = left = treePath.getLeaf().getKind() != Tree.Kind.AND;
        if (value != null && value == 0L) {
            return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(PointlessBitwiseExpression.class, "MSG_PointlessBitwiseExpression"), new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, left ? "MSG_PointlessBitwiseExpression_fix" : "MSG_PointlessBitwiseExpression_fix2"), left).toEditorFix());
        }
        tree = variables.get("$v");
        value = IncompatibleMask.getConstant(tree, ctx);
        if (value != null && value == 0L) {
            return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(PointlessBitwiseExpression.class, "MSG_PointlessBitwiseExpression"), new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, left ? "MSG_PointlessBitwiseExpression_fix" : "MSG_PointlessBitwiseExpression_fix2"), !left).toEditorFix());
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String text;
        private boolean left;

        public FixImpl(CompilationInfo info, TreePath tp, String text, boolean left) {
            super(info, tp);
            this.text = text;
            this.left = left;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Tree vt = tp.getLeaf();
            BinaryTree e = (BinaryTree)vt;
            wc.rewrite(vt, this.left ? e.getLeftOperand() : e.getRightOperand());
        }
    }
}

