/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.Closeable;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class ModuleOraculum
implements CompilerOptionsQueryImplementation,
FileChangeListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(ModuleOraculum.class.getName());
    private final ThreadLocal<String> moduleName = new ThreadLocal();
    private AtomicReference<Pair<Reference<FileObject>, Reference<FileObject>>> rootCache = new AtomicReference();
    private AtomicReference<Pair<Pair<Reference<FileObject>, File>, String>> modNameCache = new AtomicReference();

    @Override
    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
        String name = this.moduleName.get();
        return name == null ? null : new R(name);
    }

    @Override
    public void close() {
        this.moduleName.remove();
    }

    boolean installModuleName(@NullAllowed FileObject root, @NullAllowed FileObject fo) {
        if (fo != null && fo.isData() && ("module-info".equals(fo.getName()) || "class".equals(fo.getExt()))) {
            return false;
        }
        if (root == null && fo != null) {
            root = this.computeRootIfAbsent(fo, f -> {
                FileObject owner;
                ClassPath src = ClassPath.getClassPath(f, "classpath/source");
                FileObject fileObject = owner = src != null ? src.findOwnerRoot((FileObject)f) : null;
                if (owner == null && f.isData() && FileUtil.getMIMEType(f, null, "text/x-java") != null) {
                    String pkg = ModuleOraculum.parsePackage(f);
                    String[] pkgElements = pkg.isEmpty() ? new String[]{} : pkg.split("\\.");
                    owner = f.getParent();
                    for (int i = 0; owner != null && i < pkgElements.length; owner = owner.getParent(), ++i) {
                    }
                }
                return owner;
            });
        }
        if (root == null || JavaIndex.hasSourceCache(root.toURL(), false)) {
            return false;
        }
        String name = this.computeModuleIfAbsent(root, r -> {
            FileObject moduleInfo = r.getFileObject("module-info", "java");
            if (moduleInfo == null || !moduleInfo.isData() || !moduleInfo.canRead()) {
                return null;
            }
            return SourceUtils.parseModuleName(moduleInfo);
        });
        this.moduleName.set(name);
        return true;
    }

    @CheckForNull
    private FileObject computeRootIfAbsent(@NullAllowed FileObject key, @NonNull Function<FileObject, FileObject> provider) {
        FileObject value;
        FileObject owner;
        Pair<Reference<FileObject>, Reference<FileObject>> entry = this.rootCache.get();
        if (entry == null || (owner = entry.first().get()) == null || !owner.equals(key) || (value = entry.second().get()) == null) {
            value = provider.apply(key);
            this.rootCache.set(value == null ? null : Pair.of(new WeakReference<FileObject>(key), new WeakReference<FileObject>(value)));
            LOG.log(Level.FINE, "rootCache updated: {0}", value);
        }
        return value;
    }

    @CheckForNull
    private String computeModuleIfAbsent(@NonNull FileObject root, @NonNull Function<FileObject, String> provider) {
        String modName;
        FileObject owner;
        Pair<Pair<Reference<FileObject>, File>, String> entry = this.modNameCache.get();
        if (entry == null || (owner = entry.first().first().get()) == null || !owner.equals(root)) {
            modName = provider.apply(root);
            File modInfo = Optional.ofNullable(FileUtil.toFile(root)).map(rf -> new File((File)rf, String.format("%s.%s", "module-info", "java"))).orElse(null);
            Pair<Pair<WeakReference<FileObject>, File>, String> newEntry = Pair.of(Pair.of(new WeakReference<FileObject>(root), modInfo), modName);
            if (this.modNameCache.compareAndSet(entry, newEntry)) {
                if (entry != null && entry.first().second() != null) {
                    FileUtil.removeFileChangeListener(this, entry.first().second());
                }
                if (newEntry.first().second() != null) {
                    FileUtil.addFileChangeListener(this, newEntry.first().second());
                }
            }
            LOG.log(Level.FINE, "modNameCache updated: {0}", modName);
        } else {
            modName = entry.second();
        }
        return modName;
    }

    @NonNull
    private static String parsePackage(FileObject file) {
        String pkg = "";
        JavacTaskImpl jt = JavacParser.createJavacTask(new ClasspathInfo.Builder(ClassPath.EMPTY).build(), null, null, null, null, null, null, null, Collections.singletonList(FileObjects.fileObjectFileObject(file, file.getParent(), null, FileEncodingQuery.getEncoding(file))));
        CompilationUnitTree cu = jt.parse().iterator().next();
        pkg = Optional.ofNullable(cu.getPackage()).map(pt -> pt.getPackageName()).map(xt -> xt.toString()).orElse(pkg);
        return pkg;
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.resetModNameCache();
    }

    @Override
    public void fileChanged(FileEvent fe) {
        this.resetModNameCache();
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        this.resetModNameCache();
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.resetModNameCache();
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        this.resetModNameCache();
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void resetModNameCache() {
        Pair entry = this.modNameCache.getAndSet(null);
        if (entry != null && ((Pair)entry.first()).second() != null) {
            FileUtil.removeFileChangeListener(this, (File)((Pair)entry.first()).second());
        }
    }

    @CheckForNull
    static ModuleOraculum getInstance() {
        for (CompilerOptionsQueryImplementation impl : Lookup.getDefault().lookupAll(CompilerOptionsQueryImplementation.class)) {
            if (impl.getClass() != ModuleOraculum.class) continue;
            return (ModuleOraculum)impl;
        }
        return null;
    }

    private static final class R
    extends CompilerOptionsQueryImplementation.Result {
        private final List<? extends String> ops;

        R(@NonNull String moduleName) {
            Parameters.notNull("moduleName", moduleName);
            this.ops = Collections.singletonList("-Xnb-Xmodule:" + moduleName);
        }

        @Override
        public List<? extends String> getArguments() {
            return this.ops;
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
        }
    }
}

