/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.controller.status.history.StatusHistoryDump;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.runtime.util.HttpExchangeUtils;

class HealthStatusHistoryHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final int STREAM_RESPONSE_BODY = 0;
    private static final int NO_RESPONSE_BODY = -1;
    private static final String GET_METHOD = "GET";
    private static final Pattern DAYS_QUERY_PATTERN = Pattern.compile("^days=(\\d+)$");
    private static final int DAYS_GROUP = 1;
    private static final int DAYS_DEFAULT = 1;
    private final NiFiServer server;

    HealthStatusHistoryHttpHandler(NiFiServer server) {
        this.server = Objects.requireNonNull(server);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HttpExchangeUtils.drainRequestBody(exchange);
        String requestMethod = exchange.getRequestMethod();
        try (OutputStream responseBody = exchange.getResponseBody();){
            if (GET_METHOD.contentEquals(requestMethod)) {
                exchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, APPLICATION_JSON);
                exchange.sendResponseHeaders(200, 0L);
                URI requestUri = exchange.getRequestURI();
                int daysRequested = this.getDaysRequested(requestUri);
                StatusHistoryDumpFactory statusHistoryDumpFactory = this.server.getStatusHistoryDumpFactory();
                StatusHistoryDump statusHistoryDump = statusHistoryDumpFactory.create(daysRequested);
                statusHistoryDump.writeTo(responseBody);
            } else {
                exchange.sendResponseHeaders(405, -1L);
            }
        }
    }

    private int getDaysRequested(URI requestUri) {
        int daysRequested;
        String query = requestUri.getQuery();
        if (query == null) {
            daysRequested = 1;
        } else {
            Matcher matcher = DAYS_QUERY_PATTERN.matcher(query);
            if (matcher.matches()) {
                String daysGroup = matcher.group(1);
                daysRequested = Integer.parseInt(daysGroup);
            } else {
                daysRequested = 1;
            }
        }
        return daysRequested;
    }
}

