/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

class AutoConfiguredRestClientSsl
implements RestClientSsl {
    private final ClientHttpRequestFactoryBuilder<?> builder;
    private final ClientHttpRequestFactorySettings settings;
    private final SslBundles sslBundles;

    AutoConfiguredRestClientSsl(ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder, ClientHttpRequestFactorySettings clientHttpRequestFactorySettings, SslBundles sslBundles) {
        this.builder = clientHttpRequestFactoryBuilder;
        this.settings = clientHttpRequestFactorySettings;
        this.sslBundles = sslBundles;
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(String bundleName) {
        return this.fromBundle(this.sslBundles.getBundle(bundleName));
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(SslBundle bundle) {
        return builder -> builder.requestFactory(this.requestFactory(bundle));
    }

    private ClientHttpRequestFactory requestFactory(SslBundle bundle) {
        return this.builder.build(this.settings.withSslBundle(bundle));
    }
}

