/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.controller.status.LoadBalanceStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessingPerformanceStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedFlowState;

public class ProcessGroupStatus
implements Cloneable {
    private String id;
    private String name;
    private VersionedFlowState versionedFlowState;
    private RegisteredFlowSnapshotMetadata registeredFlowSnapshotMetadata;
    private Integer inputCount;
    private Long inputContentSize;
    private Integer outputCount;
    private Long outputContentSize;
    private Integer activeThreadCount;
    private Integer statelessActiveThreadCount;
    private Integer terminatedThreadCount;
    private Integer queuedCount;
    private Long queuedContentSize;
    private Long bytesRead;
    private Long bytesWritten;
    private int flowFilesReceived;
    private long bytesReceived;
    private int flowFilesSent;
    private long bytesSent;
    private int flowFilesTransferred;
    private long bytesTransferred;
    private long processingNanos;
    private Collection<ConnectionStatus> connectionStatus = new ArrayList<ConnectionStatus>();
    private Collection<ProcessorStatus> processorStatus = new ArrayList<ProcessorStatus>();
    private Collection<ProcessGroupStatus> processGroupStatus = new ArrayList<ProcessGroupStatus>();
    private Collection<RemoteProcessGroupStatus> remoteProcessGroupStatus = new ArrayList<RemoteProcessGroupStatus>();
    private Collection<PortStatus> inputPortStatus = new ArrayList<PortStatus>();
    private Collection<PortStatus> outputPortStatus = new ArrayList<PortStatus>();
    private ProcessingPerformanceStatus processingPerformanceStatus;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VersionedFlowState getVersionedFlowState() {
        return this.versionedFlowState;
    }

    public void setVersionedFlowState(VersionedFlowState versionedFlowState) {
        this.versionedFlowState = versionedFlowState;
    }

    public RegisteredFlowSnapshotMetadata getRegisteredFlowSnapshotMetadata() {
        return this.registeredFlowSnapshotMetadata;
    }

    public void setRegisteredFlowSnapshotMetadata(RegisteredFlowSnapshotMetadata registeredFlowSnapshotMetadata) {
        this.registeredFlowSnapshotMetadata = registeredFlowSnapshotMetadata;
    }

    public Integer getInputCount() {
        return this.inputCount;
    }

    public void setInputCount(Integer inputCount) {
        this.inputCount = inputCount;
    }

    public Long getInputContentSize() {
        return this.inputContentSize;
    }

    public void setInputContentSize(Long inputContentSize) {
        this.inputContentSize = inputContentSize;
    }

    public Integer getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(Integer outputCount) {
        this.outputCount = outputCount;
    }

    public Long getOutputContentSize() {
        return this.outputContentSize;
    }

    public void setOutputContentSize(Long outputContentSize) {
        this.outputContentSize = outputContentSize;
    }

    public Long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(Long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public Integer getQueuedCount() {
        return this.queuedCount;
    }

    public void setQueuedCount(Integer queuedCount) {
        this.queuedCount = queuedCount;
    }

    public Long getQueuedContentSize() {
        return this.queuedContentSize;
    }

    public void setQueuedContentSize(Long queuedContentSize) {
        this.queuedContentSize = queuedContentSize;
    }

    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    public Integer getStatelessActiveThreadCount() {
        return this.statelessActiveThreadCount;
    }

    public void setStatelessActiveThreadCount(Integer statelessActiveThreadCount) {
        this.statelessActiveThreadCount = statelessActiveThreadCount;
    }

    public Integer getTerminatedThreadCount() {
        return this.terminatedThreadCount;
    }

    public void setTerminatedThreadCount(Integer terminatedThreadCount) {
        this.terminatedThreadCount = terminatedThreadCount;
    }

    public Collection<ConnectionStatus> getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(Collection<ConnectionStatus> connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public Collection<ProcessorStatus> getProcessorStatus() {
        return this.processorStatus;
    }

    public void setProcessorStatus(Collection<ProcessorStatus> processorStatus) {
        this.processorStatus = processorStatus;
    }

    public Collection<ProcessGroupStatus> getProcessGroupStatus() {
        return this.processGroupStatus;
    }

    public void setProcessGroupStatus(Collection<ProcessGroupStatus> processGroupStatus) {
        this.processGroupStatus = processGroupStatus;
    }

    public Collection<PortStatus> getInputPortStatus() {
        return this.inputPortStatus;
    }

    public void setInputPortStatus(Collection<PortStatus> inputPortStatus) {
        this.inputPortStatus = inputPortStatus;
    }

    public Collection<PortStatus> getOutputPortStatus() {
        return this.outputPortStatus;
    }

    public void setOutputPortStatus(Collection<PortStatus> outputPortStatus) {
        this.outputPortStatus = outputPortStatus;
    }

    public Collection<RemoteProcessGroupStatus> getRemoteProcessGroupStatus() {
        return this.remoteProcessGroupStatus;
    }

    public void setRemoteProcessGroupStatus(Collection<RemoteProcessGroupStatus> remoteProcessGroupStatus) {
        this.remoteProcessGroupStatus = remoteProcessGroupStatus;
    }

    public int getFlowFilesReceived() {
        return this.flowFilesReceived;
    }

    public void setFlowFilesReceived(int flowFilesReceived) {
        this.flowFilesReceived = flowFilesReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public int getFlowFilesSent() {
        return this.flowFilesSent;
    }

    public void setFlowFilesSent(int flowFilesSent) {
        this.flowFilesSent = flowFilesSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public int getFlowFilesTransferred() {
        return this.flowFilesTransferred;
    }

    public void setFlowFilesTransferred(int flowFilesTransferred) {
        this.flowFilesTransferred = flowFilesTransferred;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this.bytesTransferred = bytesTransferred;
    }

    public long getProcessingNanos() {
        return this.processingNanos;
    }

    public void setProcessingNanos(long processingNanos) {
        this.processingNanos = processingNanos;
    }

    public ProcessingPerformanceStatus getProcessingPerformanceStatus() {
        return this.processingPerformanceStatus;
    }

    public void setProcessingPerformanceStatus(ProcessingPerformanceStatus processingPerformanceStatus) {
        this.processingPerformanceStatus = processingPerformanceStatus;
    }

    public ProcessGroupStatus clone() {
        ArrayList<ConnectionStatus> statusList;
        ProcessGroupStatus clonedObj = new ProcessGroupStatus();
        clonedObj.id = this.id;
        clonedObj.name = this.name;
        clonedObj.outputContentSize = this.outputContentSize;
        clonedObj.outputCount = this.outputCount;
        clonedObj.inputContentSize = this.inputContentSize;
        clonedObj.inputCount = this.inputCount;
        clonedObj.activeThreadCount = this.activeThreadCount;
        clonedObj.terminatedThreadCount = this.terminatedThreadCount;
        clonedObj.queuedContentSize = this.queuedContentSize;
        clonedObj.queuedCount = this.queuedCount;
        clonedObj.bytesRead = this.bytesRead;
        clonedObj.bytesWritten = this.bytesWritten;
        clonedObj.flowFilesReceived = this.flowFilesReceived;
        clonedObj.bytesReceived = this.bytesReceived;
        clonedObj.flowFilesSent = this.flowFilesSent;
        clonedObj.bytesSent = this.bytesSent;
        clonedObj.flowFilesTransferred = this.flowFilesTransferred;
        clonedObj.bytesTransferred = this.bytesTransferred;
        clonedObj.processingNanos = this.processingNanos;
        clonedObj.processingPerformanceStatus = this.processingPerformanceStatus;
        if (this.connectionStatus != null) {
            statusList = new ArrayList<ConnectionStatus>();
            clonedObj.setConnectionStatus(statusList);
            for (ConnectionStatus connectionStatus : this.connectionStatus) {
                statusList.add(connectionStatus.clone());
            }
        }
        if (this.processorStatus != null) {
            statusList = new ArrayList();
            clonedObj.setProcessorStatus(statusList);
            for (ProcessorStatus processorStatus : this.processorStatus) {
                statusList.add((ConnectionStatus)((Object)processorStatus.clone()));
            }
        }
        if (this.inputPortStatus != null) {
            statusList = new ArrayList();
            clonedObj.setInputPortStatus(statusList);
            for (PortStatus portStatus : this.inputPortStatus) {
                statusList.add((ConnectionStatus)((Object)portStatus.clone()));
            }
        }
        if (this.outputPortStatus != null) {
            statusList = new ArrayList();
            clonedObj.setOutputPortStatus(statusList);
            for (PortStatus portStatus : this.outputPortStatus) {
                statusList.add((ConnectionStatus)((Object)portStatus.clone()));
            }
        }
        if (this.processGroupStatus != null) {
            statusList = new ArrayList();
            clonedObj.setProcessGroupStatus(statusList);
            for (ProcessGroupStatus processGroupStatus : this.processGroupStatus) {
                statusList.add((ConnectionStatus)((Object)processGroupStatus.clone()));
            }
        }
        if (this.remoteProcessGroupStatus != null) {
            statusList = new ArrayList();
            clonedObj.setRemoteProcessGroupStatus(statusList);
            for (RemoteProcessGroupStatus remoteProcessGroupStatus : this.remoteProcessGroupStatus) {
                statusList.add((ConnectionStatus)((Object)remoteProcessGroupStatus.clone()));
            }
        }
        return clonedObj;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessGroupStatus [id=");
        builder.append(this.id);
        builder.append(", inputCount=");
        builder.append(this.inputCount);
        builder.append(", inputBytes=");
        builder.append(this.inputContentSize);
        builder.append(", outputCount=");
        builder.append(this.outputCount);
        builder.append(", outputBytes=");
        builder.append(this.outputContentSize);
        builder.append(", activeThreadCount=");
        builder.append(this.activeThreadCount);
        builder.append(", terminatedThreadCount=");
        builder.append(this.terminatedThreadCount);
        builder.append(", flowFilesTransferred=");
        builder.append(this.flowFilesTransferred);
        builder.append(", bytesTransferred=");
        builder.append(this.bytesTransferred);
        builder.append(", flowFilesReceived=");
        builder.append(this.flowFilesReceived);
        builder.append(", bytesReceived=");
        builder.append(this.bytesReceived);
        builder.append(", flowFilesSent=");
        builder.append(this.flowFilesSent);
        builder.append(", bytesSent=");
        builder.append(this.bytesSent);
        builder.append(", processingNanos=");
        builder.append(this.processingNanos);
        builder.append(",\n\tconnectionStatus=");
        for (ConnectionStatus connectionStatus : this.connectionStatus) {
            builder.append("\n\t\t");
            builder.append(connectionStatus);
        }
        builder.append(",\n\tprocessorStatus=");
        for (ProcessorStatus processorStatus : this.processorStatus) {
            builder.append("\n\t\t");
            builder.append(processorStatus);
        }
        builder.append(",\n\tprocessGroupStatus=");
        for (ProcessGroupStatus processGroupStatus : this.processGroupStatus) {
            builder.append("\n\t\t");
            builder.append(processGroupStatus);
        }
        builder.append(",\n\tremoteProcessGroupStatus=");
        for (RemoteProcessGroupStatus remoteProcessGroupStatus : this.remoteProcessGroupStatus) {
            builder.append("\n\t\t");
            builder.append(remoteProcessGroupStatus);
        }
        builder.append(",\n\tinputPortStatus=");
        for (PortStatus portStatus : this.inputPortStatus) {
            builder.append("\n\t\t");
            builder.append(portStatus);
        }
        builder.append(",\n\toutputPortStatus=");
        for (PortStatus portStatus : this.outputPortStatus) {
            builder.append("\n\t\t");
            builder.append(portStatus);
        }
        builder.append(", processingPerformanceStatus=");
        builder.append(this.processingPerformanceStatus);
        builder.append("]");
        return builder.toString();
    }

    public static void merge(ProcessGroupStatus target, ProcessGroupStatus toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        target.setInputCount(target.getInputCount() + toMerge.getInputCount());
        target.setInputContentSize(target.getInputContentSize() + toMerge.getInputContentSize());
        target.setOutputCount(target.getOutputCount() + toMerge.getOutputCount());
        target.setOutputContentSize(target.getOutputContentSize() + toMerge.getOutputContentSize());
        target.setQueuedCount(target.getQueuedCount() + toMerge.getQueuedCount());
        target.setQueuedContentSize(target.getQueuedContentSize() + toMerge.getQueuedContentSize());
        target.setBytesRead(target.getBytesRead() + toMerge.getBytesRead());
        target.setBytesWritten(target.getBytesWritten() + toMerge.getBytesWritten());
        target.setActiveThreadCount(target.getActiveThreadCount() + toMerge.getActiveThreadCount());
        target.setStatelessActiveThreadCount(target.getStatelessActiveThreadCount() + toMerge.getStatelessActiveThreadCount());
        target.setTerminatedThreadCount(target.getTerminatedThreadCount() + toMerge.getTerminatedThreadCount());
        target.setFlowFilesTransferred(target.getFlowFilesTransferred() + toMerge.getFlowFilesTransferred());
        target.setBytesTransferred(target.getBytesTransferred() + toMerge.getBytesTransferred());
        target.setFlowFilesReceived(target.getFlowFilesReceived() + toMerge.getFlowFilesReceived());
        target.setBytesReceived(target.getBytesReceived() + toMerge.getBytesReceived());
        target.setFlowFilesSent(target.getFlowFilesSent() + toMerge.getFlowFilesSent());
        target.setBytesSent(target.getBytesSent() + toMerge.getBytesSent());
        target.setProcessingNanos(target.getProcessingNanos() + toMerge.getProcessingNanos());
        if (VersionedFlowState.SYNC_FAILURE.equals((Object)toMerge.getVersionedFlowState())) {
            target.setVersionedFlowState(VersionedFlowState.SYNC_FAILURE);
        }
        target.setRegisteredFlowSnapshotMetadata(toMerge.getRegisteredFlowSnapshotMetadata());
        HashMap<String, ConnectionStatus> mergedConnectionMap = new HashMap<String, ConnectionStatus>();
        for (ConnectionStatus connectionStatus : target.getConnectionStatus()) {
            mergedConnectionMap.put(connectionStatus.getId(), connectionStatus);
        }
        for (ConnectionStatus connectionStatus : toMerge.getConnectionStatus()) {
            ConnectionStatus connectionStatus2 = (ConnectionStatus)mergedConnectionMap.get(connectionStatus.getId());
            if (connectionStatus2 == null) {
                mergedConnectionMap.put(connectionStatus.getId(), connectionStatus.clone());
                continue;
            }
            connectionStatus2.setQueuedCount(connectionStatus2.getQueuedCount() + connectionStatus.getQueuedCount());
            connectionStatus2.setQueuedBytes(connectionStatus2.getQueuedBytes() + connectionStatus.getQueuedBytes());
            connectionStatus2.setInputCount(connectionStatus2.getInputCount() + connectionStatus.getInputCount());
            connectionStatus2.setInputBytes(connectionStatus2.getInputBytes() + connectionStatus.getInputBytes());
            connectionStatus2.setOutputCount(connectionStatus2.getOutputCount() + connectionStatus.getOutputCount());
            connectionStatus2.setOutputBytes(connectionStatus2.getOutputBytes() + connectionStatus.getOutputBytes());
            connectionStatus2.setFlowFileAvailability(ProcessGroupStatus.mergeFlowFileAvailability(connectionStatus2.getFlowFileAvailability(), connectionStatus.getFlowFileAvailability()));
            connectionStatus2.setLoadBalanceStatus(ProcessGroupStatus.mergeLoadBalanceStatus(connectionStatus2.getLoadBalanceStatus(), connectionStatus.getLoadBalanceStatus()));
        }
        target.setConnectionStatus(mergedConnectionMap.values());
        HashMap<String, ProcessorStatus> mergedProcessorMap = new HashMap<String, ProcessorStatus>();
        for (ProcessorStatus processorStatus : target.getProcessorStatus()) {
            mergedProcessorMap.put(processorStatus.getId(), processorStatus);
        }
        for (ProcessorStatus processorStatus : toMerge.getProcessorStatus()) {
            ProcessorStatus processorStatus2 = (ProcessorStatus)mergedProcessorMap.get(processorStatus.getId());
            if (processorStatus2 == null) {
                mergedProcessorMap.put(processorStatus.getId(), processorStatus.clone());
                continue;
            }
            processorStatus2.setActiveThreadCount(processorStatus2.getActiveThreadCount() + processorStatus.getActiveThreadCount());
            processorStatus2.setTerminatedThreadCount(processorStatus2.getTerminatedThreadCount() + processorStatus.getTerminatedThreadCount());
            processorStatus2.setBytesRead(processorStatus2.getBytesRead() + processorStatus.getBytesRead());
            processorStatus2.setBytesWritten(processorStatus2.getBytesWritten() + processorStatus.getBytesWritten());
            processorStatus2.setInputBytes(processorStatus2.getInputBytes() + processorStatus.getInputBytes());
            processorStatus2.setInputCount(processorStatus2.getInputCount() + processorStatus.getInputCount());
            processorStatus2.setInvocations(processorStatus2.getInvocations() + processorStatus.getInvocations());
            processorStatus2.setOutputBytes(processorStatus2.getOutputBytes() + processorStatus.getOutputBytes());
            processorStatus2.setOutputCount(processorStatus2.getOutputCount() + processorStatus.getOutputCount());
            processorStatus2.setProcessingNanos(processorStatus2.getProcessingNanos() + processorStatus.getProcessingNanos());
            processorStatus2.setFlowFilesRemoved(processorStatus2.getFlowFilesRemoved() + processorStatus.getFlowFilesRemoved());
            if (RunStatus.Validating.equals((Object)processorStatus.getRunStatus())) {
                processorStatus2.setRunStatus(RunStatus.Validating);
                continue;
            }
            if (!RunStatus.Invalid.equals((Object)processorStatus.getRunStatus())) continue;
            processorStatus2.setRunStatus(RunStatus.Invalid);
        }
        target.setProcessorStatus(mergedProcessorMap.values());
        HashMap<String, PortStatus> hashMap = new HashMap<String, PortStatus>();
        for (PortStatus portStatus : target.getInputPortStatus()) {
            hashMap.put(portStatus.getId(), portStatus);
        }
        for (PortStatus portStatus : toMerge.getInputPortStatus()) {
            PortStatus portStatus2 = (PortStatus)hashMap.get(portStatus.getId());
            if (portStatus2 == null) {
                hashMap.put(portStatus.getId(), portStatus.clone());
                continue;
            }
            portStatus2.setInputBytes(portStatus2.getInputBytes() + portStatus.getInputBytes());
            portStatus2.setInputCount(portStatus2.getInputCount() + portStatus.getInputCount());
            portStatus2.setOutputBytes(portStatus2.getOutputBytes() + portStatus.getOutputBytes());
            portStatus2.setOutputCount(portStatus2.getOutputCount() + portStatus.getOutputCount());
            portStatus2.setActiveThreadCount(portStatus2.getActiveThreadCount() + portStatus.getActiveThreadCount());
            if (portStatus.isTransmitting() != null && portStatus.isTransmitting().booleanValue()) {
                portStatus2.setTransmitting(true);
            }
            if (!RunStatus.Invalid.equals((Object)portStatus.getRunStatus())) continue;
            portStatus2.setRunStatus(RunStatus.Invalid);
        }
        target.setInputPortStatus(hashMap.values());
        HashMap<String, PortStatus> hashMap2 = new HashMap<String, PortStatus>();
        for (PortStatus portStatus : target.getOutputPortStatus()) {
            hashMap2.put(portStatus.getId(), portStatus);
        }
        for (PortStatus portStatus : toMerge.getOutputPortStatus()) {
            PortStatus portStatus3 = (PortStatus)hashMap2.get(portStatus.getId());
            if (portStatus3 == null) {
                hashMap2.put(portStatus.getId(), portStatus.clone());
                continue;
            }
            portStatus3.setInputBytes(portStatus3.getInputBytes() + portStatus.getInputBytes());
            portStatus3.setInputCount(portStatus3.getInputCount() + portStatus.getInputCount());
            portStatus3.setOutputBytes(portStatus3.getOutputBytes() + portStatus.getOutputBytes());
            portStatus3.setOutputCount(portStatus3.getOutputCount() + portStatus.getOutputCount());
            portStatus3.setActiveThreadCount(portStatus3.getActiveThreadCount() + portStatus.getActiveThreadCount());
            if (portStatus.isTransmitting() != null && portStatus.isTransmitting().booleanValue()) {
                portStatus3.setTransmitting(true);
            }
            if (!RunStatus.Invalid.equals((Object)portStatus.getRunStatus())) continue;
            portStatus3.setRunStatus(RunStatus.Invalid);
        }
        target.setOutputPortStatus(hashMap2.values());
        HashMap<String, ProcessGroupStatus> hashMap3 = new HashMap<String, ProcessGroupStatus>();
        for (ProcessGroupStatus processGroupStatus : target.getProcessGroupStatus()) {
            hashMap3.put(processGroupStatus.getId(), processGroupStatus);
        }
        for (ProcessGroupStatus processGroupStatus : toMerge.getProcessGroupStatus()) {
            ProcessGroupStatus merged = (ProcessGroupStatus)hashMap3.get(processGroupStatus.getId());
            if (merged == null) {
                hashMap3.put(processGroupStatus.getId(), processGroupStatus.clone());
                continue;
            }
            ProcessGroupStatus.merge(merged, processGroupStatus);
        }
        target.setOutputPortStatus(hashMap2.values());
        HashMap<String, RemoteProcessGroupStatus> hashMap4 = new HashMap<String, RemoteProcessGroupStatus>();
        for (RemoteProcessGroupStatus status : target.getRemoteProcessGroupStatus()) {
            hashMap4.put(status.getId(), status);
        }
        for (RemoteProcessGroupStatus statusToMerge : toMerge.getRemoteProcessGroupStatus()) {
            RemoteProcessGroupStatus merged = (RemoteProcessGroupStatus)hashMap4.get(statusToMerge.getId());
            if (merged == null) {
                hashMap4.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            merged.setReceivedContentSize(merged.getReceivedContentSize() + statusToMerge.getReceivedContentSize());
            merged.setReceivedCount(merged.getReceivedCount() + statusToMerge.getReceivedCount());
            merged.setSentContentSize(merged.getSentContentSize() + statusToMerge.getSentContentSize());
            merged.setSentCount(merged.getSentCount() + statusToMerge.getSentCount());
            merged.setActiveThreadCount(merged.getActiveThreadCount() + statusToMerge.getActiveThreadCount());
            Date mergedLastRefreshTime = merged.getLastRefreshTime();
            Date toMergeLastRefreshTime = statusToMerge.getLastRefreshTime();
            if (mergedLastRefreshTime != null && (toMergeLastRefreshTime == null || !toMergeLastRefreshTime.before(mergedLastRefreshTime))) continue;
            merged.setLastRefreshTime(toMergeLastRefreshTime);
        }
        target.setRemoteProcessGroupStatus(hashMap4.values());
        ProcessingPerformanceStatus processingPerformanceStatus = target.getProcessingPerformanceStatus();
        ProcessingPerformanceStatus toMergePerformanceStatus = toMerge.getProcessingPerformanceStatus();
        if (processingPerformanceStatus != null && toMergePerformanceStatus != null) {
            processingPerformanceStatus.setIdentifier(toMergePerformanceStatus.getIdentifier());
            processingPerformanceStatus.setCpuDuration(processingPerformanceStatus.getCpuDuration() + toMergePerformanceStatus.getCpuDuration());
            processingPerformanceStatus.setContentReadDuration(processingPerformanceStatus.getContentReadDuration() + toMergePerformanceStatus.getContentReadDuration());
            processingPerformanceStatus.setContentWriteDuration(processingPerformanceStatus.getContentWriteDuration() + toMergePerformanceStatus.getContentWriteDuration());
            processingPerformanceStatus.setSessionCommitDuration(processingPerformanceStatus.getSessionCommitDuration() + toMergePerformanceStatus.getSessionCommitDuration());
            processingPerformanceStatus.setGarbageCollectionDuration(processingPerformanceStatus.getGarbageCollectionDuration() + toMergePerformanceStatus.getGarbageCollectionDuration());
        } else {
            target.setProcessingPerformanceStatus(processingPerformanceStatus);
        }
    }

    public static FlowFileAvailability mergeFlowFileAvailability(FlowFileAvailability availabilityA, FlowFileAvailability availabilityB) {
        if (availabilityA == availabilityB) {
            return availabilityA;
        }
        if (availabilityA == null) {
            return availabilityB;
        }
        if (availabilityB == null) {
            return availabilityA;
        }
        if (availabilityA == FlowFileAvailability.FLOWFILE_AVAILABLE || availabilityB == FlowFileAvailability.FLOWFILE_AVAILABLE) {
            return FlowFileAvailability.FLOWFILE_AVAILABLE;
        }
        if (availabilityA == FlowFileAvailability.HEAD_OF_QUEUE_PENALIZED || availabilityB == FlowFileAvailability.HEAD_OF_QUEUE_PENALIZED) {
            return FlowFileAvailability.HEAD_OF_QUEUE_PENALIZED;
        }
        return FlowFileAvailability.FLOWFILE_AVAILABLE;
    }

    public static LoadBalanceStatus mergeLoadBalanceStatus(LoadBalanceStatus statusA, LoadBalanceStatus statusB) {
        if (statusA == statusB) {
            return statusA;
        }
        if (statusA == null) {
            return statusB;
        }
        if (statusB == null) {
            return statusA;
        }
        if (statusA == LoadBalanceStatus.LOAD_BALANCE_ACTIVE || statusB == LoadBalanceStatus.LOAD_BALANCE_ACTIVE) {
            return LoadBalanceStatus.LOAD_BALANCE_ACTIVE;
        }
        if (statusA == LoadBalanceStatus.LOAD_BALANCE_INACTIVE || statusB == LoadBalanceStatus.LOAD_BALANCE_INACTIVE) {
            return LoadBalanceStatus.LOAD_BALANCE_INACTIVE;
        }
        return LoadBalanceStatus.LOAD_BALANCE_NOT_CONFIGURED;
    }
}

