/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.Ed25519PublicKeyDecoder;
import org.apache.sshd.common.util.security.eddsa.OpenSSHEd25519PrivateKeyEntryDecoder;
import org.apache.sshd.common.util.security.eddsa.SignatureEd25519;

public final class EdDSASecurityProviderUtils {
    public static final String CURVE_ED25519_SHA512 = "Ed25519";
    public static final int KEY_SIZE = 256;

    private EdDSASecurityProviderUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean isEDDSAKey(Key key) {
        return EdDSASecurityProviderUtils.getEDDSAKeySize(key) == 256;
    }

    public static int getEDDSAKeySize(Key key) {
        return SecurityUtils.isEDDSACurveSupported() && key instanceof EdDSAKey ? 256 : -1;
    }

    public static boolean compareEDDSAPPublicKeys(PublicKey k1, PublicKey k2) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            return false;
        }
        if (k1 instanceof EdDSAPublicKey && k2 instanceof EdDSAPublicKey) {
            if (k1.equals(k2)) {
                return true;
            }
            EdDSAPublicKey ed1 = (EdDSAPublicKey)k1;
            EdDSAPublicKey ed2 = (EdDSAPublicKey)k2;
            return Arrays.equals(ed1.getAbyte(), ed2.getAbyte()) && EdDSASecurityProviderUtils.compareEDDSAKeyParams(ed1.getParams(), ed2.getParams());
        }
        return false;
    }

    public static boolean isEDDSASignatureAlgorithm(String algorithm) {
        return "NONEwithEdDSA".equalsIgnoreCase(algorithm);
    }

    public static EdDSAPublicKey recoverEDDSAPublicKey(PrivateKey key) throws GeneralSecurityException {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        if (!(key instanceof EdDSAPrivateKey)) {
            throw new InvalidKeyException("Private key is not EdDSA");
        }
        EdDSAPrivateKey prvKey = (EdDSAPrivateKey)key;
        EdDSAPublicKeySpec keySpec = new EdDSAPublicKeySpec(prvKey.getAbyte(), prvKey.getParams());
        KeyFactory factory = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPublicKey)EdDSAPublicKey.class.cast(factory.generatePublic((KeySpec)keySpec));
    }

    public static Signature getEDDSASignature() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return new SignatureEd25519();
    }

    public static boolean isEDDSAKeyFactoryAlgorithm(String algorithm) {
        return "EdDSA".equalsIgnoreCase(algorithm);
    }

    public static boolean isEDDSAKeyPairGeneratorAlgorithm(String algorithm) {
        return "EdDSA".equalsIgnoreCase(algorithm);
    }

    public static PublicKeyEntryDecoder<? extends PublicKey, ? extends PrivateKey> getEDDSAPublicKeyEntryDecoder() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return Ed25519PublicKeyDecoder.INSTANCE;
    }

    public static PrivateKeyEntryDecoder<? extends PublicKey, ? extends PrivateKey> getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return OpenSSHEd25519PrivateKeyEntryDecoder.INSTANCE;
    }

    public static boolean compareEDDSAPrivateKeys(PrivateKey k1, PrivateKey k2) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            return false;
        }
        if (k1 instanceof EdDSAPrivateKey && k2 instanceof EdDSAPrivateKey) {
            if (k1.equals(k2)) {
                return true;
            }
            EdDSAPrivateKey ed1 = (EdDSAPrivateKey)k1;
            EdDSAPrivateKey ed2 = (EdDSAPrivateKey)k2;
            return Arrays.equals(ed1.getSeed(), ed2.getSeed()) && EdDSASecurityProviderUtils.compareEDDSAKeyParams(ed1.getParams(), ed2.getParams());
        }
        return false;
    }

    public static boolean compareEDDSAKeyParams(EdDSAParameterSpec s1, EdDSAParameterSpec s2) {
        if (Objects.equals(s1, s2)) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return Objects.equals(s1.getHashAlgorithm(), s2.getHashAlgorithm()) && Objects.equals(s1.getCurve(), s2.getCurve()) && Objects.equals(s1.getB(), s2.getB());
    }

    public static PublicKey generateEDDSAPublicKey(byte[] seed) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA not supported");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName((String)CURVE_ED25519_SHA512);
        EdDSAPublicKeySpec keySpec = new EdDSAPublicKeySpec(seed, (EdDSAParameterSpec)params);
        KeyFactory factory = SecurityUtils.getKeyFactory("EdDSA");
        return factory.generatePublic((KeySpec)keySpec);
    }

    public static PrivateKey generateEDDSAPrivateKey(byte[] seed) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA not supported");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName((String)CURVE_ED25519_SHA512);
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)params);
        KeyFactory factory = SecurityUtils.getKeyFactory("EdDSA");
        return factory.generatePrivate((KeySpec)keySpec);
    }

    public static <B extends Buffer> B putRawEDDSAPublicKey(B buffer, PublicKey key) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        EdDSAPublicKey edKey = ValidateUtils.checkInstanceOf((Object)key, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)key);
        byte[] seed = Ed25519PublicKeyDecoder.getSeedValue(edKey);
        ValidateUtils.checkNotNull(seed, "No seed extracted from key: %s", (Object)edKey.getA());
        buffer.putBytes(seed);
        return buffer;
    }

    public static <B extends Buffer> B putEDDSAKeyPair(B buffer, PublicKey pubKey, PrivateKey prvKey) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        ValidateUtils.checkInstanceOf((Object)pubKey, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)pubKey);
        ValidateUtils.checkInstanceOf((Object)prvKey, EdDSAPrivateKey.class, "Not an EDDSA private key: %s", (Object)prvKey);
        throw new UnsupportedOperationException("Full SSHD-440 implementation N/A");
    }
}

