/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.nar;

import java.io.File;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoUnloadService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoUnloadService.class);
    private static final String UNPACKED_POSTFIX = "-unpacked";
    private final ExtensionManager extensionManager;
    private final File extensionWorkDirectory;
    private final NarLoader narLoader;

    public NarAutoUnloadService(ExtensionManager extensionManager, File extensionWorkDirectory, NarLoader narLoader) {
        this.extensionManager = extensionManager;
        this.extensionWorkDirectory = extensionWorkDirectory;
        this.narLoader = narLoader;
    }

    public void unloadNarFile(String fileName) {
        if (this.isSupported(fileName)) {
            File narWorkingDirectory = new File(this.extensionWorkDirectory, fileName + UNPACKED_POSTFIX);
            this.extensionManager.getAllBundles().stream().filter(bundle -> bundle.getBundleDetails().getWorkingDirectory().getPath().equals(narWorkingDirectory.getPath())).findFirst().ifPresentOrElse(arg_0 -> ((NarLoader)this.narLoader).unload(arg_0), () -> LOGGER.warn("NAR bundle not found for {}", (Object)fileName));
        }
    }

    private boolean isSupported(String fileName) {
        if (!fileName.endsWith(".nar")) {
            LOGGER.info("Skipping non-nar file {}", (Object)fileName);
            return false;
        }
        if (fileName.startsWith(".")) {
            LOGGER.debug("Skipping partially written file {}", (Object)fileName);
            return false;
        }
        return true;
    }
}

