/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.json;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithId;

public class ComponentPropertyProvider {
    private static final Map<ConnectableComponentType, Function<ProcessGroupSchema, List<? extends BaseSchemaWithId>>> PG_COMPONENT_CONNECTABLE_TYPE_WITH_ACCESSOR = Map.of(ConnectableComponentType.PROCESSOR, ProcessGroupSchema::getProcessors, ConnectableComponentType.INPUT_PORT, ProcessGroupSchema::getInputPortSchemas, ConnectableComponentType.OUTPUT_PORT, ProcessGroupSchema::getOutputPortSchemas, ConnectableComponentType.FUNNEL, ProcessGroupSchema::getFunnels);
    private static final Map<ConnectableComponentType, Function<RemoteProcessGroupSchema, List<? extends BaseSchemaWithId>>> RPG_COMPONENT_CONNECTABLE_TYPE_WITH_ACCESSOR = Map.of(ConnectableComponentType.REMOTE_INPUT_PORT, RemoteProcessGroupSchema::getInputPorts, ConnectableComponentType.REMOTE_OUTPUT_PORT, RemoteProcessGroupSchema::getOutputPorts);
    private final Map<String, String> componentIdToParentIdMap;
    private final Map<String, ConnectableComponentType> componentTypeMap;

    public ComponentPropertyProvider(ConfigSchema configSchema) {
        this.componentIdToParentIdMap = this.createComponentIdToParentIdMap(configSchema);
        this.componentTypeMap = this.createComponentTypeMap(configSchema);
    }

    public String parentId(String componentId) {
        return this.componentIdToParentIdMap.get(componentId);
    }

    public ConnectableComponentType connectableComponentType(String componentId) {
        return this.componentTypeMap.get(componentId);
    }

    private Map<String, String> createComponentIdToParentIdMap(ConfigSchema configSchema) {
        return Stream.concat(this.fetchControllerServicesProperties(configSchema.getProcessGroupSchema()), Stream.concat(this.fetchProcessGroupComponentProperties(configSchema.getProcessGroupSchema()), this.fetchRemoteProcessGroupComponentsProperties(configSchema.getProcessGroupSchema())).map(triple -> Pair.of((Object)((String)triple.getLeft()), (Object)((String)triple.getMiddle())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private Map<String, ConnectableComponentType> createComponentTypeMap(ConfigSchema configSchema) {
        return Stream.concat(this.fetchProcessGroupComponentProperties(configSchema.getProcessGroupSchema()), this.fetchRemoteProcessGroupComponentsProperties(configSchema.getProcessGroupSchema())).filter(triple -> Objects.nonNull(triple.getRight())).collect(Collectors.toMap(Triple::getLeft, Triple::getRight));
    }

    private Stream<Triple<String, String, ConnectableComponentType>> fetchProcessGroupComponentProperties(ProcessGroupSchema processGroupSchema) {
        return Stream.concat(Stream.concat(Optional.ofNullable(processGroupSchema.getProcessGroupSchemas()).orElse(List.of()).stream().map(BaseSchemaWithId::getId).map(childProcessGroupId -> Triple.of((Object)childProcessGroupId, (Object)processGroupSchema.getId(), null)), PG_COMPONENT_CONNECTABLE_TYPE_WITH_ACCESSOR.entrySet().stream().flatMap(schemaAccessorAndComponentType -> this.getProcessGroupComponentsProperties(processGroupSchema, (Function)schemaAccessorAndComponentType.getValue(), (ConnectableComponentType)schemaAccessorAndComponentType.getKey()))), Optional.ofNullable(processGroupSchema.getProcessGroupSchemas()).orElse(List.of()).stream().flatMap(this::fetchProcessGroupComponentProperties));
    }

    private Stream<Triple<String, String, ConnectableComponentType>> getProcessGroupComponentsProperties(ProcessGroupSchema processGroupSchema, Function<ProcessGroupSchema, List<? extends BaseSchemaWithId>> schemaAccessor, ConnectableComponentType componentType) {
        return Optional.ofNullable(schemaAccessor.apply(processGroupSchema)).orElse(List.of()).stream().map(component -> Triple.of((Object)component.getId(), (Object)processGroupSchema.getId(), (Object)componentType));
    }

    private Stream<Triple<String, String, ConnectableComponentType>> fetchRemoteProcessGroupComponentsProperties(ProcessGroupSchema processGroupSchema) {
        return Stream.concat(Stream.concat(Optional.ofNullable(processGroupSchema.getRemoteProcessGroups()).orElse(List.of()).stream().map(BaseSchemaWithId::getId).map(remoteProcessGroupId -> Triple.of((Object)remoteProcessGroupId, (Object)processGroupSchema.getId(), null)), Optional.ofNullable(processGroupSchema.getRemoteProcessGroups()).orElse(List.of()).stream().flatMap(remoteProcessGroupSchema -> RPG_COMPONENT_CONNECTABLE_TYPE_WITH_ACCESSOR.entrySet().stream().flatMap(schemaAccessorAndComponentType -> this.getRemoteProcessGroupComponentsProperties((RemoteProcessGroupSchema)remoteProcessGroupSchema, (Function)schemaAccessorAndComponentType.getValue(), (ConnectableComponentType)schemaAccessorAndComponentType.getKey())))), Optional.ofNullable(processGroupSchema.getProcessGroupSchemas()).orElse(List.of()).stream().flatMap(this::fetchRemoteProcessGroupComponentsProperties));
    }

    private Stream<Triple<String, String, ConnectableComponentType>> getRemoteProcessGroupComponentsProperties(RemoteProcessGroupSchema remoteProcessGroupSchema, Function<RemoteProcessGroupSchema, List<? extends BaseSchemaWithId>> schemaAccessor, ConnectableComponentType componentType) {
        return Optional.ofNullable(schemaAccessor.apply(remoteProcessGroupSchema)).orElse(List.of()).stream().map(component -> Triple.of((Object)component.getId(), (Object)remoteProcessGroupSchema.getId(), (Object)componentType));
    }

    private Stream<Pair<String, String>> fetchControllerServicesProperties(ProcessGroupSchema processGroupSchema) {
        return Stream.concat(Optional.ofNullable(processGroupSchema.getControllerServices()).orElse(List.of()).stream().map(controllerServiceSchema -> Pair.of((Object)controllerServiceSchema.getId(), (Object)processGroupSchema.getId())), Optional.ofNullable(processGroupSchema.getProcessGroupSchemas()).orElse(List.of()).stream().flatMap(this::fetchControllerServicesProperties));
    }
}

