/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.PersistentProperty;

public interface PropertyValueConverter<DV, SV, C extends ValueConversionContext<? extends PersistentProperty<?>>> {
    public @Nullable DV read(SV var1, C var2);

    default public @Nullable DV readNull(C context) {
        return null;
    }

    public @Nullable SV write(DV var1, C var2);

    default public @Nullable SV writeNull(C context) {
        return null;
    }

    public static class FunctionPropertyValueConverter<DV, SV, P extends PersistentProperty<P>>
    implements PropertyValueConverter<DV, SV, ValueConversionContext<P>> {
        private final BiFunction<DV, ValueConversionContext<P>, SV> writer;
        private final BiFunction<SV, ValueConversionContext<P>, DV> reader;

        public FunctionPropertyValueConverter(BiFunction<DV, ValueConversionContext<P>, SV> writer, BiFunction<SV, ValueConversionContext<P>, DV> reader) {
            this.writer = writer;
            this.reader = reader;
        }

        @Override
        public @Nullable SV write(@Nullable DV value, ValueConversionContext<P> context) {
            return this.writer.apply(value, context);
        }

        @Override
        public @Nullable SV writeNull(ValueConversionContext<P> context) {
            return this.writer.apply(null, context);
        }

        @Override
        public @Nullable DV read(@Nullable SV value, ValueConversionContext<P> context) {
            return this.reader.apply(value, context);
        }

        @Override
        public @Nullable DV readNull(ValueConversionContext<P> context) {
            return this.reader.apply(null, context);
        }
    }

    public static enum ObjectToObjectPropertyValueConverter implements PropertyValueConverter
    {
        INSTANCE;


        public @Nullable Object read(@Nullable Object value, ValueConversionContext context) {
            return value;
        }

        public @Nullable Object write(@Nullable Object value, ValueConversionContext context) {
            return value;
        }
    }
}

