/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import org.archive.extract.ResourceFactoryMapper;
import org.archive.format.warc.WARCConstants;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceFactory;
import org.archive.resource.arc.ARCResource;
import org.archive.resource.arc.record.FiledescResourceFactory;
import org.archive.resource.html.HTMLResourceFactory;
import org.archive.resource.http.HTTPHeadersResourceFactory;
import org.archive.resource.http.HTTPRequestResourceFactory;
import org.archive.resource.http.HTTPResponseResource;
import org.archive.resource.http.HTTPResponseResourceFactory;
import org.archive.resource.warc.WARCResource;
import org.archive.resource.warc.record.DNSResourceFactory;
import org.archive.resource.warc.record.WARCJSONMetaDataResourceFactory;
import org.archive.resource.warc.record.WARCMetaDataResourceFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class ExtractingResourceFactoryMapper
implements ResourceFactoryMapper {
    private static final Logger LOG = Logger.getLogger(ExtractingResourceFactoryMapper.class.getName());
    private HTTPResponseResourceFactory httpResponseF = new HTTPResponseResourceFactory();
    private HTTPRequestResourceFactory httpRequestF = new HTTPRequestResourceFactory();
    private HTMLResourceFactory htmlF = new HTMLResourceFactory();
    private HTTPHeadersResourceFactory warcinfoF = new HTTPHeadersResourceFactory("WARC-Info-Metadata", "application/warc-fields");
    private DNSResourceFactory dnsF = new DNSResourceFactory();
    private WARCMetaDataResourceFactory warcmetaF = new WARCMetaDataResourceFactory();
    private WARCJSONMetaDataResourceFactory warcjsonF = new WARCJSONMetaDataResourceFactory();
    private FiledescResourceFactory filedescF = new FiledescResourceFactory();

    private String getChildField(MetaData m, String child, String key) {
        try {
            JSONObject c;
            if (m.has(child) && (c = m.getJSONObject(child)).has(key)) {
                return c.getString(key);
            }
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return null;
    }

    private boolean childFieldStartsWith(MetaData m, String child, String key, String search) {
        String val = this.getChildField(m, child, key);
        return val == null ? false : val.toLowerCase(Locale.ROOT).startsWith(search.toLowerCase(Locale.ROOT));
    }

    private boolean childFieldContains(MetaData m, String child, String key, String search) {
        String val = this.getChildField(m, child, key);
        return val == null ? false : val.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
    }

    private boolean childFieldEquals(MetaData m, String child, String key, String search) {
        String val = this.getChildField(m, child, key);
        return val == null ? false : val.equals(search);
    }

    private String caseInsensitiveKeyScan(MetaData m, String child, String k) {
        try {
            if (m.has(child)) {
                String kLC = k.toLowerCase(Locale.ROOT);
                JSONObject childJSObj = m.getJSONObject(child);
                Iterator i = childJSObj.keys();
                while (i.hasNext()) {
                    String kString;
                    Object kObj = i.next();
                    if (!(kObj instanceof String) || !(kString = (String)kObj).toLowerCase(Locale.ROOT).equals(kLC)) continue;
                    return childJSObj.getString(kString);
                }
            }
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return null;
    }

    private boolean isFileDescARCResource(MetaData envelope) {
        return this.childFieldStartsWith(envelope, "ARC-Header-Metadata", "Target-URI", "filedesc:/");
    }

    private boolean isDNSARCResource(MetaData envelope) {
        return this.childFieldContains(envelope, "ARC-Header-Metadata", "Content-Type", "text/dns");
    }

    private boolean isDATARCResource(MetaData envelope) {
        return this.childFieldContains(envelope, "ARC-Header-Metadata", "Content-Type", "alexa/dat");
    }

    private boolean isHTTPARCResource(MetaData envelope) {
        return this.childFieldStartsWith(envelope, "ARC-Header-Metadata", "Target-URI", "http");
    }

    private boolean isHTMLHttpResource(MetaData m) {
        String type = this.caseInsensitiveKeyScan(m, "Headers", "Content-Type");
        return type == null ? false : type.toLowerCase(Locale.ROOT).contains("html");
    }

    private boolean isWARCType(MetaData envelope, WARCConstants.WARCRecordType type) {
        return this.childFieldEquals(envelope, "WARC-Header-Metadata", "WARC-Type", type.toString());
    }

    private boolean isWARCRevisitResource(MetaData envelope) {
        return this.isWARCType(envelope, WARCConstants.WARCRecordType.revisit);
    }

    private boolean isWARCResponseResource(MetaData envelope) {
        return this.isWARCType(envelope, WARCConstants.WARCRecordType.response);
    }

    private boolean isWARCRequestResource(MetaData envelope) {
        return this.isWARCType(envelope, WARCConstants.WARCRecordType.request);
    }

    private boolean isWARCMetaDataResource(MetaData envelope) {
        return this.isWARCType(envelope, WARCConstants.WARCRecordType.metadata);
    }

    private boolean isWARCInfoResource(MetaData envelope) {
        return this.isWARCType(envelope, WARCConstants.WARCRecordType.warcinfo);
    }

    private boolean isHTTPResponseWARCResource(MetaData envelope) {
        return this.childFieldEquals(envelope, "WARC-Header-Metadata", "Content-Type", "application/http; msgtype=response") || this.childFieldEquals(envelope, "WARC-Header-Metadata", "Content-Type", "application/http;msgtype=response");
    }

    private boolean isWARCJSONResource(MetaData envelope) {
        return this.childFieldEquals(envelope, "WARC-Header-Metadata", "Content-Type", "application/json");
    }

    private boolean isDNSResponseWARCResource(MetaData envelope) {
        return this.childFieldEquals(envelope, "WARC-Header-Metadata", "Content-Type", "text/dns");
    }

    @Override
    public ResourceFactory mapResourceToFactory(Resource resource) {
        if (resource instanceof WARCResource) {
            WARCResource wr = (WARCResource)resource;
            MetaData envelope = wr.getEnvelopeMetaData();
            if (this.isWARCMetaDataResource(envelope)) {
                if (this.isWARCJSONResource(envelope)) {
                    return this.warcjsonF;
                }
                return this.warcmetaF;
            }
            if (this.isWARCRequestResource(envelope)) {
                return this.httpRequestF;
            }
            if (this.isWARCInfoResource(envelope)) {
                return this.warcinfoF;
            }
            if (this.isWARCResponseResource(envelope)) {
                if (this.isHTTPResponseWARCResource(envelope)) {
                    return this.httpResponseF;
                }
                if (this.isDNSResponseWARCResource(envelope)) {
                    return this.dnsF;
                }
            } else if (this.isWARCRevisitResource(envelope)) {
                return this.httpResponseF;
            }
        } else if (resource instanceof ARCResource) {
            ARCResource ar = (ARCResource)resource;
            MetaData envelope = ar.getEnvelopeMetaData();
            if (this.isFileDescARCResource(envelope)) {
                return this.filedescF;
            }
            if (this.isDNSARCResource(envelope)) {
                return this.dnsF;
            }
            if (!this.isDATARCResource(envelope) && this.isHTTPARCResource(envelope)) {
                return this.httpResponseF;
            }
        } else if (resource instanceof HTTPResponseResource && this.isHTMLHttpResource(resource.getMetaData())) {
            return this.htmlF;
        }
        return null;
    }
}

