/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax.extension;

import crawlercommons.sitemaps.extension.PageMap;
import crawlercommons.sitemaps.extension.PageMapDataObject;
import crawlercommons.sitemaps.sax.extension.ExtensionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageMapsHandler
extends ExtensionHandler {
    private PageMap currPageMap;
    private PageMapDataObject currDataObj;
    private String currAttrName;
    private StringBuilder currAttrVal = new StringBuilder();
    private String currAttrValFromAttr;

    public PageMapsHandler() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
    }

    private void resetCurrent() {
        this.currDataObj = null;
        this.currAttrName = null;
        this.currAttrVal.setLength(0);
        this.currAttrValFromAttr = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "PageMap": {
                this.currPageMap = new PageMap();
                break;
            }
            case "DataObject": {
                this.currDataObj = new PageMapDataObject(attributes.getValue("type"), attributes.getValue("id"));
                if (this.currPageMap == null) break;
                this.currPageMap.addDataObject(this.currDataObj);
                break;
            }
            case "Attribute": {
                this.currAttrVal.setLength(0);
                this.currAttrName = attributes.getValue("name");
                if (attributes.getValue("value") == null) break;
                this.currAttrValFromAttr = attributes.getValue("value");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (localName) {
            case "PageMap": {
                this.attributes.add(this.currPageMap);
                break;
            }
            case "DataObject": {
                break;
            }
            case "Attribute": {
                String currAttrValStr = this.currAttrVal.toString().trim();
                if (this.currDataObj == null) break;
                if (currAttrValStr.isEmpty() && this.currAttrValFromAttr != null) {
                    this.currDataObj.addAttribute(this.currAttrName, this.currAttrValFromAttr);
                    break;
                }
                this.currDataObj.addAttribute(this.currAttrName, currAttrValStr);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currAttrVal.append(String.valueOf(ch, start, length));
    }
}

