/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v122.css.model.CSSStyle;
import org.openqa.selenium.devtools.v122.css.model.RuleMatch;
import org.openqa.selenium.json.JsonInput;

public class InheritedStyleEntry {
    private final Optional<CSSStyle> inlineStyle;
    private final List<RuleMatch> matchedCSSRules;

    public InheritedStyleEntry(Optional<CSSStyle> inlineStyle, List<RuleMatch> matchedCSSRules) {
        this.inlineStyle = inlineStyle;
        this.matchedCSSRules = Objects.requireNonNull(matchedCSSRules, "matchedCSSRules is required");
    }

    public Optional<CSSStyle> getInlineStyle() {
        return this.inlineStyle;
    }

    public List<RuleMatch> getMatchedCSSRules() {
        return this.matchedCSSRules;
    }

    private static InheritedStyleEntry fromJson(JsonInput input) {
        Optional<CSSStyle> inlineStyle = Optional.empty();
        List matchedCSSRules = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "inlineStyle": {
                    inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                    continue block8;
                }
                case "matchedCSSRules": {
                    matchedCSSRules = input.readArray(RuleMatch.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InheritedStyleEntry(inlineStyle, matchedCSSRules);
    }
}

