/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.format.gzip.zipnum.LineBufferingIterator;
import org.archive.format.gzip.zipnum.SummaryLine;
import org.archive.format.gzip.zipnum.ZipNumIndex;
import org.archive.format.gzip.zipnum.ZipNumParams;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderIterator;
import org.archive.util.io.RuntimeIOException;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIterator;

public class SummaryBlockIterator
extends AbstractPeekableIterator<CloseableIterator<String>> {
    static final Logger LOGGER = Logger.getLogger(SummaryBlockIterator.class.getName());
    protected CloseableIterator<String> summaryIterator;
    protected ZipNumIndex zipnumIndex;
    protected SummaryLine nextLine;
    protected SummaryLine currLine;
    protected boolean isFirst = true;
    protected int totalBlocks = 0;
    protected final ZipNumParams params;

    public SummaryBlockIterator(CloseableIterator<String> summaryIterator, ZipNumIndex zipnumIndex, ZipNumParams params) {
        this.zipnumIndex = zipnumIndex;
        this.summaryIterator = summaryIterator;
        this.isFirst = true;
        this.params = params != null ? params : new ZipNumParams();
    }

    @Override
    public CloseableIterator<String> getNextInner() {
        SeekableLineReader currReader;
        if (this.isFirst) {
            if (this.summaryIterator.hasNext()) {
                this.nextLine = new SummaryLine((String)this.summaryIterator.next());
            }
            this.isFirst = false;
        }
        if (this.nextLine == null) {
            return null;
        }
        if (this.params.getMaxBlocks() > 0 && this.totalBlocks >= this.params.getMaxBlocks()) {
            return null;
        }
        int numBlocks = 0;
        int maxAggregateBlocks = this.params.getMaxAggregateBlocks();
        long startOffset = this.nextLine.offset;
        String currPartId = this.nextLine.partId;
        int totalLength = 0;
        do {
            this.currLine = this.nextLine;
            if (this.currLine == null) {
                return null;
            }
            this.nextLine = this.summaryIterator.hasNext() ? new SummaryLine((String)this.summaryIterator.next()) : null;
            if (this.currLine.getNumFields() < 3) {
                LOGGER.severe("Bad line(" + this.currLine.toString() + ") ");
                return null;
            }
            totalLength += this.currLine.length;
            ++numBlocks;
        } while (!(maxAggregateBlocks > 0 && numBlocks >= maxAggregateBlocks || this.params.getMaxBlocks() > 0 && this.totalBlocks + numBlocks >= this.params.getMaxBlocks()) && this.currLine.isContinuous(this.nextLine));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Loading " + numBlocks + " blocks - " + startOffset + ":" + totalLength + " from " + currPartId);
        }
        if ((currReader = this.zipnumIndex.doBlockLoad(currPartId, startOffset, totalLength)) == null && this.zipnumIndex.isRequired()) {
            throw new RuntimeIOException("Failed to load shards for: " + currPartId);
        }
        if (currReader != null) {
            this.totalBlocks += numBlocks;
        }
        CloseableIterator<String> slrIter = new SeekableLineReaderIterator(currReader, this.zipnumIndex.isRequired());
        if (this.params.isReverse()) {
            slrIter = new LineBufferingIterator(slrIter, this.zipnumIndex.getCdxLinesPerBlock(), true);
        }
        return slrIter;
    }

    @Override
    public void close() throws IOException {
        if (this.summaryIterator != null) {
            this.summaryIterator.close();
            this.summaryIterator = null;
        }
    }
}

