/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005t!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\u0002C2\u0002\u0005\u0004%\tA\u00153\t\r5\f\u0001\u0015!\u0003f\u0011\u0015q\u0017\u0001\"\u0001p\u0011\u001d\t)!\u0001C\u0005\u0003\u000fAq!!\u0007\u0002\t\u0013\tY\u0002\u0003\u0005\u0002 \u0005!\tAUA\u0011\u0011!\ty'\u0001C\u0001%\u0006EdACAe\u0003A\u0005\u0019\u0013\u0001+\u0002L\"9\u0011q\u001a\u0006\u0007\u0002\u0005EgA\u0002B\u000b\u0003\u0011\u00119\u0002\u0003\u0006\u0003&1\u0011\t\u0011)A\u0005\u0005OA!Ba\r\r\u0005\u0003\u0005\u000b\u0011\u0002B\u001b\u0011\u0019\tG\u0002\"\u0001\u00038!9\u0011q\u001a\u0007\u0005B\t}\u0002b\u0002B%\u0003\u0011%!1\n\u0005\b\u0005o\nA\u0011\u0002B=\r\u0019\t\t)\u0001\u0001\u0002\u0004\"1\u0011m\u0005C\u0001\u0003\u000bC\u0011\"a\"\u0014\u0005\u0004%\t!!#\t\u0011\u0005M5\u0003)A\u0005\u0003\u0017C\u0011\"!&\u0014\u0005\u0004%\t!!#\t\u0011\u0005]5\u0003)A\u0005\u0003\u0017C\u0011\"!'\u0014\u0005\u0004%\t!!#\t\u0011\u0005m5\u0003)A\u0005\u0003\u0017Cq!!(\u0014\t\u0003\ty\nC\u0004\u0002,N!\t!!,\t\u000f\u0005]6\u0003\"\u0001\u0002:\"9\u0011QY\n\u0005\u0002\u0005\u001dgA\u0002BI\u0003\u0011\u0011\u0019\n\u0003\u0004b?\u0011\u0005!q\u0013\u0005\b\u0003\u001f|B\u0011\tBN\r\u0019\u0011\u0019+\u0001\u0003\u0003&\"1\u0011M\tC\u0001\u0005OCq!a4#\t\u0003\u0012YK\u0002\u0004\u00030\u0006!!\u0011\u0017\u0005\u0007C\u0016\"\tAa-\t\u0013\t]VE1A\u0005\u0002\te\u0006\u0002\u0003BdK\u0001\u0006IAa/\t\u000f\u0005=W\u0005\"\u0011\u0003J\u001a1!QZ\u0001\u0005\u0005\u001fD\u0001\u0002\u001e\u0016\u0003\u0002\u0003\u0006I!\u001e\u0005\u0007C*\"\tA!9\t\u0013\t\u001d(F1A\u0005\u0002\t%\b\u0002\u0003B|U\u0001\u0006IAa;\t\u0013\te(F1A\u0005\u0002\t%\b\u0002\u0003B~U\u0001\u0006IAa;\t\u0013\tu(F1A\u0005\u0002\t%\b\u0002\u0003B\u0000U\u0001\u0006IAa;\t\u0013\r\u0005!F1A\u0005\u0002\r\r\u0001\u0002CB\u0006U\u0001\u0006Ia!\u0002\t\u0013\r5!F1A\u0005\u0002\r=\u0001\u0002CB\rU\u0001\u0006Ia!\u0005\t\u0013\rm!F1A\u0005\u0002\r=\u0001\u0002CB\u000fU\u0001\u0006Ia!\u0005\t\u0013\r}!F1A\u0005\u0002\t%\b\u0002CB\u0011U\u0001\u0006IAa;\t\u0013\r\r\"F1A\u0005\u0002\r\u0015\u0002\u0002CB\u0015U\u0001\u0006Iaa\n\t\u0013\r-\"F1A\u0005\u0002\r\u0015\u0002\u0002CB\u0017U\u0001\u0006Iaa\n\t\u0013\r=\"F1A\u0005\u0002\t%\b\u0002CB\u0019U\u0001\u0006IAa;\t\u0013\rM\"F1A\u0005\u0002\t%\b\u0002CB\u001bU\u0001\u0006IAa;\t\u0013\r]\"F1A\u0005\u0002\t%\b\u0002CB\u001dU\u0001\u0006IAa;\t\u0013\rm\"F1A\u0005\u0002\t%\b\u0002CB\u001fU\u0001\u0006IAa;\t\u000f\r}\"\u0006\"\u0001\u0004B!Q11\u000b\u0016\t\u0006\u0004%\ta!\u0016\t\u0015\tE$\u0006#b\u0001\n\u0003\u0019)\u0006\u0003\u0006\u0003Z)B)\u0019!C\u0001\u0007+B!\"!\r+\u0011\u000b\u0007I\u0011AB+\u0011)\t9C\u000bEC\u0002\u0013\u00051Q\u000b\u0005\u000b\u0007/R\u0003R1A\u0005\u0002\re\u0003BCA4U!\u0015\r\u0011\"\u0001\u0004^!Q!Q\u000f\u0016\t\u0006\u0004%\ta!\u0018\t\u000f\r}#\u0006\"\u0001\u0002H\u0006yA)^7q\u0019><7+Z4nK:$8O\u0003\u0002T)\u0006)Ao\\8mg*\tQ+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005a\u000bQ\"\u0001*\u0003\u001f\u0011+X\u000e\u001d'pON+w-\\3oiN\u001c\"!A.\u0011\u0005q{V\"A/\u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq+\u0001\u0007SK\u000e|'\u000fZ%oI\u0016tG/F\u0001f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0003mC:<'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u0014aa\u0015;sS:<\u0017!\u0004*fG>\u0014H-\u00138eK:$\b%\u0001\u0003nC&tGC\u00019t!\ta\u0016/\u0003\u0002s;\n!QK\\5u\u0011\u0015!X\u00011\u0001v\u0003\u0011\t'oZ:\u0011\u0007q3\b0\u0003\u0002x;\n)\u0011I\u001d:bsB\u0019\u00110!\u0001\u000f\u0005it\bCA>^\u001b\u0005a(BA?W\u0003\u0019a$o\\8u}%\u0011q0X\u0001\u0007!J,G-\u001a4\n\u00071\f\u0019A\u0003\u0002\u0000;\u0006aA-^7q)bt\u0017J\u001c3fqR\u0019\u0001/!\u0003\t\u000f\u0005-a\u00011\u0001\u0002\u000e\u0005!a-\u001b7f!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nS\u0006\u0011\u0011n\\\u0005\u0005\u0003/\t\tB\u0001\u0003GS2,\u0017A\u00063v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ*oCB\u001c\bn\u001c;\u0015\u0007A\fi\u0002C\u0004\u0002\f\u001d\u0001\r!!\u0004\u0002\u0013\u0011,X\u000e]%oI\u0016DHc\u00039\u0002$\u0005\u0015\u0012qFA\u001a\u0003KBq!a\u0003\t\u0001\u0004\ti\u0001C\u0004\u0002(!\u0001\r!!\u000b\u0002\u001f%tG-\u001a=TC:LG/_(oYf\u00042\u0001XA\u0016\u0013\r\ti#\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0004\u0003a\u0001\u0003S\t!B^3sS\u001aLxJ\u001c7z\u0011\u001d\t)\u0004\u0003a\u0001\u0003o\t!$\\5t\u001b\u0006$8\r[3t\r>\u0014\u0018J\u001c3fq\u001aKG.Z:NCB\u0004r!!\u000f\u0002Da\f9%\u0004\u0002\u0002<)!\u0011QHA \u0003\u001diW\u000f^1cY\u0016T1!!\u0011^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\nYDA\u0002NCB\u0004b!!\u0013\u0002T\u0005ec\u0002BA&\u0003\u001fr1a_A'\u0013\u0005q\u0016bAA);\u00069\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u0012A\u0001T5ti*\u0019\u0011\u0011K/\u0011\u000fq\u000bY&a\u0018\u0002`%\u0019\u0011QL/\u0003\rQ+\b\u000f\\33!\ra\u0016\u0011M\u0005\u0004\u0003Gj&\u0001\u0002'p]\u001eDq!a\u001a\t\u0001\u0004\tI'\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\u0011\u0007q\u000bY'C\u0002\u0002nu\u00131!\u00138u\u00035!W/\u001c9US6,\u0017J\u001c3fqRI\u0001/a\u001d\u0002v\u0005]\u0014\u0011\u0010\u0005\b\u0003\u0017I\u0001\u0019AA\u0007\u0011\u001d\t9#\u0003a\u0001\u0003SAq!!\r\n\u0001\u0004\tI\u0003C\u0004\u0002|%\u0001\r!! \u0002'QLW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0011\u0007\u0005}4#D\u0001\u0002\u0005M!\u0016.\\3J]\u0012,\u0007\u0010R;na\u0016\u0013(o\u001c:t'\t\u00192\f\u0006\u0002\u0002~\u0005qR.[:NCR\u001c\u0007.Z:G_J$\u0016.\\3J]\u0012,\u0007PR5mKNl\u0015\r]\u000b\u0003\u0003\u0017\u0003r!!\u000f\u0002Da\fi\t\u0005\u0004\u0002:\u0005=\u0015\u0011L\u0005\u0005\u0003#\u000bYDA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018aH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1qA\u0005\u0019r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0006!r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0002\nQc\u001d5bY2|wo\u00144gg\u0016$hj\u001c;G_VtG-\u0001\ftQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3!\u0003]\u0011XmY8sI6K7/\\1uG\"$\u0016.\\3J]\u0012,\u0007\u0010F\u0004q\u0003C\u000b\u0019+a*\t\u000f\u0005-1\u00041\u0001\u0002\u000e!9\u0011QU\u000eA\u0002\u0005}\u0013AD5oI\u0016DH+[7fgR\fW\u000e\u001d\u0005\b\u0003S[\u0002\u0019AA0\u00031awn\u001a+j[\u0016\u001cH/Y7q\u0003y\u0011XmY8sI>+Ho\u00144Pe\u0012,'/\u00138eKb$\u0016.\\3ti\u0006l\u0007\u000fF\u0004q\u0003_\u000b\t,a-\t\u000f\u0005-A\u00041\u0001\u0002\u000e!9\u0011Q\u0015\u000fA\u0002\u0005}\u0003bBA[9\u0001\u0007\u0011qL\u0001\u0013aJ,g/\u00138eKb$\u0016.\\3ti\u0006l\u0007/A\u000esK\u000e|'\u000fZ*iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u000b\ba\u0006m\u0016QXAa\u0011\u001d\tY!\ba\u0001\u0003\u001bAq!a0\u001e\u0001\u0004\ty&A\u0006j]\u0012,\u0007p\u00144gg\u0016$\bbBAb;\u0001\u0007\u0011qL\u0001\nY><wJ\u001a4tKR\f1\u0002\u001d:j]R,%O]8sgR\t\u0001OA\u0007NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u0003\u001b\fy.!>\u0014\u0005)Y\u0016!\u00029beN,G\u0003BAj\u0003s\u0004r\u0001XA.\u0003+\f\t\u0010E\u0003]\u0003/\fY.C\u0002\u0002Zv\u0013aa\u00149uS>t\u0007\u0003BAo\u0003?d\u0001\u0001B\u0004\u0002b*\u0011\r!a9\u0003\u0003-\u000bB!!:\u0002lB\u0019A,a:\n\u0007\u0005%XLA\u0004O_RD\u0017N\\4\u0011\u0007q\u000bi/C\u0002\u0002pv\u00131!\u00118z!\u0015a\u0016q[Az!\u0011\ti.!>\u0005\u000f\u0005](B1\u0001\u0002d\n\ta\u000bC\u0004\u0002|.\u0001\r!!@\u0002\rI,7m\u001c:e!\u0011\tyP!\u0005\u000e\u0005\t\u0005!\u0002BA~\u0005\u0007QAA!\u0002\u0003\b\u000511m\\7n_:T1!\u0016B\u0005\u0015\u0011\u0011YA!\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011y!A\u0002pe\u001eLAAa\u0005\u0003\u0002\t1!+Z2pe\u0012\u0014A\u0003R3d_\u0012,'/T3tg\u0006<W\rU1sg\u0016\u0014XC\u0002B\r\u0005?\u0011\u0019c\u0005\u0003\r7\nm\u0001cBA@\u0015\tu!\u0011\u0005\t\u0005\u0003;\u0014y\u0002B\u0004\u0002b2\u0011\r!a9\u0011\t\u0005u'1\u0005\u0003\b\u0003od!\u0019AAr\u0003)YW-\u001f#fG>$WM\u001d\t\u0007\u0005S\u0011yC!\b\u000e\u0005\t-\"b\u0001B\u0017)\u0006Q1/\u001a:jC2L'0\u001a:\n\t\tE\"1\u0006\u0002\b\t\u0016\u001cw\u000eZ3s\u000311\u0018\r\\;f\t\u0016\u001cw\u000eZ3s!\u0019\u0011ICa\f\u0003\"Q1!\u0011\bB\u001e\u0005{\u0001r!a \r\u0005;\u0011\t\u0003C\u0004\u0003&=\u0001\rAa\n\t\u000f\tMr\u00021\u0001\u00036Q!!\u0011\tB$!\u001da\u00161\fB\"\u0005\u000b\u0002R\u0001XAl\u0005;\u0001R\u0001XAl\u0005CAq!a?\u0011\u0001\u0004\ti0A\u0004ek6\u0004Hj\\4\u0015\u001fA\u0014iEa\u0014\u0003T\t]#1\fB8\u0005gBq!a\u0003\u0012\u0001\u0004\ti\u0001C\u0004\u0003RE\u0001\r!!\u000b\u0002\u001bA\u0014\u0018N\u001c;D_:$XM\u001c;t\u0011\u001d\u0011)&\u0005a\u0001\u0003o\t\u0011E\\8o\u0007>t7/Z2vi&4X\rU1jeN4uN\u001d'pO\u001aKG.Z:NCBDqA!\u0017\u0012\u0001\u0004\tI#A\bjg\u0012+W\r]%uKJ\fG/[8o\u0011\u001d\u0011i&\u0005a\u0001\u0005?\na\u0001]1sg\u0016\u0014\bG\u0002B1\u0005K\u0012Y\u0007E\u0004\u0002\u0000)\u0011\u0019G!\u001b\u0011\t\u0005u'Q\r\u0003\r\u0005O\u0012Y&!A\u0001\u0002\u000b\u0005\u00111\u001d\u0002\u0004?\u0012\n\u0004\u0003BAo\u0005W\"AB!\u001c\u0003\\\u0005\u0005\t\u0011!B\u0001\u0003G\u00141a\u0018\u00133\u0011\u001d\u0011\t(\u0005a\u0001\u0003S\t!c]6jaJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC\"9!QO\tA\u0002\u0005%\u0014\u0001C7bq\nKH/Z:\u0002\u001fA\u0014\u0018N\u001c;CCR\u001c\u0007\u000eT3wK2$R\u0001\u001dB>\u0005\u001bCqA! \u0013\u0001\u0004\u0011y(A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0003\u0002\n\u001de\u0002BA\u0000\u0005\u0007KAA!\"\u0003\u0002\u0005\u0011b)\u001b7f\u0019><\u0017J\u001c9viN#(/Z1n\u0013\u0011\u0011IIa#\u0003-\u0019KG.Z\"iC:tW\r\u001c*fG>\u0014HMQ1uG\"TAA!\"\u0003\u0002!9!q\u0012\nA\u0002\u0005}\u0013!E1dGVlW\u000f\\1uSZ,')\u001f;fg\n!rJ\u001a4tKR\u001cX*Z:tC\u001e,\u0007+\u0019:tKJ\u001cBaH.\u0003\u0016B)\u0011q\u0010\u0006yqR\u0011!\u0011\u0014\t\u0004\u0003\u007fzB\u0003\u0002BO\u0005C\u0003r\u0001XA.\u0005?\u0013y\n\u0005\u0003]\u0003/D\bbBA~C\u0001\u0007\u0011Q \u0002\u001c)J\fgn]1di&|g\u000eT8h\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0014\t\tZ&Q\u0013\u000b\u0003\u0005S\u00032!a #)\u0011\u0011iJ!,\t\u000f\u0005mH\u00051\u0001\u0002~\ny2\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\rT8h\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0014\t\u0015Z&Q\u0013\u000b\u0003\u0005k\u00032!a &\u0003MiW\r^1eCR\f'+Z2pe\u0012\u001cVM\u001d3f+\t\u0011Y\f\u0005\u0003\u0003>\n\rWB\u0001B`\u0015\u0011\u0011\tMa\u0002\u0002\u00115,G/\u00193bi\u0006LAA!2\u0003@\n\u0019R*\u001a;bI\u0006$\u0018MU3d_J$7+\u001a:eK\u0006!R.\u001a;bI\u0006$\u0018MU3d_J$7+\u001a:eK\u0002\"BA!(\u0003L\"9\u00111`\u0015A\u0002\u0005u(A\u0006#v[BdunZ*fO6,g\u000e^:PaRLwN\\:\u0014\u0007)\u0012\t\u000e\u0005\u0003\u0003T\nuWB\u0001Bk\u0015\u0011\u00119N!7\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u00057\u00149!\u0001\u0004tKJ4XM]\u0005\u0005\u0005?\u0014)NA\u000bD_6l\u0017M\u001c3EK\u001a\fW\u000f\u001c;PaRLwN\\:\u0015\t\t\r(Q\u001d\t\u0004\u0003\u007fR\u0003\"\u0002;-\u0001\u0004)\u0018\u0001\u00039sS:$x\n\u001d;\u0016\u0005\t-\b\u0003\u0002Bw\u0005gl!Aa<\u000b\u0005\tE\u0018A\u00036paR\u001c\u0018.\u001c9mK&!!Q\u001fBx\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\naJLg\u000e^(qi\u0002\n\u0011B^3sS\u001aLx\n\u001d;\u0002\u0015Y,'/\u001b4z\u001fB$\b%\u0001\bj]\u0012,\u0007pU1oSRLx\n\u001d;\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002\n\u0001BZ5mKN|\u0005\u000f^\u000b\u0003\u0007\u000b\u0001RA!<\u0004\baLAa!\u0003\u0003p\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011BZ5mKN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004\u0012A1!Q^B\u0004\u0007'\u00012AZB\u000b\u0013\r\u00199b\u001a\u0002\b\u0013:$XmZ3s\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\u0002\u00175\f\u0007PQ=uKN|\u0005\u000f^\u0001\r[\u0006D()\u001f;fg>\u0003H\u000fI\u0001\u0011I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\f\u0011\u0003Z3fa&#XM]1uS>tw\n\u001d;!\u0003=1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$XCAB\u0014!\u0015\u0011ioa\u0002f\u0003A1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$\b%A\u0007lKf$UmY8eKJ|\u0005\u000f^\u0001\u000fW\u0016LH)Z2pI\u0016\u0014x\n\u001d;!\u0003)ygMZ:fiN|\u0005\u000f^\u0001\f_\u001a47/\u001a;t\u001fB$\b%A\tue\u0006t7/Y2uS>tGj\\4PaR\f!\u0003\u001e:b]N\f7\r^5p]2{wm\u00149uA\u0005\u00112\r\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00149u\u0003M\u0019G.^:uKJlU\r^1eCR\fw\n\u001d;!\u0003U\u00198.\u001b9SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PaR\fac]6jaJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fI\u0001\u000e[\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\u0005\r\r\u0003GBB#\u0007\u0013\u001ay\u0005E\u0004\u0002\u0000)\u00199e!\u0014\u0011\t\u0005u7\u0011\n\u0003\f\u0007\u0017:\u0015\u0011!A\u0001\u0006\u0003\t\u0019OA\u0002`IM\u0002B!!8\u0004P\u0011Y1\u0011K$\u0002\u0002\u0003\u0005)\u0011AAr\u0005\ryF\u0005N\u0001\u0013g\"|W\u000f\u001c3Qe&tG\u000fR1uC2{w-\u0006\u0002\u0002*\u0005)a-\u001b7fgV\u001111\f\t\u00049Z,WCAA5\u0003%\u0019\u0007.Z2l\u0003J<7\u000f")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private final OptionSpecBuilder printOpt;
        private final OptionSpecBuilder verifyOpt;
        private final OptionSpecBuilder indexSanityOpt;
        private final ArgumentAcceptingOptionSpec<String> filesOpt;
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt;
        private final ArgumentAcceptingOptionSpec<Integer> maxBytesOpt;
        private final OptionSpecBuilder deepIterationOpt;
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt;
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt;
        private final OptionSpecBuilder offsetsOpt;
        private final OptionSpecBuilder transactionLogOpt;
        private final OptionSpecBuilder clusterMetadataOpt;
        private final OptionSpecBuilder skipRecordMetadataOpt;
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options.has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options.has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options.valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options.valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options.has((OptionSpec)this.printOpt()) || this.options.has((OptionSpec)this.offsetsOpt()) || this.options.has((OptionSpec)this.transactionLogOpt()) || this.options.has((OptionSpec)this.clusterMetadataOpt()) || this.options.has(this.valueDecoderOpt()) || this.options.has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options.has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options.has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options.has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options.has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options.valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options.valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options.valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.filesOpt()});
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args);
            this.printOpt = this.parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
            this.verifyOpt = this.parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
            this.indexSanityOpt = this.parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
            this.filesOpt = this.parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
            this.maxMessageSizeOpt = this.parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
            this.maxBytesOpt = this.parser.accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            this.deepIterationOpt = this.parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
            this.valueDecoderOpt = this.parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
            this.keyDecoderOpt = this.parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
            this.offsetsOpt = this.parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
            this.transactionLogOpt = this.parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
            this.clusterMetadataOpt = this.parser.accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
            this.skipRecordMetadataOpt = this.parser.accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
            this.options = this.parser.parse(args);
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

