/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.util.concurrent.TimeUnit;
import kafka.utils.Logging;
import kafka.utils.Throttler$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0012%\u0001%B\u0001\u0002\u000e\u0001\u0003\u0002\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0019!C\u0001u!A\u0001\t\u0001B\u0001B\u0003&a\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011e\u0003!\u0011!Q\u0001\n9C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0006O\u0002!\t\u0001\u001b\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019Q\b\u0001)A\u0005e\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0006\u0001\u0001\u0006I! \u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\n\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003WAq!!\f\u0001A\u0003%a\tC\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u0002,!I\u0011\u0011\u0007\u0001A\u0002\u0013%\u00111\u0007\u0005\b\u0003o\u0001\u0001\u0015)\u0003G\u0011!\tI\u0004\u0001a\u0001\n\u0013)\u0004\"CA\u001e\u0001\u0001\u0007I\u0011BA\u001f\u0011\u001d\t\t\u0005\u0001Q!\nYBq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002L\u0001!\t!!\u0014\b\u000f\u0005mC\u0005#\u0001\u0002^\u001911\u0005\nE\u0001\u0003?BaaZ\u000e\u0005\u0002\u0005\u0005\u0004bBA27\u0011\u0005\u0011Q\r\u0005\n\u0003cZ\u0012\u0013!C\u0001\u0003gB\u0011\"!#\u001c#\u0003%\t!a#\t\u0013\u0005=5$%A\u0005\u0002\u0005E\u0005\"CAK7E\u0005I\u0011AAI\u0011%\t9jGI\u0001\n\u0003\tIJA\u0005UQJ|G\u000f\u001e7fe*\u0011QEJ\u0001\u0006kRLGn\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001a\u000e\u0003\u0011J!a\r\u0013\u0003\u000f1{wmZ5oO\u0006\tB-Z:je\u0016$'+\u0019;f!\u0016\u00148+Z2\u0016\u0003Y\u0002\"aK\u001c\n\u0005ab#A\u0002#pk\ndW-A\u000beKNL'/\u001a3SCR,\u0007+\u001a:TK\u000e|F%Z9\u0015\u0005mr\u0004CA\u0016=\u0013\tiDF\u0001\u0003V]&$\bbB \u0003\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0014A\u00053fg&\u0014X\r\u001a*bi\u0016\u0004VM]*fG\u0002B#a\u0001\"\u0011\u0005-\u001a\u0015B\u0001#-\u0005!1x\u000e\\1uS2,\u0017aD2iK\u000e\\\u0017J\u001c;feZ\fG.T:\u0011\u0005-:\u0015B\u0001%-\u0005\u0011auN\\4\u0002\u0019QD'o\u001c;uY\u0016$un\u001e8\u0011\u0005-Z\u0015B\u0001'-\u0005\u001d\u0011un\u001c7fC:\f!\"\\3ue&\u001cg*Y7f!\tyeK\u0004\u0002Q)B\u0011\u0011\u000bL\u0007\u0002%*\u00111\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0005Uc\u0013A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016\u0017\u0002\u000bUt\u0017\u000e^:\u0002\tQLW.\u001a\t\u00039\u0016l\u0011!\u0018\u0006\u0003KyS!a\u00181\u0002\r\r|W.\\8o\u0015\t9\u0013M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u001dI'n\u001b7n]>\u0004\"!\r\u0001\t\u000bQJ\u0001\u0019\u0001\u001c\t\u000f\u0015K\u0001\u0013!a\u0001\r\"9\u0011*\u0003I\u0001\u0002\u0004Q\u0005bB'\n!\u0003\u0005\rA\u0014\u0005\b3&\u0001\n\u00111\u0001O\u0011\u001dQ\u0016\u0002%AA\u0002m\u000bA\"\\3ue&\u001c7o\u0012:pkB,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fq!\\3ue&\u001c7O\u0003\u0002xA\u000611/\u001a:wKJL!!\u001f;\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0005Y>\u001c7.F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0019y%M[3di\u0006)An\\2lA\u0005)Q.\u001a;feV\u0011\u0011\u0011\u0003\t\u0005\u0003'\t\u0019#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011\u0019wN]3\u000b\u0007U\fYB\u0003\u0003\u0002\u001e\u0005}\u0011AB=b[6,'O\u0003\u0002\u0002\"\u0005\u00191m\\7\n\t\u0005\u0015\u0012Q\u0003\u0002\u0006\u001b\u0016$XM]\u0001\u0007[\u0016$XM\u001d\u0011\u0002\u001f\rDWmY6J]R,'O^1m\u001dN,\u0012AR\u0001\u0011G\",7m[%oi\u0016\u0014h/\u00197Og\u0002\nQ\u0002]3sS>$7\u000b^1si:\u001b\u0018!\u00059fe&|Gm\u0015;beRt5o\u0018\u0013fcR\u00191(!\u000e\t\u000f}\u001a\u0012\u0011!a\u0001\r\u0006q\u0001/\u001a:j_\u0012\u001cF/\u0019:u\u001dN\u0004\u0013!D8cg\u0016\u0014h/\u001a3T_\u001a\u000b'/A\tpEN,'O^3e'>4\u0015M]0%KF$2aOA \u0011\u001dyd#!AA\u0002Y\nab\u001c2tKJ4X\rZ*p\r\u0006\u0014\b%A\u0007nCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0004w\u0005\u001d\u0003BBA%1\u0001\u0007a'\u0001\u0005pEN,'O^3e\u0003])\b\u000fZ1uK\u0012+7/\u001b:fIJ\u000bG/\u001a)feN+7\rF\u0002<\u0003\u001fBa!!\u0015\u001a\u0001\u00041\u0014\u0001G;qI\u0006$X\r\u001a#fg&\u0014X\r\u001a*bi\u0016\u0004VM]*fG\"\u001a\u0001!!\u0016\u0011\u0007E\n9&C\u0002\u0002Z\u0011\u0012!\u0002\u001e5sK\u0006$7/\u00194f\u0003%!\u0006N]8ui2,'\u000f\u0005\u000227M\u00111D\u000b\u000b\u0003\u0003;\nA!\\1j]R\u00191(a\u001a\t\u000f\u0005%T\u00041\u0001\u0002l\u0005!\u0011M]4t!\u0011Y\u0013Q\u000e(\n\u0007\u0005=DFA\u0003BeJ\f\u00170A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003kR3ARA<W\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u0013Ut7\r[3dW\u0016$'bAABY\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u000e*\u001a!*a\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019JK\u0002O\u0003o\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u001c*\u001a1,a\u001e")
public class Throttler
implements Logging {
    private volatile double desiredRatePerSec;
    private final boolean throttleDown;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final Object lock;
    private final Meter meter;
    private final long checkIntervalNs;
    private long periodStartNs;
    private double observedSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return Throttler$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return Throttler$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return Throttler$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return Throttler$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return Throttler$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] stringArray) {
        Throttler$.MODULE$.main(stringArray);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public double desiredRatePerSec() {
        return this.desiredRatePerSec;
    }

    public void desiredRatePerSec_$eq(double x$1) {
        this.desiredRatePerSec = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Object lock() {
        return this.lock;
    }

    private Meter meter() {
        return this.meter;
    }

    private long checkIntervalNs() {
        return this.checkIntervalNs;
    }

    private long periodStartNs() {
        return this.periodStartNs;
    }

    private void periodStartNs_$eq(long x$1) {
        this.periodStartNs = x$1;
    }

    private double observedSoFar() {
        return this.observedSoFar;
    }

    private void observedSoFar_$eq(double x$1) {
        this.observedSoFar = x$1;
    }

    public void maybeThrottle(double observed) {
        long msPerSec = TimeUnit.SECONDS.toMillis(1L);
        long nsPerSec = TimeUnit.SECONDS.toNanos(1L);
        double currentDesiredRatePerSec = this.desiredRatePerSec();
        this.meter().mark((long)observed);
        Object object = this.lock();
        synchronized (object) {
            this.observedSoFar_$eq(this.observedSoFar() + observed);
            long elapsedNs = this.time.nanoseconds() - this.periodStartNs();
            if (elapsedNs > this.checkIntervalNs() && this.observedSoFar() > 0.0) {
                double rateInSecs = this.observedSoFar() * (double)nsPerSec / (double)elapsedNs;
                if (!(this.throttleDown ^ rateInSecs > currentDesiredRatePerSec)) {
                    double desiredRateMs = currentDesiredRatePerSec / (double)msPerSec;
                    long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsedNs);
                    long sleepTime = package$.MODULE$.round(this.observedSoFar() / desiredRateMs - (double)elapsedMs);
                    if (sleepTime > 0L) {
                        this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Natural rate is %f per second but desired rate is %f, sleeping for %d ms to compensate.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rateInSecs), BoxesRunTime.boxToDouble((double)currentDesiredRatePerSec), BoxesRunTime.boxToLong((long)sleepTime)})));
                        this.time.sleep(sleepTime);
                    }
                }
                this.periodStartNs_$eq(this.time.nanoseconds());
                this.observedSoFar_$eq(0.0);
            }
            return;
        }
    }

    public void updateDesiredRatePerSec(double updatedDesiredRatePerSec) {
        this.desiredRatePerSec_$eq(updatedDesiredRatePerSec);
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, String metricName, String units, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.throttleDown = throttleDown;
        this.time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.lock = new Object();
        this.meter = this.metricsGroup().newMeter(metricName, units, TimeUnit.SECONDS);
        this.checkIntervalNs = TimeUnit.MILLISECONDS.toNanos(checkIntervalMs);
        this.periodStartNs = time.nanoseconds();
        this.observedSoFar = 0.0;
    }
}

