/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.filters.basic;

import crawlercommons.filters.URLFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicURLNormalizer
extends URLFilter {
    public static final Logger LOG;
    private static final Pattern hasNormalizablePathPattern;
    private static final Pattern unescapeRulePattern;
    private static final Pattern hasSchemePattern;
    private static final boolean[] unescapedCharacters;
    private static final boolean[] escapedCharacters;
    private final Set<String> queryParamsToRemove;
    private final IdnNormalization idnNormalization;

    private static boolean isAlphaNumeric(int c) {
        return 65 <= c && c <= 90 || 97 <= c && c <= 122 || 48 <= c && c <= 57;
    }

    private static boolean isHexCharacter(int c) {
        return 65 <= c && c <= 70 || 97 <= c && c <= 102 || 48 <= c && c <= 57;
    }

    private static boolean isAscii(String str) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public BasicURLNormalizer() {
        this(new Builder());
    }

    public BasicURLNormalizer(Builder builder) {
        this.queryParamsToRemove = builder.queryParamsToRemove;
        this.idnNormalization = builder.idnNormalization;
    }

    @Override
    public String filter(String urlString) {
        String tempUrl;
        String file2;
        URL url;
        if ("".equals(urlString)) {
            return urlString;
        }
        urlString = urlString.trim();
        int fragmentPos = urlString.indexOf(35);
        if (urlString.indexOf(35) >= 0) {
            urlString = urlString.substring(0, fragmentPos);
        }
        if ((url = BasicURLNormalizer.parseStringToURL(urlString = BasicURLNormalizer.escapePath(urlString))) == null) {
            LOG.debug("Malformed URL {}", (Object)urlString);
            return null;
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        Object file = url.getFile();
        boolean changed = false;
        boolean normalizePath = false;
        if (!urlString.startsWith(protocol)) {
            changed = true;
        }
        if ("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol)) {
            if (host != null && url.getAuthority() != null) {
                String newHost;
                try {
                    newHost = this.normalizeHostName(host);
                }
                catch (UnsupportedEncodingException | IllegalArgumentException | IndexOutOfBoundsException e) {
                    LOG.info("Invalid hostname: {}", (Object)host, (Object)e);
                    return null;
                }
                if (!host.equals(newHost)) {
                    host = newHost;
                    changed = true;
                } else if (!url.getAuthority().equals(newHost)) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            if (port == url.getDefaultPort()) {
                port = -1;
                changed = true;
            }
            normalizePath = true;
            if (file == null || "".equals(file)) {
                file = "/";
                changed = true;
                normalizePath = false;
            } else if (!((String)file).startsWith("/")) {
                file = "/" + (String)file;
                changed = true;
                normalizePath = false;
            }
            if (url.getRef() != null) {
                changed = true;
            }
        } else if (protocol.equals("file")) {
            normalizePath = true;
        }
        if (!((String)file).equals(file2 = this.normalizeUrlFile((String)file))) {
            changed = true;
            file = file2;
        }
        if (normalizePath) {
            try {
                if (changed) {
                    tempUrl = protocol + "://" + (host == null ? "" : host) + (String)(port == -1 ? "" : ":" + port) + (String)file;
                    file2 = this.getFileWithNormalizedPath(new URI(tempUrl));
                } else {
                    file2 = this.getFileWithNormalizedPath(new URI(urlString));
                }
                if (!((String)file).equals(file2)) {
                    changed = true;
                    file = file2;
                }
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                LOG.info("Malformed URL {}://{}{}{}", new Object[]{protocol, host, port == -1 ? "" : ":" + port, file});
                return null;
            }
        }
        if (changed) {
            try {
                tempUrl = protocol + "://" + (host == null ? "" : host) + (String)(port == -1 ? "" : ":" + port) + (String)file;
                urlString = new URI(tempUrl).toURL().toString();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                LOG.info("Malformed URL {}://{}{}{}", new Object[]{protocol, host, port == -1 ? "" : ":" + port, file});
                return null;
            }
        }
        return urlString;
    }

    private static URL parseStringToURL(String urlString) {
        URL url;
        block4: {
            url = null;
            try {
                url = new URI(urlString).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                if (hasSchemePattern.matcher(urlString).find()) break block4;
                try {
                    url = new URI("http://" + urlString).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    private String normalizeUrlFile(String file) {
        int endPathIdx = file.indexOf(63);
        if (endPathIdx == -1) {
            return BasicURLNormalizer.unescapePath(file);
        }
        int queryStartIdx = endPathIdx + 1;
        if (queryStartIdx >= file.length()) {
            String path = file.substring(0, file.length() - 1);
            return BasicURLNormalizer.unescapePath(path);
        }
        file = BasicURLNormalizer.unescapePath(file);
        List<NameValuePair> pairs = BasicURLNormalizer.parseQueryParameters(file, queryStartIdx, this.queryParamsToRemove);
        StringBuilder normalizedFile = new StringBuilder();
        String path = file.substring(0, endPathIdx);
        if (!path.isBlank()) {
            normalizedFile.append(path);
        }
        if (!pairs.isEmpty()) {
            pairs.sort(NameValuePair.NAME_COMPARATOR);
            normalizedFile.append('?').append(BasicURLNormalizer.formatQueryParameters(pairs));
        }
        return normalizedFile.toString();
    }

    public static List<NameValuePair> parseQueryParameters(String s, int queryStartIdx, Set<String> queryElementsToRemove) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        char c = s.charAt(queryStartIdx);
        int len = s.length();
        for (int i = queryStartIdx; i < len; ++i) {
            int nameBeginIdx = i;
            while (i < len && !BasicURLNormalizer.isNameEnd(c = s.charAt(i))) {
                ++i;
            }
            String name = s.substring(nameBeginIdx, i);
            String value = null;
            if (i < len && c == '=') {
                int valueBeginIdx = ++i;
                while (i < len && !BasicURLNormalizer.isValueEnd(c = s.charAt(i))) {
                    ++i;
                }
                if (valueBeginIdx < i) {
                    value = s.substring(valueBeginIdx, i);
                }
            }
            if (name.isEmpty() || queryElementsToRemove == null || queryElementsToRemove.contains(name)) continue;
            list.add(new NameValuePair(name, value));
        }
        return list;
    }

    private static boolean isValueEnd(char c) {
        return c == '&';
    }

    private static boolean isNameEnd(char c) {
        return c == '=' || c == '&';
    }

    public static String formatQueryParameters(List<NameValuePair> parameters) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair parameter : parameters) {
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(parameter.getName());
            String value = parameter.getValue();
            if (value == null) continue;
            result.append('=');
            result.append(value);
        }
        return result.toString();
    }

    private String getFileWithNormalizedPath(URI uri) {
        String path = uri.getRawPath();
        if (hasNormalizablePathPattern.matcher(path).find()) {
            path = uri.normalize().getRawPath();
            int start = 0;
            while (path.startsWith("/..", start) && (start + 3 == path.length() || path.charAt(3) == '/')) {
                start += 3;
            }
            if (start > 0) {
                path = path.substring(start);
            }
        }
        if (path.isEmpty()) {
            path = "/";
        }
        if (uri.getRawQuery() == null) {
            return path;
        }
        return path + "?" + uri.getRawQuery();
    }

    public static String unescapePath(String path) {
        int letter;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = unescapeRulePattern.matcher(path);
        int end = -1;
        while (matcher.find()) {
            sb.append(path, end + 1, matcher.start());
            letter = Integer.valueOf(matcher.group().substring(1), 16);
            if (letter < 128 && unescapedCharacters[letter]) {
                sb.append(Character.valueOf((char)letter));
            } else {
                sb.append(matcher.group().toUpperCase(Locale.ROOT));
            }
            end = matcher.start() + 2;
        }
        letter = path.length();
        if (end <= letter - 1) {
            sb.append(path, end + 1, letter);
        }
        return sb.toString();
    }

    public static String escapePath(String path) {
        return BasicURLNormalizer.escapePath(path, null);
    }

    public static String escapePath(String path, boolean[] extraEscapedBytes) {
        StringBuilder sb = new StringBuilder(path.length());
        byte[] bytes = path.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b < 0 || escapedCharacters[b] || extraEscapedBytes != null && extraEscapedBytes[b]) {
                sb.append('%');
                String hex = Integer.toHexString(b & 0xFF).toUpperCase(Locale.ROOT);
                if (hex.length() % 2 != 0) {
                    sb.append('0');
                    sb.append(hex);
                    continue;
                }
                sb.append(hex);
                continue;
            }
            if (b == 37) {
                if (i + 2 >= bytes.length) {
                    sb.append("%25");
                    continue;
                }
                byte e1 = bytes[i + 1];
                byte e2 = bytes[i + 2];
                if (BasicURLNormalizer.isHexCharacter(e1) && BasicURLNormalizer.isHexCharacter(e2)) {
                    i += 2;
                    sb.append((char)b);
                    sb.append((char)e1);
                    sb.append((char)e2);
                    continue;
                }
                sb.append("%25");
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private String normalizeHostName(String host) throws IllegalArgumentException, IndexOutOfBoundsException, UnsupportedEncodingException {
        if (host.indexOf(37) != -1) {
            host = URLDecoder.decode(host, StandardCharsets.UTF_8.toString());
        }
        host = host.toLowerCase(Locale.ROOT);
        if (this.idnNormalization == IdnNormalization.PUNYCODE && !BasicURLNormalizer.isAscii(host)) {
            host = IDN.toASCII(host, 1);
        } else if (this.idnNormalization == IdnNormalization.UNICODE && host.contains("xn--")) {
            host = IDN.toUnicode(host, 1);
        }
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static void main(String[] args) throws IOException {
        String line;
        BasicURLNormalizer normalizer = new BasicURLNormalizer();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            String normUrl = normalizer.filter(line);
            LOG.info("{} => {}", (Object)line, (Object)normUrl);
        }
        System.exit(0);
    }

    static {
        int c;
        LOG = LoggerFactory.getLogger(BasicURLNormalizer.class);
        hasNormalizablePathPattern = Pattern.compile("/[./]|[.]/");
        unescapeRulePattern = Pattern.compile("%([0-9A-Fa-f]{2})");
        hasSchemePattern = Pattern.compile("^[A-Za-z][A-Za-z0-9+.-]*:/");
        unescapedCharacters = new boolean[128];
        for (c = 0; c < 128; ++c) {
            BasicURLNormalizer.unescapedCharacters[c] = BasicURLNormalizer.isAlphaNumeric(c) || c == 45 || c == 46 || c == 95 || c == 126;
        }
        escapedCharacters = new boolean[128];
        for (c = 0; c < 128; ++c) {
            if (unescapedCharacters[c]) {
                BasicURLNormalizer.escapedCharacters[c] = false;
                continue;
            }
            if (c <= 31 || c == 32 || c == 34 || c == 35 || c == 60 || c == 62 || c == 91 || c == 93 || c == 94 || c == 96 || c == 123 || c == 124 || c == 125 || c == 127) {
                BasicURLNormalizer.escapedCharacters[c] = true;
                continue;
            }
            LOG.debug("Character {} ({}) not handled as escaped or unescaped", (Object)c, (Object)Character.valueOf((char)c));
        }
    }

    public static class Builder {
        public IdnNormalization idnNormalization = IdnNormalization.PUNYCODE;
        Set<String> queryParamsToRemove = new TreeSet<String>();

        private Builder() {
        }

        public Builder queryParamsToRemove(Collection<String> queryParamsToRemove) {
            this.queryParamsToRemove = new TreeSet<String>(queryParamsToRemove);
            return this;
        }

        public Builder idnNormalization(IdnNormalization idnNormalization) {
            this.idnNormalization = idnNormalization;
            return this;
        }

        public BasicURLNormalizer build() {
            return new BasicURLNormalizer(this);
        }
    }

    public static enum IdnNormalization {
        NONE,
        PUNYCODE,
        UNICODE;

    }

    private static class NameValuePair {
        protected final String name;
        protected final String value;
        public static final Comparator<NameValuePair> NAME_COMPARATOR = Comparator.comparing(NameValuePair::getName);

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

