/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    private static final Set<String> UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", "index.history.uuid"));
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterSettings clusterSettings;
    private static final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ClusterSettings clusterSettings, ShardLimitValidator shardLimitValidator) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        if (DiscoveryNode.isMasterNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterService.getClusterSettings();
        this.shardLimitValidator = shardLimitValidator;
    }

    public void restoreSnapshot(RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener) {
        try {
            String repositoryName = request.repository();
            Repository repository = this.repositoriesService.repository(repositoryName);
            StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
            repository.getRepositoryData(repositoryDataListener);
            repositoryDataListener.whenComplete((CheckedConsumer<RepositoryData, Exception>)((CheckedConsumer)repositoryData -> {
                Metadata.Builder metadataBuilder;
                HashMap<String, DataStream> dataStreams;
                String snapshotName = request.snapshot();
                Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
                if (!matchingSnapshotId.isPresent()) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
                }
                final SnapshotId snapshotId = matchingSnapshotId.get();
                if (request.snapshotUuid() != null && !request.snapshotUuid().equals(snapshotId.getUUID())) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot UUID mismatch: expected [" + request.snapshotUuid() + "] but got [" + snapshotId.getUUID() + "]");
                }
                final SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
                final Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
                RestoreService.validateSnapshotRestorable(repositoryName, snapshotInfo);
                Metadata globalMetadata = null;
                ArrayList<String> requestIndices = new ArrayList<String>(Arrays.asList(request.indices()));
                List<String> requestedDataStreams = SnapshotUtils.filterIndices(snapshotInfo.dataStreams(), requestIndices.toArray(new String[0]), IndicesOptions.fromOptions(true, true, true, true));
                if (requestedDataStreams.isEmpty()) {
                    dataStreams = new HashMap<String, DataStream>();
                } else {
                    globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    Map<String, DataStream> dataStreamsInSnapshot = globalMetadata.dataStreams();
                    dataStreams = new HashMap(requestedDataStreams.size());
                    for (String requestedDataStream : requestedDataStreams) {
                        DataStream dataStreamInSnapshot = dataStreamsInSnapshot.get(requestedDataStream);
                        assert (dataStreamInSnapshot != null) : "DataStream [" + requestedDataStream + "] not found in snapshot";
                        dataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    }
                }
                requestIndices.removeAll(dataStreams.keySet());
                Set<String> dataStreamIndices = dataStreams.values().stream().flatMap(ds -> ds.getIndices().stream()).map(Index::getName).collect(Collectors.toSet());
                requestIndices.addAll(dataStreamIndices);
                List<String> indicesInSnapshot = SnapshotUtils.filterIndices(snapshotInfo.indices(), requestIndices.toArray(new String[0]), request.indicesOptions());
                if (request.includeGlobalState()) {
                    if (globalMetadata == null) {
                        globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    }
                    metadataBuilder = Metadata.builder(globalMetadata);
                } else {
                    metadataBuilder = Metadata.builder();
                }
                List<IndexId> indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
                for (IndexId indexId : indexIdsInSnapshot) {
                    metadataBuilder.put(repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, snapshotId, indexId), false);
                }
                Metadata metadata = metadataBuilder.build();
                final Map<String, String> indices = RestoreService.renamedIndices(request, indicesInSnapshot, dataStreamIndices);
                this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + ']', new ClusterStateUpdateTask((RepositoryData)repositoryData, metadata, request, dataStreams, listener){
                    final String restoreUUID = UUIDs.randomBase64UUID();
                    RestoreInfo restoreInfo = null;
                    final /* synthetic */ RepositoryData val$repositoryData;
                    final /* synthetic */ Metadata val$metadata;
                    final /* synthetic */ RestoreSnapshotRequest val$request;
                    final /* synthetic */ Map val$dataStreams;
                    final /* synthetic */ ActionListener val$listener;
                    {
                        this.val$repositoryData = repositoryData;
                        this.val$metadata = metadata;
                        this.val$request = restoreSnapshotRequest;
                        this.val$dataStreams = map2;
                        this.val$listener = actionListener;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
                        RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
                        if (currentState.getNodes().getMinNodeVersion().before(Version.V_7_0_0) && !restoreInProgress.isEmpty()) {
                            throw new ConcurrentSnapshotExecutionException(snapshot, "Restore process is already running in this cluster");
                        }
                        SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                        if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(snapshotId))) {
                            throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + deletionsInProgress.getEntries().get(0) + "]");
                        }
                        ClusterState.Builder builder = ClusterState.builder(currentState);
                        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                        RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                        HashSet<String> aliases = new HashSet<String>();
                        if (!indices.isEmpty()) {
                            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
                            Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                            for (Map.Entry indexEntry : indices.entrySet()) {
                                Index renamedIndex;
                                IndexMetadata updatedIndexMetadata;
                                String index = (String)indexEntry.getValue();
                                boolean partial = this.checkPartial(index);
                                RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, snapshot, snapshotInfo.version(), this.val$repositoryData.resolveIndexId(index));
                                String renamedIndexName = (String)indexEntry.getKey();
                                IndexMetadata snapshotIndexMetadata = this.val$metadata.index(index);
                                snapshotIndexMetadata = this.updateIndexSettings(snapshotIndexMetadata, this.val$request.indexSettings(), this.val$request.ignoreIndexSettings());
                                try {
                                    snapshotIndexMetadata = RestoreService.this.metadataIndexUpgradeService.upgradeIndexMetadata(snapshotIndexMetadata, minIndexCompatibilityVersion);
                                }
                                catch (Exception ex) {
                                    throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                                }
                                IndexMetadata currentIndexMetadata = currentState.metadata().index(renamedIndexName);
                                IntHashSet ignoreShards = new IntHashSet();
                                if (currentIndexMetadata == null) {
                                    boolean isHidden = IndexMetadata.INDEX_HIDDEN_SETTING.get(snapshotIndexMetadata.getSettings());
                                    RestoreService.this.createIndexService.validateIndexName(renamedIndexName, currentState);
                                    RestoreService.this.createIndexService.validateDotIndex(renamedIndexName, isHidden);
                                    RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName);
                                    indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                    RestoreService.this.shardLimitValidator.validateShardLimit(snapshotIndexMetadata.getSettings(), currentState);
                                    if (!this.val$request.includeAliases() && !snapshotIndexMetadata.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    } else {
                                        for (ObjectCursor alias : snapshotIndexMetadata.getAliases().keys()) {
                                            aliases.add((String)alias.value);
                                        }
                                    }
                                    updatedIndexMetadata = indexMdBuilder.build();
                                    if (partial) {
                                        this.populateIgnoredShards(index, (IntSet)ignoreShards);
                                    }
                                    rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, (IntSet)ignoreShards);
                                    blocks.addBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                } else {
                                    this.validateExistingIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                                    indexMdBuilder.version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion()));
                                    indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion()));
                                    indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion()));
                                    indexMdBuilder.aliasesVersion(Math.max(snapshotIndexMetadata.getAliasesVersion(), 1L + currentIndexMetadata.getAliasesVersion()));
                                    for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                        indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
                                    }
                                    if (!this.val$request.includeAliases()) {
                                        if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                                            indexMdBuilder.removeAllAliases();
                                        }
                                        for (ObjectCursor alias : currentIndexMetadata.getAliases().values()) {
                                            indexMdBuilder.putAlias((AliasMetadata)alias.value);
                                        }
                                    } else {
                                        for (ObjectCursor alias : snapshotIndexMetadata.getAliases().keys()) {
                                            aliases.add((String)alias.value);
                                        }
                                    }
                                    Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID());
                                    if (snapshotIndexMetadata.getCreationVersion().onOrAfter(Version.V_7_9_0) || currentState.nodes().getMinNodeVersion().onOrAfter(Version.V_7_9_0)) {
                                        indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
                                    }
                                    indexMdBuilder.settings(indexSettingsBuilder);
                                    updatedIndexMetadata = indexMdBuilder.index(renamedIndexName).build();
                                    rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                                    blocks.updateBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                }
                                for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                    if (!ignoreShards.contains(shard)) {
                                        shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                        continue;
                                    }
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                                }
                            }
                            shards = shardsBuilder.build();
                            RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards);
                            builder.putCustom("restore", new RestoreInProgress.Builder(currentState.custom("restore", RestoreInProgress.EMPTY)).add(restoreEntry).build());
                        } else {
                            shards = ImmutableOpenMap.of();
                        }
                        this.checkAliasNameConflicts(indices, aliases);
                        HashMap<String, DataStream> updatedDataStreams = new HashMap<String, DataStream>(currentState.metadata().dataStreams());
                        updatedDataStreams.putAll(this.val$dataStreams.values().stream().map(ds -> RestoreService.updateDataStream(ds, mdBuilder, this.val$request)).collect(Collectors.toMap(DataStream::getName, Function.identity())));
                        mdBuilder.dataStreams(updatedDataStreams);
                        if (this.val$request.includeGlobalState()) {
                            if (this.val$metadata.persistentSettings() != null) {
                                Iterator<ObjectObjectCursor<String, Metadata.Custom>> settings = this.val$metadata.persistentSettings();
                                RestoreService.this.clusterSettings.validateUpdate((Settings)((Object)settings));
                                mdBuilder.persistentSettings((Settings)((Object)settings));
                            }
                            if (this.val$metadata.templates() != null) {
                                for (ObjectObjectCursor<String, Metadata.Custom> cursor : this.val$metadata.templates().values()) {
                                    mdBuilder.put((IndexTemplateMetadata)cursor.value);
                                }
                            }
                            if (this.val$metadata.customs() != null) {
                                for (ObjectObjectCursor<String, Metadata.Custom> cursor : this.val$metadata.customs()) {
                                    if ("repositories".equals(cursor.key) || "data_stream".equals(cursor.key)) continue;
                                    mdBuilder.putCustom((String)cursor.key, (Metadata.Custom)cursor.value);
                                }
                            }
                        }
                        if (RestoreService.completed(shards)) {
                            this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
                        }
                        RoutingTable rt = rtBuilder.build();
                        ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
                        return RestoreService.this.allocationService.reroute(updatedState, "restored snapshot [" + snapshot + "]");
                    }

                    private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
                        for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                            if (!aliases.contains(renamedIndex.getKey())) continue;
                            throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                        }
                    }

                    private void populateIgnoredShards(String index, IntSet ignoreShards) {
                        for (SnapshotShardFailure failure : snapshotInfo.shardFailures()) {
                            if (!index.equals(failure.index())) continue;
                            ignoreShards.add(failure.shardId());
                        }
                    }

                    private boolean checkPartial(String index) {
                        if (RestoreService.failed(snapshotInfo, index)) {
                            if (this.val$request.partial()) {
                                return true;
                            }
                            throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                        }
                        return false;
                    }

                    private void validateExistingIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
                        if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
                        }
                        if (partial) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                        }
                        if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
                        }
                    }

                    private IndexMetadata updateIndexSettings(IndexMetadata indexMetadata, Settings changeSettings, String[] ignoreSettings) {
                        Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
                        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(changeSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(changeSettings).booleanValue()) {
                            throw new SnapshotRestoreException(snapshot, "cannot disable setting [" + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + "] on restore");
                        }
                        IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
                        Settings settings = indexMetadata.getSettings();
                        HashSet<String> keyFilters = new HashSet<String>();
                        ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                        for (String ignoredSetting : ignoreSettings) {
                            if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                                if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                                }
                                keyFilters.add(ignoredSetting);
                                continue;
                            }
                            simpleMatchPatterns.add(ignoredSetting);
                        }
                        Predicate<String> settingsFilter = k -> {
                            if (!UNREMOVABLE_SETTINGS.contains(k)) {
                                for (String filterKey : keyFilters) {
                                    if (!k.equals(filterKey)) continue;
                                    return false;
                                }
                                for (String pattern : simpleMatchPatterns) {
                                    if (!Regex.simpleMatch(pattern, k)) continue;
                                    return false;
                                }
                            }
                            return true;
                        };
                        Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                            if (UNMODIFIABLE_SETTINGS.contains(k)) {
                                throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
                            }
                            return true;
                        }));
                        settingsBuilder.remove(MetadataIndexStateService.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                        return builder.settings(settingsBuilder).build();
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                        this.val$listener.onFailure(e);
                    }

                    @Override
                    public TimeValue timeout() {
                        return this.val$request.masterNodeTimeout();
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        this.val$listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, snapshot, this.restoreInfo));
                    }
                });
            }), listener::onFailure);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repository() + ":" + request.snapshot())), (Throwable)e);
            listener.onFailure(e);
        }
    }

    static DataStream updateDataStream(DataStream dataStream, Metadata.Builder metadata, RestoreSnapshotRequest request) {
        String dataStreamName = dataStream.getName();
        if (request.renamePattern() != null && request.renameReplacement() != null) {
            dataStreamName = dataStreamName.replaceAll(request.renamePattern(), request.renameReplacement());
        }
        List<Index> updatedIndices = dataStream.getIndices().stream().map(i -> metadata.get(RestoreService.renameIndex(i.getName(), request, true)).getIndex()).collect(Collectors.toList());
        return new DataStream(dataStreamName, dataStream.getTimeStampField(), updatedIndices, dataStream.getGeneration());
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return state.custom("restore", RestoreInProgress.EMPTY).get(restoreUUID);
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        for (RestoreInProgress.Entry entry : event.state().custom("restore", RestoreInProgress.EMPTY)) {
            if (!entry.state().completed()) continue;
            assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
            this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build(Priority.URGENT), cleanRestoreStateTaskExecutor, cleanRestoreStateTaskExecutor);
        }
    }

    private static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor status : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private static Map<String, String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices, Set<String> dataStreamIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        for (String index : filteredIndices) {
            String renamedIndex = RestoreService.renameIndex(index, request, dataStreamIndices.contains(index));
            String previousIndex = renamedIndices.put(renamedIndex, index);
            if (previousIndex == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private static String renameIndex(String index, RestoreSnapshotRequest request, boolean partOfDataStream) {
        String renamedIndex = index;
        if (request.renameReplacement() != null && request.renamePattern() != null) {
            boolean bl = partOfDataStream = partOfDataStream && index.startsWith(".ds-");
            if (partOfDataStream) {
                index = index.substring(".ds-".length());
            }
            renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            if (partOfDataStream) {
                renamedIndex = ".ds-" + renamedIndex;
            }
        }
        return renamedIndex;
    }

    private static void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + (Object)((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    public static boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                Index index = ((ShardId)objectObjectCursor.key).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || currentState.getMetadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
        cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor();
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        CleanRestoreStateTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            boolean changed = false;
            for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
                if (completedRestores.contains(entry.uuid())) {
                    changed = true;
                    continue;
                }
                restoreInProgressBuilder.add(entry);
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.getCustoms());
            builder.put("restore", restoreInProgressBuilder.build());
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>> shardChanges = new HashMap<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes(recoverySource).put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes(recoverySource).put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes(unassignedShard.recoverySource()).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + initializedShard.recoverySource()));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(recoverySource).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Map<ShardId, RestoreInProgress.ShardRestoreStatus> changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new HashMap());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> updates = this.shardChanges.get(entry.uuid());
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

