/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.io.IOException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;

public final class TaskOperationFailure
implements Writeable,
ToXContentFragment {
    private static final String TASK_ID = "task_id";
    private static final String NODE_ID = "node_id";
    private static final String STATUS = "status";
    private static final String REASON = "reason";
    private final String nodeId;
    private final long taskId;
    private final Exception reason;
    private final RestStatus status;
    private static final ConstructingObjectParser<TaskOperationFailure, Void> PARSER = new ConstructingObjectParser("task_info", true, constructorObjects -> {
        int i = 0;
        String nodeId = (String)constructorObjects[i++];
        long taskId = (Long)constructorObjects[i++];
        OpenSearchException reason = (OpenSearchException)constructorObjects[i];
        return new TaskOperationFailure(nodeId, taskId, reason);
    });

    public TaskOperationFailure(String nodeId, long taskId, Exception e) {
        this.nodeId = nodeId;
        this.taskId = taskId;
        this.reason = e;
        this.status = ExceptionsHelper.status(e);
    }

    public TaskOperationFailure(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.taskId = in.readLong();
        this.reason = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeLong(this.taskId);
        out.writeException(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public RestStatus getStatus() {
        return this.status;
    }

    public Exception getCause() {
        return this.reason;
    }

    public String toString() {
        return "[" + this.nodeId + "][" + this.taskId + "] failed, reason [" + this.reason + "]";
    }

    public static TaskOperationFailure fromXContent(XContentParser parser) {
        return (TaskOperationFailure)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TASK_ID, this.getTaskId());
        builder.field(NODE_ID, this.getNodeId());
        builder.field(STATUS, this.status.name());
        if (this.reason != null) {
            builder.field(REASON);
            builder.startObject();
            OpenSearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
        }
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(NODE_ID, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(TASK_ID, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> OpenSearchException.fromXContent(parser), new ParseField(REASON, new String[0]));
    }
}

