/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.Prefetch;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.Remote;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.List;
import org.apache.wicket.util.lang.Args;

public class Dataset
extends AbstractConfig {
    private static final IKey<String> Name = Dataset.newKey((String)"name", null);
    private static final IKey<String> ValueKey = Dataset.newKey((String)"valueKey", (Object)"value");
    private static final IKey<Integer> Limit = Dataset.newKey((String)"limit", (Object)5);
    private static final IKey<String> Template = Dataset.newKey((String)"template", null);
    private static final IKey<String> Header = Dataset.newKey((String)"header", null);
    private static final IKey<String> Footer = Dataset.newKey((String)"footer", null);
    private static final IKey<Json.RawValue> Engine = Dataset.newKey((String)"engine", null);
    private static final IKey<Remote> Remote = Dataset.newKey((String)"remote", null);
    private static final IKey<Prefetch> Prefetch = Dataset.newKey((String)"prefetch", null);
    private static final IKey<List> Local = Dataset.newKey((String)"local", null);

    public Dataset(String name) {
        this.withName(name);
    }

    public Dataset withName(String name) {
        Args.notEmpty((String)name, (String)"name");
        this.put(Name, name);
        return this;
    }

    public Dataset withValueKey(String valueKey) {
        Args.notEmpty((String)valueKey, (String)"valueKey");
        this.put(ValueKey, valueKey);
        return this;
    }

    public Dataset withLimit(int limit) {
        this.put(Limit, limit);
        return this;
    }

    public Dataset withTemplate(String template) {
        Args.notEmpty((String)template, (String)"template");
        this.put(Template, template);
        return this;
    }

    public Dataset withEngine(Json.RawValue engine) {
        Args.notNull((Object)engine, (String)"engine");
        this.put(Engine, engine);
        return this;
    }

    public Dataset withHeader(String header) {
        Args.notEmpty((String)header, (String)"header");
        this.put(Header, header);
        return this;
    }

    public Dataset withFooter(String footer) {
        Args.notEmpty((String)footer, (String)"footer");
        this.put(Footer, footer);
        return this;
    }

    public Dataset withRemote(Remote remote) {
        Args.notNull((Object)((Object)remote), (String)"remote");
        this.put(Remote, (Object)remote);
        return this;
    }

    public Dataset withPrefetch(Prefetch prefetch) {
        Args.notNull((Object)((Object)prefetch), (String)"prefetch");
        this.put(Prefetch, (Object)prefetch);
        return this;
    }

    public <T> Dataset withLocal(List<T> local) {
        Args.notEmpty(local, (String)"local");
        this.put(Local, local);
        return this;
    }

    public Remote getRemote() {
        return (Remote)((Object)this.get(Remote));
    }
}

