/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.notifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.openmeetings.core.notifier.INotifier;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NotifierService {
    private static final Logger log = LoggerFactory.getLogger(NotifierService.class);
    private List<INotifier> notifiers = new ArrayList<INotifier>();

    public void addNotifier(INotifier n) {
        this.notifiers.add(n);
    }

    public void notify(User u, Appointment a, Invitation inv) {
        if (inv == null) {
            log.error("Error retrieving Invitation for member {} in Appointment {}", (Object)u.getAddress().getEmail(), (Object)a.getTitle());
            return;
        }
        for (INotifier n : this.notifiers) {
            try {
                n.notify(u, a, inv);
            }
            catch (Exception e) {
                log.error("Unexpected exception while sending notifications", (Throwable)e);
            }
        }
    }
}

