/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The "setAttributeNode(newAttr)" method raises an
 * "INUSE_ATTRIBUTE_ERR DOMException if the "newAttr"
 * is already an attribute of another element.
 * <p>
 * Retrieve the first emp:address and append
 * a newly created element.  The "createAttributeNS(namespaceURI,qualifiedName)"
 * and "setAttributeNodeNS(newAttr)" methods are invoked
 * to create and add a new attribute to the newly created
 * Element.  The "setAttributeNodeNS(newAttr)" method is
 * once again called to add the new attribute causing an
 * exception to be raised since the attribute is already
 * an attribute of another element.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])</a>
 */
public class setAttributeNodeNS01 {
    @Test
    void testRun() throws Throwable {
        String namespaceURI = "http://www.newattr.com";
        String qualifiedName = "emp:newAttr";
        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagName("emp:address");
        Node testAddr = elementList.item(0);
        Element newElement = doc.createElement("newElement");
        Node appendedChild = testAddr.appendChild(newElement);
        Attr newAttr = doc.createAttributeNS(namespaceURI, qualifiedName);
        Attr setAttr1 = newElement.setAttributeNodeNS(newAttr);

        DOMException ex = assertThrows(DOMException.class, () -> ((Element) /*Node */testAddr).setAttributeNodeNS(newAttr));
        assertEquals(DOMException.INUSE_ATTRIBUTE_ERR, ex.code, "throw_INUSE_ATTRIBUTE_ERR");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNodeNS01";
    }

}
