/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java8.RuntimeMetricsBuilder;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RuntimeMetrics
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(RuntimeMetrics.class.getName());
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final List<AutoCloseable> observables;

    RuntimeMetrics(List<AutoCloseable> observables) {
        this.observables = Collections.unmodifiableList(observables);
    }

    public static RuntimeMetrics create(OpenTelemetry openTelemetry) {
        return new RuntimeMetricsBuilder(openTelemetry).build();
    }

    public static RuntimeMetricsBuilder builder(OpenTelemetry openTelemetry) {
        return new RuntimeMetricsBuilder(openTelemetry);
    }

    @Override
    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            logger.log(Level.WARNING, "RuntimeMetrics is already closed");
            return;
        }
        JmxRuntimeMetricsUtil.closeObservers(this.observables);
    }
}

