/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import com.google.common.collect.Range;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerAttributes;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionBound;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.jspecify.annotations.Nullable;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedLedger {
    public String getName();

    public Position addEntry(byte[] var1) throws InterruptedException, ManagedLedgerException;

    public Position addEntry(byte[] var1, int var2) throws InterruptedException, ManagedLedgerException;

    public void asyncAddEntry(byte[] var1, AsyncCallbacks.AddEntryCallback var2, Object var3);

    public Position addEntry(byte[] var1, int var2, int var3) throws InterruptedException, ManagedLedgerException;

    public Position addEntry(byte[] var1, int var2, int var3, int var4) throws InterruptedException, ManagedLedgerException;

    public void asyncAddEntry(byte[] var1, int var2, int var3, AsyncCallbacks.AddEntryCallback var4, Object var5);

    public void asyncAddEntry(byte[] var1, int var2, int var3, int var4, AsyncCallbacks.AddEntryCallback var5, Object var6);

    public void asyncAddEntry(ByteBuf var1, AsyncCallbacks.AddEntryCallback var2, Object var3);

    public void asyncAddEntry(ByteBuf var1, int var2, AsyncCallbacks.AddEntryCallback var3, Object var4);

    public ManagedCursor openCursor(String var1) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor openCursor(String var1, CommandSubscribe.InitialPosition var2) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor openCursor(String var1, CommandSubscribe.InitialPosition var2, Map<String, Long> var3, Map<String, String> var4) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1) throws ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1, String var2) throws ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1, String var2, CommandSubscribe.InitialPosition var3, boolean var4) throws ManagedLedgerException;

    public void asyncDeleteCursor(String var1, AsyncCallbacks.DeleteCursorCallback var2, Object var3);

    public void deleteCursor(String var1) throws InterruptedException, ManagedLedgerException;

    public void removeWaitingCursor(ManagedCursor var1);

    public void asyncOpenCursor(String var1, AsyncCallbacks.OpenCursorCallback var2, Object var3);

    public void asyncOpenCursor(String var1, CommandSubscribe.InitialPosition var2, AsyncCallbacks.OpenCursorCallback var3, Object var4);

    public void asyncOpenCursor(String var1, CommandSubscribe.InitialPosition var2, Map<String, Long> var3, Map<String, String> var4, AsyncCallbacks.OpenCursorCallback var5, Object var6);

    public Iterable<ManagedCursor> getCursors();

    public Iterable<ManagedCursor> getActiveCursors();

    public long getNumberOfEntries();

    public long getNumberOfEntries(Range<Position> var1);

    public long getNumberOfActiveEntries();

    public long getTotalSize();

    public long getEstimatedBacklogSize();

    public CompletableFuture<Long> getEarliestMessagePublishTimeInBacklog();

    public long getOffloadedSize();

    default public void unfenceForInterceptorException() {
    }

    public long getLastOffloadedLedgerId();

    public long getLastOffloadedSuccessTimestamp();

    public long getLastOffloadedFailureTimestamp();

    public void asyncTerminate(AsyncCallbacks.TerminateCallback var1, Object var2);

    public CompletableFuture<Position> asyncMigrate();

    public Position terminate() throws InterruptedException, ManagedLedgerException;

    public void close() throws InterruptedException, ManagedLedgerException;

    public void asyncClose(AsyncCallbacks.CloseCallback var1, Object var2);

    public ManagedLedgerMXBean getStats();

    public void delete() throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(AsyncCallbacks.DeleteLedgerCallback var1, Object var2);

    public Position offloadPrefix(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncOffloadPrefix(Position var1, AsyncCallbacks.OffloadCallback var2, Object var3);

    public @Nullable ManagedCursor getSlowestConsumer();

    public boolean isTerminated();

    public boolean isMigrated();

    public ManagedLedgerConfig getConfig();

    public void setConfig(ManagedLedgerConfig var1);

    public Position getLastConfirmedEntry();

    public void readyToCreateNewLedger();

    public Map<String, String> getProperties();

    public void setProperty(String var1, String var2) throws InterruptedException, ManagedLedgerException;

    public void asyncSetProperty(String var1, String var2, AsyncCallbacks.UpdatePropertiesCallback var3, Object var4);

    public void deleteProperty(String var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDeleteProperty(String var1, AsyncCallbacks.UpdatePropertiesCallback var2, Object var3);

    public void setProperties(Map<String, String> var1) throws InterruptedException, ManagedLedgerException;

    public void asyncSetProperties(Map<String, String> var1, AsyncCallbacks.UpdatePropertiesCallback var2, Object var3);

    public void trimConsumedLedgersInBackground(CompletableFuture<?> var1);

    default public void rolloverCursorsInBackground() {
    }

    default public void skipNonRecoverableLedger(long ledgerId) {
    }

    @Deprecated
    public void rollCurrentLedgerIfFull();

    public CompletableFuture<Position> asyncFindPosition(Predicate<Entry> var1);

    public ManagedLedgerInterceptor getManagedLedgerInterceptor();

    public CompletableFuture<MLDataFormats.ManagedLedgerInfo.LedgerInfo> getLedgerInfo(long var1);

    public Optional<MLDataFormats.ManagedLedgerInfo.LedgerInfo> getOptionalLedgerInfo(long var1);

    public CompletableFuture<Void> asyncTruncate();

    public CompletableFuture<ManagedLedgerInternalStats> getManagedLedgerInternalStats(boolean var1);

    public boolean checkInactiveLedgerAndRollOver();

    public void checkCursorsToCacheEntries();

    default public ManagedLedgerAttributes getManagedLedgerAttributes() {
        return new ManagedLedgerAttributes(this);
    }

    public void asyncReadEntry(Position var1, AsyncCallbacks.ReadEntryCallback var2, Object var3);

    public NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> getLedgersInfo();

    public Position getNextValidPosition(Position var1);

    public Position getPreviousPosition(Position var1);

    public long getEstimatedBacklogSize(Position var1);

    public Position getPositionAfterN(Position var1, long var2, PositionBound var4);

    public int getPendingAddEntriesCount();

    public long getCacheSize();

    default public CompletableFuture<Position> getLastDispatchablePosition(Predicate<Entry> predicate, Position startPosition) {
        return CompletableFuture.completedFuture(PositionFactory.EARLIEST);
    }

    public Position getFirstPosition();

    default public long getLastAddEntryTime() {
        return 0L;
    }

    default public long getMetadataCreationTimestamp() {
        return 0L;
    }
}

