/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.protonj2.client.ConnectionOptions;
import org.apache.qpid.protonj2.client.SessionOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamSession;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.Session;

final class ClientSessionBuilder {
    private final AtomicInteger sessionCounter = new AtomicInteger();
    private final ClientConnection connection;
    private final ConnectionOptions connectionOptions;
    private volatile SessionOptions defaultSessionOptions;

    ClientSessionBuilder(ClientConnection connection) {
        this.connection = connection;
        this.connectionOptions = connection.getOptions();
    }

    public ClientSession session(SessionOptions sessionOptions) throws ClientException {
        SessionOptions options = sessionOptions != null ? sessionOptions : this.getDefaultSessionOptions();
        String sessionId = this.nextSessionId();
        Session protonSession = ClientSessionBuilder.createSession(this.connection.getProtonConnection(), options);
        return new ClientSession(this.connection, options, sessionId, protonSession);
    }

    public ClientStreamSession streamSession(SessionOptions sessionOptions) throws ClientException {
        SessionOptions options = sessionOptions != null ? sessionOptions : this.getDefaultSessionOptions();
        String sessionId = this.nextSessionId();
        Session protonSession = ClientSessionBuilder.createSession(this.connection.getProtonConnection(), options);
        return new ClientStreamSession(this.connection, options, sessionId, protonSession);
    }

    private static Session createSession(Connection connection, SessionOptions options) {
        return connection.session().setIncomingCapacity(options.incomingCapacity()).setOutgoingCapacity(options.outgoingCapacity());
    }

    public static Session recreateSession(ClientConnection connection, Session previousSession, SessionOptions options) {
        return connection.getProtonConnection().session().setIncomingCapacity(options.incomingCapacity()).setOutgoingCapacity(options.outgoingCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionOptions getDefaultSessionOptions() {
        SessionOptions sessionOptions = this.defaultSessionOptions;
        if (sessionOptions == null) {
            ClientSessionBuilder clientSessionBuilder = this;
            synchronized (clientSessionBuilder) {
                sessionOptions = this.defaultSessionOptions;
                if (sessionOptions == null) {
                    sessionOptions = new SessionOptions();
                    sessionOptions.openTimeout(this.connectionOptions.openTimeout());
                    sessionOptions.closeTimeout(this.connectionOptions.closeTimeout());
                    sessionOptions.requestTimeout(this.connectionOptions.requestTimeout());
                    sessionOptions.sendTimeout(this.connectionOptions.sendTimeout());
                    sessionOptions.drainTimeout(this.connectionOptions.drainTimeout());
                    sessionOptions.defaultNextReceiverPolicy(this.connectionOptions.defaultNextReceiverPolicy());
                }
                this.defaultSessionOptions = sessionOptions;
            }
        }
        return sessionOptions;
    }

    String nextSessionId() {
        return this.connection.getId() + ":" + this.sessionCounter.incrementAndGet();
    }
}

