/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;

public class StringUtils {
    private static final int DEFAULT_QUOTED_STRING_LIMIT = 64;

    public static Symbol[] toSymbolArray(String[] stringArray) {
        Symbol[] result = null;
        if (stringArray != null) {
            result = new Symbol[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                result[i] = Symbol.valueOf(stringArray[i]);
            }
        }
        return result;
    }

    public static String[] toStringArray(Symbol[] symbolArray) {
        String[] result = null;
        if (symbolArray != null) {
            result = new String[symbolArray.length];
            for (int i = 0; i < symbolArray.length; ++i) {
                result[i] = symbolArray[i].toString();
            }
        }
        return result;
    }

    public static Map<Symbol, Object> toSymbolKeyedMap(Map<String, Object> stringsMap) {
        HashMap result;
        if (stringsMap != null) {
            result = new HashMap(stringsMap.size());
            stringsMap.forEach((key, value) -> result.put(Symbol.valueOf(key), value));
        } else {
            result = null;
        }
        return result;
    }

    public static Map<String, Object> toStringKeyedMap(Map<Symbol, Object> symbolMap) {
        LinkedHashMap result;
        if (symbolMap != null) {
            result = new LinkedHashMap(symbolMap.size());
            symbolMap.forEach((key, value) -> result.put(key.toString(), value));
        } else {
            result = null;
        }
        return result;
    }

    public static Symbol[] toSymbolArray(Collection<String> stringsSet) {
        Symbol[] result;
        if (stringsSet != null) {
            result = new Symbol[stringsSet.size()];
            int index = 0;
            for (String entry : stringsSet) {
                result[index++] = Symbol.valueOf(entry);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static Set<Symbol> toSymbolSet(Collection<String> stringsSet) {
        LinkedHashSet result;
        if (stringsSet != null) {
            result = new LinkedHashSet(stringsSet.size());
            stringsSet.forEach(entry -> result.add(Symbol.valueOf(entry)));
        } else {
            result = null;
        }
        return result;
    }

    public static Set<String> toStringSet(Symbol[] symbols) {
        LinkedHashSet<String> result;
        if (symbols != null) {
            result = new LinkedHashSet<String>(symbols.length);
            for (Symbol symbol : symbols) {
                result.add(symbol.toString());
            }
        } else {
            result = null;
        }
        return result;
    }

    public static String toQuotedString(Binary buffer) {
        return StringUtils.toQuotedString(buffer, 64, true);
    }

    public static String toQuotedString(Binary buffer, boolean appendIfTruncated) {
        return StringUtils.toQuotedString(buffer, 64, appendIfTruncated);
    }

    public static String toQuotedString(Binary buffer, int stringLength, boolean appendIfTruncated) {
        if (buffer == null) {
            return "\"\"";
        }
        return StringUtils.toQuotedString(buffer.asProtonBuffer(), stringLength, appendIfTruncated);
    }

    public static String toQuotedString(ProtonBuffer buffer) {
        return StringUtils.toQuotedString(buffer, 64, true);
    }

    public static String toQuotedString(ProtonBuffer buffer, boolean appendIfTruncated) {
        return StringUtils.toQuotedString(buffer, 64, appendIfTruncated);
    }

    public static String toQuotedString(ProtonBuffer buffer, int stringLength, boolean appendIfTruncated) {
        if (buffer == null) {
            return "\"\"";
        }
        StringBuilder str = new StringBuilder();
        str.append("\"");
        int byteToRead = buffer.getReadableBytes();
        int size = 0;
        boolean truncated = false;
        for (int i = 0; i < byteToRead; ++i) {
            byte c = buffer.getByte(i);
            if (c > 31 && c < 127 && c != 92) {
                if (size + 1 <= stringLength) {
                    ++size;
                    str.append((char)c);
                    continue;
                }
                truncated = true;
                break;
            }
            if (size + 4 <= stringLength) {
                size += 4;
                str.append(String.format("\\x%02x", c));
                continue;
            }
            truncated = true;
            break;
        }
        str.append("\"");
        if (truncated && appendIfTruncated) {
            str.append("...(truncated)");
        }
        return str.toString();
    }
}

