/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServicePolicies
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServicePolicies.class);
    private String serviceName;
    private Long serviceId;
    private Long policyVersion;
    private Date policyUpdateTime;
    private List<RangerPolicy> policies;
    private RangerServiceDef serviceDef;
    private String auditMode = "audit-default";
    private TagPolicies tagPolicies;
    private Map<String, SecurityZoneInfo> securityZones;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<RangerPolicyDelta> policyDeltas;
    private Map<String, String> serviceConfig;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Long getPolicyVersion() {
        return this.policyVersion;
    }

    public void setPolicyVersion(Long policyVersion) {
        this.policyVersion = policyVersion;
    }

    public Date getPolicyUpdateTime() {
        return this.policyUpdateTime;
    }

    public void setPolicyUpdateTime(Date policyUpdateTime) {
        this.policyUpdateTime = policyUpdateTime;
    }

    public Map<String, String> getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(Map<String, String> serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public List<RangerPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<RangerPolicy> policies) {
        this.policies = policies;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
    }

    public String getAuditMode() {
        return this.auditMode;
    }

    public void setAuditMode(String auditMode) {
        this.auditMode = auditMode;
    }

    public TagPolicies getTagPolicies() {
        return this.tagPolicies;
    }

    public void setTagPolicies(TagPolicies tagPolicies) {
        this.tagPolicies = tagPolicies;
    }

    public Map<String, SecurityZoneInfo> getSecurityZones() {
        return this.securityZones;
    }

    public void setSecurityZones(Map<String, SecurityZoneInfo> securityZones) {
        this.securityZones = securityZones;
    }

    public void dedupStrings() {
        HashMap<String, String> strTbl = new HashMap<String, String>();
        this.serviceName = StringUtil.dedupString(this.serviceName, strTbl);
        this.auditMode = StringUtil.dedupString(this.auditMode, strTbl);
        this.serviceConfig = StringUtil.dedupStringsMap(this.serviceConfig, strTbl);
        if (this.policies != null) {
            for (RangerPolicy policy : this.policies) {
                policy.dedupStrings(strTbl);
            }
        }
        if (this.serviceDef != null) {
            this.serviceDef.dedupStrings(strTbl);
        }
        if (this.tagPolicies != null) {
            this.tagPolicies.dedupStrings(strTbl);
        }
        if (this.securityZones != null) {
            for (SecurityZoneInfo securityZoneInfo : this.securityZones.values()) {
                securityZoneInfo.dedupStrings(strTbl);
            }
        }
        if (this.policyDeltas != null) {
            for (RangerPolicyDelta policyDelta : this.policyDeltas) {
                policyDelta.dedupStrings(strTbl);
            }
        }
    }

    public String toString() {
        return "serviceName=" + this.serviceName + ", serviceId=" + this.serviceId + ", policyVersion=" + this.policyVersion + ", policyUpdateTime=" + this.policyUpdateTime + ", policies=" + this.policies + ", tagPolicies=" + this.tagPolicies + ", policyDeltas=" + this.policyDeltas + ", serviceDef=" + this.serviceDef + ", auditMode=" + this.auditMode + ", securityZones=" + this.securityZones;
    }

    public List<RangerPolicyDelta> getPolicyDeltas() {
        return this.policyDeltas;
    }

    public void setPolicyDeltas(List<RangerPolicyDelta> policyDeltas) {
        this.policyDeltas = policyDeltas;
    }

    public static ServicePolicies copyHeader(ServicePolicies source) {
        ServicePolicies ret = new ServicePolicies();
        ret.setServiceName(source.getServiceName());
        ret.setServiceId(source.getServiceId());
        ret.setPolicyVersion(source.getPolicyVersion());
        ret.setAuditMode(source.getAuditMode());
        ret.setServiceDef(source.getServiceDef());
        ret.setPolicyUpdateTime(source.getPolicyUpdateTime());
        ret.setSecurityZones(source.getSecurityZones());
        ret.setPolicies(Collections.emptyList());
        ret.setPolicyDeltas(null);
        if (source.getTagPolicies() != null) {
            TagPolicies tagPolicies = ServicePolicies.copyHeader(source.getTagPolicies(), source.getServiceDef().getName());
            ret.setTagPolicies(tagPolicies);
        }
        return ret;
    }

    public static TagPolicies copyHeader(TagPolicies source, String componentServiceName) {
        TagPolicies ret = new TagPolicies();
        ret.setServiceName(source.getServiceName());
        ret.setServiceId(source.getServiceId());
        ret.setPolicyVersion(source.getPolicyVersion());
        ret.setAuditMode(source.getAuditMode());
        ret.setServiceDef(ServiceDefUtil.normalizeAccessTypeDefs(source.getServiceDef(), componentServiceName));
        ret.setPolicyUpdateTime(source.getPolicyUpdateTime());
        ret.setPolicies(Collections.emptyList());
        return ret;
    }

    public static ServicePolicies applyDelta(ServicePolicies servicePolicies, RangerPolicyEngineImpl policyEngine) {
        List<RangerPolicy> newTagPolicies;
        ServicePolicies ret = ServicePolicies.copyHeader(servicePolicies);
        List<RangerPolicy> oldResourcePolicies = policyEngine.getResourcePolicies();
        List<RangerPolicy> oldTagPolicies = policyEngine.getTagPolicies();
        List<RangerPolicy> newResourcePolicies = RangerPolicyDeltaUtil.applyDeltas(oldResourcePolicies, servicePolicies.getPolicyDeltas(), servicePolicies.getServiceDef().getName());
        ret.setPolicies(newResourcePolicies);
        if (servicePolicies.getTagPolicies() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("applyingDeltas for tag policies");
            }
            newTagPolicies = RangerPolicyDeltaUtil.applyDeltas(oldTagPolicies, servicePolicies.getPolicyDeltas(), servicePolicies.getTagPolicies().getServiceDef().getName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No need to apply deltas for tag policies");
            }
            newTagPolicies = oldTagPolicies;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("New tag policies:[" + Arrays.toString(newTagPolicies.toArray()) + "]");
        }
        if (ret.getTagPolicies() != null) {
            ret.getTagPolicies().setPolicies(newTagPolicies);
        }
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            HashMap<String, SecurityZoneInfo> newSecurityZones = new HashMap<String, SecurityZoneInfo>();
            for (Map.Entry<String, SecurityZoneInfo> entry : servicePolicies.getSecurityZones().entrySet()) {
                String zoneName = entry.getKey();
                SecurityZoneInfo zoneInfo = entry.getValue();
                List<RangerPolicy> zoneResourcePolicies = policyEngine.getResourcePolicies(zoneName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Applying deltas for security-zone:[" + zoneName + "]");
                }
                List<RangerPolicy> newZonePolicies = RangerPolicyDeltaUtil.applyDeltas(zoneResourcePolicies, zoneInfo.getPolicyDeltas(), servicePolicies.getServiceDef().getName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New resource policies for security-zone:[" + zoneName + "], zoneResourcePolicies:[" + Arrays.toString(newZonePolicies.toArray()) + "]");
                }
                SecurityZoneInfo newZoneInfo = new SecurityZoneInfo();
                newZoneInfo.setZoneName(zoneName);
                newZoneInfo.setResources(zoneInfo.getResources());
                newZoneInfo.setPolicies(newZonePolicies);
                newSecurityZones.put(zoneName, newZoneInfo);
            }
            ret.setSecurityZones(newSecurityZones);
        }
        return ret;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityZoneInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String zoneName;
        private List<HashMap<String, List<String>>> resources;
        private List<RangerPolicy> policies;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<RangerPolicyDelta> policyDeltas;
        private Boolean containsAssociatedTagService;

        public String getZoneName() {
            return this.zoneName;
        }

        public List<HashMap<String, List<String>>> getResources() {
            return this.resources;
        }

        public List<RangerPolicy> getPolicies() {
            return this.policies;
        }

        public List<RangerPolicyDelta> getPolicyDeltas() {
            return this.policyDeltas;
        }

        public Boolean getContainsAssociatedTagService() {
            return this.containsAssociatedTagService;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public void setResources(List<HashMap<String, List<String>>> resources) {
            this.resources = resources;
        }

        public void setPolicies(List<RangerPolicy> policies) {
            this.policies = policies;
        }

        public void setPolicyDeltas(List<RangerPolicyDelta> policyDeltas) {
            this.policyDeltas = policyDeltas;
        }

        public void setContainsAssociatedTagService(Boolean containsAssociatedTagService) {
            this.containsAssociatedTagService = containsAssociatedTagService;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.zoneName = StringUtil.dedupString(this.zoneName, strTbl);
            if (this.resources != null && this.resources.size() > 0) {
                ArrayList<HashMap<String, List<String>>> updated = new ArrayList<HashMap<String, List<String>>>(this.resources.size());
                for (HashMap<String, List<String>> resource : this.resources) {
                    updated.add(StringUtil.dedupStringsHashMapOfList(resource, strTbl));
                }
                this.resources = updated;
            }
            if (this.policies != null) {
                for (RangerPolicy policy : this.policies) {
                    policy.dedupStrings(strTbl);
                }
            }
            if (this.policyDeltas != null) {
                for (RangerPolicyDelta policyDelta : this.policyDeltas) {
                    policyDelta.dedupStrings(strTbl);
                }
            }
        }

        public String toString() {
            return "zoneName=" + this.zoneName + ", resources=" + this.resources + ", policies=" + this.policies + ", policyDeltas=" + this.policyDeltas + ", containsAssociatedTagService=" + this.containsAssociatedTagService;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TagPolicies
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String serviceName;
        private Long serviceId;
        private Long policyVersion;
        private Date policyUpdateTime;
        private List<RangerPolicy> policies;
        private RangerServiceDef serviceDef;
        private String auditMode = "audit-default";
        private Map<String, String> serviceConfig;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public Long getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(Long serviceId) {
            this.serviceId = serviceId;
        }

        public Long getPolicyVersion() {
            return this.policyVersion;
        }

        public void setPolicyVersion(Long policyVersion) {
            this.policyVersion = policyVersion;
        }

        public Date getPolicyUpdateTime() {
            return this.policyUpdateTime;
        }

        public void setPolicyUpdateTime(Date policyUpdateTime) {
            this.policyUpdateTime = policyUpdateTime;
        }

        public List<RangerPolicy> getPolicies() {
            return this.policies;
        }

        public void setPolicies(List<RangerPolicy> policies) {
            this.policies = policies;
        }

        public RangerServiceDef getServiceDef() {
            return this.serviceDef;
        }

        public void setServiceDef(RangerServiceDef serviceDef) {
            this.serviceDef = serviceDef;
        }

        public String getAuditMode() {
            return this.auditMode;
        }

        public void setAuditMode(String auditMode) {
            this.auditMode = auditMode;
        }

        public Map<String, String> getServiceConfig() {
            return this.serviceConfig;
        }

        public void setServiceConfig(Map<String, String> serviceConfig) {
            this.serviceConfig = serviceConfig;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.serviceName = StringUtil.dedupString(this.serviceName, strTbl);
            this.auditMode = StringUtil.dedupString(this.auditMode, strTbl);
            this.serviceConfig = StringUtil.dedupStringsMap(this.serviceConfig, strTbl);
            if (this.policies != null) {
                for (RangerPolicy policy : this.policies) {
                    policy.dedupStrings(strTbl);
                }
            }
            if (this.serviceDef != null) {
                this.serviceDef.dedupStrings(strTbl);
            }
        }

        public String toString() {
            return "serviceName=" + this.serviceName + ", serviceId=" + this.serviceId + ", policyVersion=" + this.policyVersion + ", policyUpdateTime=" + this.policyUpdateTime + ", policies=" + this.policies + ", serviceDef=" + this.serviceDef + ", auditMode=" + this.auditMode + "serviceConfig=" + this.serviceConfig;
        }
    }
}

