/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ProducerChangeListener;
import org.apache.rocketmq.broker.client.ProducerGroupEvent;
import org.apache.rocketmq.broker.util.PositiveAtomicCounter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.body.ProducerInfo;
import org.apache.rocketmq.remoting.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class ProducerManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private static final int GET_AVAILABLE_CHANNEL_RETRY_COUNT = 3;
    private final ConcurrentMap<String, ConcurrentMap<Channel, ClientChannelInfo>> groupChannelTable = new ConcurrentHashMap<String, ConcurrentMap<Channel, ClientChannelInfo>>();
    private final ConcurrentMap<String, Channel> clientChannelTable = new ConcurrentHashMap<String, Channel>();
    protected final BrokerStatsManager brokerStatsManager;
    private final PositiveAtomicCounter positiveAtomicCounter = new PositiveAtomicCounter();
    private final List<ProducerChangeListener> producerChangeListenerList = new CopyOnWriteArrayList<ProducerChangeListener>();

    public ProducerManager() {
        this.brokerStatsManager = null;
    }

    public ProducerManager(BrokerStatsManager brokerStatsManager) {
        this.brokerStatsManager = brokerStatsManager;
    }

    public int groupSize() {
        return this.groupChannelTable.size();
    }

    public boolean groupOnline(String group) {
        Map channels = (Map)this.groupChannelTable.get(group);
        return channels != null && !channels.isEmpty();
    }

    public ConcurrentMap<String, ConcurrentMap<Channel, ClientChannelInfo>> getGroupChannelTable() {
        return this.groupChannelTable;
    }

    public ProducerTableInfo getProducerTable() {
        HashMap<String, ArrayList<ProducerInfo>> map = new HashMap<String, ArrayList<ProducerInfo>>();
        for (String group : this.groupChannelTable.keySet()) {
            for (Map.Entry entry : ((ConcurrentMap)this.groupChannelTable.get(group)).entrySet()) {
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)entry.getValue();
                if (map.containsKey(group)) {
                    ((List)map.get(group)).add(new ProducerInfo(clientChannelInfo.getClientId(), clientChannelInfo.getChannel().remoteAddress().toString(), clientChannelInfo.getLanguage(), clientChannelInfo.getVersion(), clientChannelInfo.getLastUpdateTimestamp()));
                    continue;
                }
                map.put(group, new ArrayList<ProducerInfo>(Collections.singleton(new ProducerInfo(clientChannelInfo.getClientId(), clientChannelInfo.getChannel().remoteAddress().toString(), clientChannelInfo.getLanguage(), clientChannelInfo.getVersion(), clientChannelInfo.getLastUpdateTimestamp()))));
            }
        }
        return new ProducerTableInfo(map);
    }

    public void scanNotActiveChannel() {
        Iterator iterator = this.groupChannelTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String group = (String)entry.getKey();
            ConcurrentMap chlMap = (ConcurrentMap)entry.getValue();
            Iterator it = chlMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry item = it.next();
                ClientChannelInfo info = (ClientChannelInfo)item.getValue();
                long diff = System.currentTimeMillis() - info.getLastUpdateTimestamp();
                if (diff <= 120000L) continue;
                it.remove();
                Channel channelInClientTable = (Channel)this.clientChannelTable.get(info.getClientId());
                if (channelInClientTable != null && channelInClientTable.equals(info.getChannel())) {
                    this.clientChannelTable.remove(info.getClientId());
                }
                log.warn("ProducerManager#scanNotActiveChannel: remove expired channel[{}] from ProducerManager groupChannelTable, producer group name: {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()), (Object)group);
                this.callProducerChangeListener(ProducerGroupEvent.CLIENT_UNREGISTER, group, info);
                RemotingHelper.closeChannel((Channel)info.getChannel());
            }
            if (!chlMap.isEmpty()) continue;
            log.warn("SCAN: remove expired channel from ProducerManager groupChannelTable, all clear, group={}", (Object)group);
            iterator.remove();
            this.callProducerChangeListener(ProducerGroupEvent.GROUP_UNREGISTER, group, null);
        }
    }

    public boolean doChannelCloseEvent(String remoteAddr, Channel channel) {
        boolean removed = false;
        if (channel != null) {
            for (Map.Entry entry : this.groupChannelTable.entrySet()) {
                ConcurrentMap oldGroupTable;
                String group = (String)entry.getKey();
                ConcurrentMap clientChannelInfoTable = (ConcurrentMap)entry.getValue();
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)clientChannelInfoTable.remove(channel);
                if (clientChannelInfo == null) continue;
                this.clientChannelTable.remove(clientChannelInfo.getClientId());
                removed = true;
                log.info("NETTY EVENT: remove channel[{}][{}] from ProducerManager groupChannelTable, producer group: {}", new Object[]{clientChannelInfo.toString(), remoteAddr, group});
                this.callProducerChangeListener(ProducerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo);
                if (!clientChannelInfoTable.isEmpty() || (oldGroupTable = (ConcurrentMap)this.groupChannelTable.remove(group)) == null) continue;
                log.info("unregister a producer group[{}] from groupChannelTable", (Object)group);
                this.callProducerChangeListener(ProducerGroupEvent.GROUP_UNREGISTER, group, null);
            }
        }
        return removed;
    }

    public void registerProducer(String group, ClientChannelInfo clientChannelInfo) {
        ClientChannelInfo clientChannelInfoFound;
        ConcurrentMap<Object, ClientChannelInfo> channelTable = (ConcurrentHashMap<Channel, ClientChannelInfo>)this.groupChannelTable.get(group);
        if (null == channelTable) {
            channelTable = new ConcurrentHashMap<Channel, ClientChannelInfo>();
            channelTable.put(clientChannelInfo.getChannel(), clientChannelInfo);
            ConcurrentMap prev = this.groupChannelTable.putIfAbsent(group, channelTable);
            if (null == prev) {
                this.clientChannelTable.put(clientChannelInfo.getClientId(), clientChannelInfo.getChannel());
            } else {
                channelTable = prev;
            }
        }
        if (null == (clientChannelInfoFound = (ClientChannelInfo)channelTable.get(clientChannelInfo.getChannel()))) {
            channelTable.put(clientChannelInfo.getChannel(), clientChannelInfo);
            this.clientChannelTable.put(clientChannelInfo.getClientId(), clientChannelInfo.getChannel());
            log.info("new producer connected, group: {} channel: {}", (Object)group, (Object)clientChannelInfo.toString());
        }
        if (clientChannelInfoFound != null) {
            clientChannelInfoFound.setLastUpdateTimestamp(System.currentTimeMillis());
        }
    }

    public void unregisterProducer(String group, ClientChannelInfo clientChannelInfo) {
        ConcurrentMap channelTable = (ConcurrentMap)this.groupChannelTable.get(group);
        if (null != channelTable && !channelTable.isEmpty()) {
            ClientChannelInfo old = (ClientChannelInfo)channelTable.remove(clientChannelInfo.getChannel());
            this.clientChannelTable.remove(clientChannelInfo.getClientId());
            if (old != null) {
                log.info("unregister a producer[{}] from groupChannelTable {}", (Object)group, (Object)clientChannelInfo.toString());
                this.callProducerChangeListener(ProducerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo);
            }
            if (channelTable.isEmpty()) {
                this.groupChannelTable.remove(group);
                this.callProducerChangeListener(ProducerGroupEvent.GROUP_UNREGISTER, group, null);
                log.info("unregister a producer group[{}] from groupChannelTable", (Object)group);
            }
        }
    }

    public Channel getAvailableChannel(String groupId) {
        boolean isOk;
        if (groupId == null) {
            return null;
        }
        ConcurrentMap channelClientChannelInfoHashMap = (ConcurrentMap)this.groupChannelTable.get(groupId);
        if (channelClientChannelInfoHashMap == null) {
            log.warn("Check transaction failed, channel table is empty. groupId={}", (Object)groupId);
            return null;
        }
        ArrayList channelList = new ArrayList(channelClientChannelInfoHashMap.keySet());
        int size = channelList.size();
        if (0 == size) {
            log.warn("Channel list is empty. groupId={}", (Object)groupId);
            return null;
        }
        Channel lastActiveChannel = null;
        int index = this.positiveAtomicCounter.incrementAndGet() % size;
        Channel channel = (Channel)channelList.get(index);
        int count = 0;
        boolean bl = isOk = channel.isActive() && channel.isWritable();
        while (count++ < 3) {
            if (isOk) {
                return channel;
            }
            if (channel.isActive()) {
                lastActiveChannel = channel;
            }
            ++index;
            channel = (Channel)channelList.get(index %= size);
            isOk = channel.isActive() && channel.isWritable();
        }
        return lastActiveChannel;
    }

    public Channel findChannel(String clientId) {
        return (Channel)this.clientChannelTable.get(clientId);
    }

    private void callProducerChangeListener(ProducerGroupEvent event, String group, ClientChannelInfo clientChannelInfo) {
        for (ProducerChangeListener listener : this.producerChangeListenerList) {
            try {
                listener.handle(event, group, clientChannelInfo);
            }
            catch (Throwable t) {
                log.error("err when call producerChangeListener", t);
            }
        }
    }

    public void appendProducerChangeListener(ProducerChangeListener producerChangeListener) {
        this.producerChangeListenerList.add(producerChangeListener);
    }
}

