/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.remoting.protocol.body.PopProcessQueueInfo;

public class PopProcessQueue {
    private static final long PULL_MAX_IDLE_TIME = Long.parseLong(System.getProperty("rocketmq.client.pull.pullMaxIdleTime", "120000"));
    private long lastPopTimestamp = System.currentTimeMillis();
    private AtomicInteger waitAckCounter = new AtomicInteger(0);
    private volatile boolean dropped = false;

    public long getLastPopTimestamp() {
        return this.lastPopTimestamp;
    }

    public void setLastPopTimestamp(long lastPopTimestamp) {
        this.lastPopTimestamp = lastPopTimestamp;
    }

    public void incFoundMsg(int count) {
        this.waitAckCounter.getAndAdd(count);
    }

    public int ack() {
        return this.waitAckCounter.getAndDecrement();
    }

    public void decFoundMsg(int count) {
        this.waitAckCounter.addAndGet(count);
    }

    public int getWaiAckMsgCount() {
        return this.waitAckCounter.get();
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void setDropped(boolean dropped) {
        this.dropped = dropped;
    }

    public void fillPopProcessQueueInfo(PopProcessQueueInfo info) {
        info.setWaitAckCount(this.getWaiAckMsgCount());
        info.setDroped(this.isDropped());
        info.setLastPopTimestamp(this.getLastPopTimestamp());
    }

    public boolean isPullExpired() {
        return System.currentTimeMillis() - this.lastPopTimestamp > PULL_MAX_IDLE_TIME;
    }

    public String toString() {
        return "PopProcessQueue[waitAckCounter:" + this.waitAckCounter.get() + ", lastPopTimestamp:" + this.getLastPopTimestamp() + ", drop:" + this.dropped + "]";
    }
}

