/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.fasterxml.jackson.dataformat.javaprop;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.Base64Variant;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.FormatSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.SerializableString;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.StreamWriteCapability;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.Version;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.base.GeneratorBase;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.io.IOContext;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.json.JsonWriteContext;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import org.apache.seatunnel.shade.com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import org.apache.seatunnel.shade.com.fasterxml.jackson.dataformat.javaprop.io.JPropWriteContext;
import org.apache.seatunnel.shade.com.fasterxml.jackson.dataformat.javaprop.util.Markers;

public abstract class JavaPropsGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 100;
    protected static final JsonWriteContext BOGUS_WRITE_CONTEXT = JsonWriteContext.createRootContext(null);
    private static final JavaPropsSchema EMPTY_SCHEMA = JavaPropsSchema.emptySchema();
    protected final IOContext _ioContext;
    protected JavaPropsSchema _schema = EMPTY_SCHEMA;
    protected JPropWriteContext _jpropContext;
    protected final StringBuilder _basePath = new StringBuilder(50);
    protected boolean _headerChecked;
    protected int _indentLength;

    public JavaPropsGenerator(IOContext ctxt, int stdFeatures, ObjectCodec codec) {
        super(stdFeatures, codec, BOGUS_WRITE_CONTEXT);
        this._ioContext = ctxt;
        this._jpropContext = JPropWriteContext.createRootContext();
    }

    @Override
    public Object getCurrentValue() {
        return this._jpropContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object v) {
        this._jpropContext.setCurrentValue(v);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    @Override
    public void setSchema(FormatSchema schema) {
        if (schema instanceof JavaPropsSchema) {
            this._schema = (JavaPropsSchema)schema;
            if (this._jpropContext.inRoot()) {
                String prefix;
                String indent = this._schema.lineIndentation();
                int n = this._indentLength = indent == null ? 0 : indent.length();
                if (this._indentLength > 0) {
                    this._basePath.setLength(0);
                    this._basePath.append(indent);
                    this._jpropContext = JPropWriteContext.createRootContext(this._indentLength);
                }
                if ((prefix = this._schema.prefix()) != null) {
                    this._basePath.append(prefix);
                }
            }
            return;
        }
        super.setSchema(schema);
    }

    @Override
    public FormatSchema getSchema() {
        return this._schema;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof JavaPropsSchema;
    }

    @Override
    public boolean canWriteObjectId() {
        return false;
    }

    @Override
    public boolean canWriteTypeId() {
        return false;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return false;
    }

    @Override
    public boolean canOmitFields() {
        return true;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._jpropContext;
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        String sep;
        if (!this._jpropContext.writeFieldName(name)) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (!this._headerChecked) {
            this._headerChecked = true;
            String header = this._schema.header();
            if (header != null && !header.isEmpty()) {
                this._writeRaw(header);
            }
        }
        this._jpropContext.truncatePath(this._basePath);
        if (this._basePath.length() > this._indentLength && !(sep = this._schema.pathSeparator()).isEmpty()) {
            this._basePath.append(sep);
        }
        this._appendFieldName(this._basePath, name);
    }

    protected abstract void _appendFieldName(StringBuilder var1, String var2);

    @Override
    public void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._jpropContext = this._jpropContext.createChildArrayContext(this._basePath.length());
    }

    @Override
    public void writeEndArray() throws IOException {
        if (!this._jpropContext.inArray()) {
            this._reportError("Current context not an Array but " + this._jpropContext.typeDesc());
        }
        this._jpropContext = this._jpropContext.getParent();
    }

    @Override
    public void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._jpropContext = this._jpropContext.createChildObjectContext(this._basePath.length());
    }

    @Override
    public void writeEndObject() throws IOException {
        if (!this._jpropContext.inObject()) {
            this._reportError("Current context not an Ibject but " + this._jpropContext.typeDesc());
        }
        this._jpropContext = this._jpropContext.getParent();
    }

    @Override
    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(text);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(text, offset, len);
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    @Override
    public void writeRaw(String text) throws IOException {
        this._writeRaw(text);
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        this._writeRaw(text.substring(offset, offset + len));
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char c) throws IOException {
        this._writeRaw(c);
    }

    @Override
    public void writeRaw(SerializableString text) throws IOException, JsonGenerationException {
        this.writeRaw(text.toString());
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeEscapedEntry(encoded);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        this._writeUnescapedEntry(state ? "true" : "false");
    }

    @Override
    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(i));
    }

    @Override
    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(l));
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(v));
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeUnescapedEntry(str);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(encodedValue);
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeUnescapedEntry("");
    }

    @Override
    protected void _verifyValueWrite(String typeMsg) throws IOException {
        if (!this._jpropContext.writeValue()) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this._jpropContext.inArray()) {
            this._jpropContext.truncatePath(this._basePath);
            int ix = this._jpropContext.getCurrentIndex() + this._schema.firstArrayOffset();
            if (this._schema.writeIndexUsingMarkers()) {
                Markers m = this._schema.indexMarker();
                this._basePath.append(m.getStart());
                this._basePath.append(ix);
                this._basePath.append(m.getEnd());
            } else {
                String sep;
                if (this._basePath.length() > 0 && !(sep = this._schema.pathSeparator()).isEmpty()) {
                    this._basePath.append(sep);
                }
                this._basePath.append(ix);
            }
        }
    }

    protected abstract void _writeEscapedEntry(String var1) throws IOException;

    protected abstract void _writeEscapedEntry(char[] var1, int var2, int var3) throws IOException;

    protected abstract void _writeUnescapedEntry(String var1) throws IOException;

    protected abstract void _writeRaw(char var1) throws IOException;

    protected abstract void _writeRaw(String var1) throws IOException;

    protected abstract void _writeRaw(StringBuilder var1) throws IOException;

    protected abstract void _writeRaw(char[] var1, int var2, int var3) throws IOException;
}

